/*
 * Decompiled with CFR 0.152.
 */
package lysis;

import java.nio.ByteBuffer;

public class BitConverter {
    public static short ToInt16(byte[] bytes, int offset) {
        short result = (short)(bytes[offset] & 0xFF);
        result = (short)(result | (bytes[offset + 1] & 0xFF) << 8);
        return (short)(result & 0xFFFF);
    }

    public static int ToUInt16(byte[] bytes, int offset) {
        int result = bytes[offset + 1] & 0xFF;
        return (result |= (bytes[offset] & 0xFF) << 8) & 0xFFFF;
    }

    public static int ToInt32(byte[] bytes, int offset) {
        int result = bytes[offset] & 0xFF;
        result |= (bytes[offset + 1] & 0xFF) << 8;
        result |= (bytes[offset + 2] & 0xFF) << 16;
        return result |= (bytes[offset + 3] & 0xFF) << 24;
    }

    public static long ToUInt32(byte[] bytes, int offset) {
        long result = bytes[offset] & 0xFF;
        result |= (long)((bytes[offset + 1] & 0xFF) << 8);
        result |= (long)((bytes[offset + 2] & 0xFF) << 16);
        return (result |= (long)((bytes[offset + 3] & 0xFF) << 24)) & 0xFFFFFFFFL;
    }

    public static long ToUInt64(byte[] bytes, int offset) {
        long result = 0L;
        for (int i = 0; i <= 56; i += 8) {
            result |= (long)((bytes[offset++] & 0xFF) << i);
        }
        return result;
    }

    public static byte[] GetBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return bytes;
    }

    public static byte[] GetBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return bytes;
    }

    public static float ToSingle(byte[] b, long offset) {
        ByteBuffer buf = ByteBuffer.wrap(b, (int)offset, 4);
        return buf.getFloat();
    }
}

