/*
 * Decompiled with CFR 0.152.
 */
package lysis.builder;

import java.io.IOException;
import java.io.PrintStream;
import lysis.PawnFile;
import lysis.Public;
import lysis.builder.structure.BlockAnalysis;
import lysis.builder.structure.ControlBlock;
import lysis.builder.structure.GotoBlock;
import lysis.builder.structure.IfBlock;
import lysis.builder.structure.LogicChain;
import lysis.builder.structure.LogicOperator;
import lysis.builder.structure.ReturnBlock;
import lysis.builder.structure.StatementBlock;
import lysis.builder.structure.SwitchBlock;
import lysis.builder.structure.WhileLoop;
import lysis.lstructure.Argument;
import lysis.lstructure.Dimension;
import lysis.lstructure.Function;
import lysis.lstructure.Scope;
import lysis.lstructure.Tag;
import lysis.lstructure.Variable;
import lysis.lstructure.VariableType;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeList;
import lysis.nodes.NodeType;
import lysis.nodes.types.DArrayRef;
import lysis.nodes.types.DBinary;
import lysis.nodes.types.DBoolean;
import lysis.nodes.types.DCall;
import lysis.nodes.types.DCharacter;
import lysis.nodes.types.DConstant;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DDeclareStatic;
import lysis.nodes.types.DFloat;
import lysis.nodes.types.DFunction;
import lysis.nodes.types.DGenArray;
import lysis.nodes.types.DGlobal;
import lysis.nodes.types.DIncDec;
import lysis.nodes.types.DInlineArray;
import lysis.nodes.types.DJump;
import lysis.nodes.types.DJumpCondition;
import lysis.nodes.types.DLabel;
import lysis.nodes.types.DLoad;
import lysis.nodes.types.DLocalRef;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DReturn;
import lysis.nodes.types.DStore;
import lysis.nodes.types.DString;
import lysis.nodes.types.DSwitch;
import lysis.nodes.types.DSysReq;
import lysis.nodes.types.DTempName;
import lysis.nodes.types.DUnary;
import lysis.sourcepawn.SPOpcode;
import lysis.sourcepawn.SourcePawnFile;
import lysis.types.CellType;
import lysis.types.PawnType;
import lysis.types.TypeUnit;
import lysis.types.rtti.RttiType;

public class SourceBuilder {
    private PawnFile file_;
    private PrintStream out_;
    private String indent_;

    public SourceBuilder(PawnFile file, PrintStream tw) {
        this.file_ = file;
        this.out_ = tw;
        this.indent_ = "";
    }

    private void increaseIndent() {
        this.indent_ = this.indent_ + "\t";
    }

    private void decreaseIndent() {
        this.indent_ = this.indent_.substring(0, this.indent_.length() - 1);
    }

    private void outputLine(String text) {
        this.out_.println(this.indent_ + text);
    }

    private String indentLine(String text) {
        return this.indent_ + text;
    }

    private String prepareOutputLine(String text) {
        return this.indent_ + text + System.lineSeparator();
    }

    public static String spop(SPOpcode op) throws Exception {
        switch (op) {
            case add: {
                return "+";
            }
            case sub: 
            case sub_alt: 
            case neg: {
                return "-";
            }
            case less: 
            case sless: 
            case jsless: {
                return "<";
            }
            case grtr: 
            case sgrtr: 
            case jsgrtr: {
                return ">";
            }
            case leq: 
            case sleq: 
            case jsleq: {
                return "<=";
            }
            case geq: 
            case sgeq: 
            case jsgeq: {
                return ">=";
            }
            case eq: 
            case jeq: 
            case jzer: {
                return "==";
            }
            case jnz: 
            case jneq: 
            case neq: {
                return "!=";
            }
            case and: {
                return "&";
            }
            case not: {
                return "!";
            }
            case or: {
                return "|";
            }
            case sdiv: 
            case sdiv_alt: {
                return "/";
            }
            case sdiv_alt_mod: {
                return "%";
            }
            case smul: {
                return "*";
            }
            case shr: {
                return ">>";
            }
            case shl: {
                return "<<";
            }
            case invert: {
                return "~";
            }
            case xor: {
                return "^";
            }
            case sshr: {
                return ">>>";
            }
        }
        throw new Exception("NYI");
    }

    private String buildTag(PawnType type) {
        if (type.type() == CellType.Bool) {
            return "bool:";
        }
        if (type.type() == CellType.Float) {
            return "Float:";
        }
        if (type.type() == CellType.Tag) {
            return this.buildType(type.tag());
        }
        return "";
    }

    private String buildType(Variable var) {
        String prefix;
        if (var.tag() == null && var.rttiType() == null) {
            return "";
        }
        String string = prefix = var.type() == VariableType.Reference ? "&" : "";
        if (var.tag() != null) {
            return prefix + this.buildType(var.tag());
        }
        return prefix + this.buildType(var.rttiType());
    }

    private String buildType(Argument arg) {
        String prefix;
        if (arg.tag() == null && arg.rttiType() == null) {
            return "";
        }
        String string = prefix = arg.type() == VariableType.Reference ? "&" : "";
        if (arg.tag() != null) {
            return prefix + this.buildType(arg.tag());
        }
        return prefix + this.buildType(arg.rttiType());
    }

    private String buildType(Tag tag) {
        if (tag == null || tag.name().equals("_")) {
            return "";
        }
        return tag.name() + ":";
    }

    private String buildType(RttiType type) {
        switch (type.getTypeFlag()) {
            case 1: {
                return "bool:";
            }
            case 6: {
                return "";
            }
            case 12: {
                return "Float:";
            }
            case 14: {
                return "String:";
            }
            case 16: {
                return "any:";
            }
            case 17: {
                return "Function:";
            }
            case 112: {
                return "void:";
            }
            case 48: 
            case 49: {
                return this.buildType(type.getArrayBaseType());
            }
            case 66: {
                SourcePawnFile spf = (SourcePawnFile)this.file_;
                return spf.getEnumName((int)type.getData()) + ":";
            }
            case 67: {
                return "<typedef " + type.getData() + ">:";
            }
            case 68: {
                return "<typeset " + type.getData() + ">:";
            }
            case 69: {
                return "<classdef " + type.getData() + ">:";
            }
            case 70: {
                return "<enumstruct" + type.getData() + ">:";
            }
            case 50: {
                return this.buildType(type.getInnerType());
            }
        }
        return "";
    }

    private String buildType(Function func) {
        if (func.returnType() != null) {
            return this.buildType(func.returnType());
        }
        return this.buildType(func.returnTag());
    }

    private void writeSignature(NodeBlock entry) throws IOException {
        Function f = this.file_.lookupFunction(entry.lir().pc());
        if (f == null) {
            throw new IOException("Function not found.");
        }
        Public pub = this.file_.lookupPublic(entry.lir().pc());
        if (pub != null && !pub.name().matches("\\.\\d+\\..+")) {
            this.out_.print("public ");
        }
        this.out_.print(this.buildType(f) + f.name());
        this.out_.print("(");
        if (f.args() != null) {
            for (int i = 0; i < f.args().length; ++i) {
                this.out_.print(this.buildArgDeclaration(f.args()[i]));
                if (i == f.args().length - 1) continue;
                this.out_.print(", ");
            }
        }
        this.out_.print(")");
        this.out_.println(this.buildStateSignature(f));
    }

    private String buildStateSignature(Function func) {
        if (func.stateAddr() == -1L) {
            return "";
        }
        PawnFile.Automation automation = this.file_.lookupAutomation(func.stateAddr());
        if (automation == null) {
            return String.format("<%x:%d>", func.stateAddr(), func.stateId());
        }
        String ret = " <";
        if (automation.automation_id() > 0) {
            ret = ret + automation.name() + ":";
        }
        if (func.stateId() != -1) {
            String stateName = this.file_.lookupState(func.stateId(), automation.automation_id());
            ret = stateName != null ? ret + stateName : ret + func.stateId();
        }
        ret = ret + ">";
        return ret;
    }

    private String buildConstant(DConstant node) {
        TypeUnit tu;
        String prefix = "";
        if (node.typeSet().numTypes() == 1 && (tu = node.typeSet().types(0)).kind() == TypeUnit.Kind.Cell && tu.type().type() == CellType.Tag) {
            prefix = tu.type().tag() != null ? tu.type().tag().name() + ":" : "MissingTAG:";
        }
        return prefix + node.value();
    }

    private String buildString(String str) {
        str = str.replace("\r", "\\r");
        str = str.replace("\n", "\\n");
        str = str.replace("\"", "\\\"");
        str = this.replaceChatColorCharacters(str);
        return "\"" + str + "\"";
    }

    private String buildLocalRef(DLocalRef lref) {
        if (lref.getOperand(0).type() == NodeType.TempName) {
            return ((DTempName)lref.getOperand(0)).name();
        }
        if (lref.getOperand(0).type() == NodeType.Constant) {
            return "_unused_temp_";
        }
        if (lref.local() == null) {
            return "_NULLVAR_";
        }
        return lref.local().var().name();
    }

    private String buildArrayRef(DArrayRef aref) throws Exception {
        String lhs = this.buildExpression(aref.getOperand(0));
        String rhs = this.buildExpression(aref.getOperand(1));
        return lhs + "[" + rhs + "]";
    }

    private String buildUnary(DUnary unary) throws Exception {
        String rhs = this.buildExpression(unary.getOperand(0));
        return SourceBuilder.spop(unary.spop()) + rhs;
    }

    private String buildBinary(DBinary binary) throws Exception {
        String lhs = this.buildExpression(binary.getOperand(0));
        String rhs = this.buildExpression(binary.getOperand(1));
        return lhs + " " + SourceBuilder.spop(binary.spop()) + " " + rhs;
    }

    private String buildLoadStoreRef(DNode node) throws Exception {
        if (node == null) {
            return "unk__";
        }
        switch (node.type()) {
            case TempName: {
                DTempName temp = (DTempName)node;
                return temp.name();
            }
            case DeclareLocal: {
                DDeclareLocal local = (DDeclareLocal)node;
                return local.var().name();
            }
            case ArrayRef: {
                return this.buildArrayRef((DArrayRef)node);
            }
            case LocalRef: {
                DLocalRef lref = (DLocalRef)node;
                DDeclareLocal local = lref.local();
                if (local.var().type() == VariableType.ArrayReference || local.var().type() == VariableType.Array) {
                    return local.var().name() + "[0]";
                }
                if (local.var().type() == VariableType.Reference) {
                    return local.var().name();
                }
                throw new Exception("unknown local ref");
            }
            case Global: {
                DGlobal global = (DGlobal)node;
                if (global.var() == null) {
                    return "__unk";
                }
                return global.var().name();
            }
            case Load: {
                DLoad load = (DLoad)node;
                assert (load.from().type() == NodeType.DeclareLocal || load.from().type() == NodeType.ArrayRef || load.from().type() == NodeType.Global);
                return this.buildLoadStoreRef(load.from());
            }
            case Binary: {
                return this.buildBinary((DBinary)node) + "/* ERROR unknown load Binary */";
            }
            case Constant: {
                return this.buildConstant((DConstant)node) + "/* ERROR unknown load Constant */";
            }
            case GenArray: {
                return ((DGenArray)node).var().name();
            }
            case Call: {
                return this.buildCall((DCall)node) + "/* ERROR unknown load Call */";
            }
            case Unary: {
                return this.buildUnary((DUnary)node) + "/* ERROR unknown load Unary */";
            }
        }
        throw new Exception("unknown load " + (Object)((Object)node.type()));
    }

    private String buildLoad(DLoad load) throws Exception {
        return this.buildLoadStoreRef(load.getOperand(0));
    }

    private String buildSysReq(DSysReq sysreq) throws Exception {
        String args = "";
        for (int i = 0; i < sysreq.numOperands(); ++i) {
            DNode input = sysreq.getOperand(i);
            String arg = this.buildExpression(input);
            args = args + arg;
            if (i == sysreq.numOperands() - 1) continue;
            args = args + ", ";
        }
        return sysreq.nativeX().name() + "(" + args + ")";
    }

    private String buildCall(DCall call) throws Exception {
        String args = "";
        for (int i = 0; i < call.numOperands(); ++i) {
            DNode input = call.getOperand(i);
            String arg = this.buildExpression(input);
            args = args + arg;
            if (i == call.numOperands() - 1) continue;
            args = args + ", ";
        }
        return call.function().name() + "(" + args + ")";
    }

    private String buildStateChange(DStore store) throws Exception {
        String stateName;
        if (store.getOperand(0).type() != NodeType.Global) {
            return null;
        }
        DGlobal glob = (DGlobal)store.getOperand(0);
        if (!glob.var().isStateVariable()) {
            return null;
        }
        assert (store.getOperand(1).type() == NodeType.Constant);
        DConstant state = (DConstant)store.getOperand(1);
        PawnFile.Automation automation = this.file_.lookupAutomation(glob.var().address());
        if (automation == null) {
            return "state " + state.value();
        }
        String expr = "state ";
        if (automation.automation_id() > 0) {
            expr = expr + automation.name() + ":";
        }
        expr = (stateName = this.file_.lookupState((short)state.value(), automation.automation_id())) != null ? expr + stateName : expr + state.value();
        return expr;
    }

    private String buildStore(DStore store) throws Exception {
        String stateChange = this.buildStateChange(store);
        if (stateChange != null) {
            return stateChange;
        }
        String lhs = this.buildLoadStoreRef(store.getOperand(0));
        String rhs = store.logic() != null ? this.buildLogicChain(store.logic()) : this.buildExpression(store.getOperand(1));
        String eq = store.spop() == SPOpcode.nop ? "=" : SourceBuilder.spop(store.spop()) + "=";
        return lhs + " " + eq + " " + rhs;
    }

    private String buildInlineArray(DInlineArray ia, TypeUnit tu, DNode use) {
        Variable var = null;
        assert (use.type() == NodeType.DeclareLocal || use.type() == NodeType.DeclareStatic);
        if (use.type() == NodeType.DeclareLocal) {
            var = ((DDeclareLocal)use).var();
        } else if (use.type() == NodeType.DeclareStatic) {
            var = ((DDeclareStatic)use).var();
        }
        if (var == null) {
            return null;
        }
        assert (var.dims().length == tu.dims());
        String text = "{" + System.lineSeparator();
        this.increaseIndent();
        text = tu.isString() ? text + this.dumpStringArray(var, ia.address(), 0) : text + this.dumpArray(var, ia.address(), 0);
        this.decreaseIndent();
        text = text + this.indentLine("}");
        return text;
    }

    private String buildInlineArray(DInlineArray ia) {
        TypeUnit tu;
        if (ia.typeSet().numTypes() == 0) {
            tu = new TypeUnit(new PawnType(CellType.None), 1);
        } else {
            assert (ia.typeSet().numTypes() == 1);
            tu = ia.typeSet().types(0);
        }
        assert (tu.kind() == TypeUnit.Kind.Array);
        if (tu.dims() > 1 && ia.uses().size() > 0) {
            assert (ia.uses().size() == 1);
            DNode use = ia.uses().get(0).node();
            String text = this.buildInlineArray(ia, tu, use);
            if (text != null) {
                return text;
            }
        }
        assert (tu.dims() == 1);
        if (tu.isString()) {
            String s2 = this.file_.stringFromData(ia.address(), (int)ia.size() - 1);
            return this.buildString(s2);
        }
        String text = "{";
        int i = 0;
        while ((long)i < ia.size() / 4L) {
            if (tu.type().type() == CellType.Float) {
                float f = this.file_.floatFromData(ia.address() + (long)(i * 4));
                text = text + f;
            } else {
                long v = this.file_.int32FromData(ia.address() + (long)(i * 4));
                text = text + this.buildTag(tu.type()) + v;
            }
            if ((long)i != ia.size() / 4L - 1L) {
                text = text + ",";
            }
            ++i;
        }
        text = text + "}";
        return text;
    }

    private String buildBoolean(DBoolean node) {
        return node.value() ? "true" : "false";
    }

    private String buildFloat(DFloat node) {
        return Float.toString(node.value());
    }

    private String buildCharacter(DCharacter node) {
        String str = Character.valueOf(node.value()).toString();
        str = this.replaceChatColorCharacters(str);
        return "'" + str + "'";
    }

    private String buildFunction(DFunction node) {
        return node.function().name();
    }

    private String buildExpression(DNode node) throws Exception {
        switch (node.type()) {
            case Constant: {
                return this.buildConstant((DConstant)node);
            }
            case Boolean: {
                return this.buildBoolean((DBoolean)node);
            }
            case Float: {
                return this.buildFloat((DFloat)node);
            }
            case Character: {
                return this.buildCharacter((DCharacter)node);
            }
            case Function: {
                return this.buildFunction((DFunction)node);
            }
            case Load: {
                return this.buildLoad((DLoad)node);
            }
            case String: {
                return this.buildString(((DString)node).value());
            }
            case LocalRef: {
                return this.buildLocalRef((DLocalRef)node);
            }
            case ArrayRef: {
                return this.buildArrayRef((DArrayRef)node);
            }
            case Unary: {
                return this.buildUnary((DUnary)node);
            }
            case Binary: {
                return this.buildBinary((DBinary)node);
            }
            case SysReq: {
                return this.buildSysReq((DSysReq)node);
            }
            case Call: {
                return this.buildCall((DCall)node);
            }
            case DeclareLocal: {
                DDeclareLocal local = (DDeclareLocal)node;
                return local.var().name();
            }
            case TempName: {
                DTempName name = (DTempName)node;
                return name.name();
            }
            case Global: {
                DGlobal global = (DGlobal)node;
                return global.var().name();
            }
            case InlineArray: {
                return this.buildInlineArray((DInlineArray)node);
            }
            case GenArray: {
                return ((DGenArray)node).var().name();
            }
            case Store: {
                return "(" + this.buildStore((DStore)node) + ")";
            }
        }
        throw new Exception("Can't print expression: " + (Object)((Object)node.type()));
    }

    private String buildArgDeclaration(Argument arg) {
        String decl = this.buildType(arg) + arg.name();
        if (arg.dimensions() != null) {
            for (int i = 0; i < arg.dimensions().length; ++i) {
                Dimension dim = arg.dimensions()[i];
                decl = decl + "[";
                if (dim.size() >= 1) {
                    decl = arg.isString() ? decl + dim.size() * 4 : decl + dim.size();
                }
                decl = decl + "]";
            }
        }
        return decl;
    }

    private String buildVarDeclaration(Variable var) {
        String decl = this.buildType(var) + var.name();
        if (var.dims() != null) {
            for (int i = 0; i < var.dims().length; ++i) {
                Dimension dim = var.dims()[i];
                decl = decl + "[";
                if (dim.size() >= 1) {
                    decl = var.isString() && i == var.dims().length - 1 ? decl + dim.size() * 4 : decl + dim.size();
                }
                decl = decl + "]";
            }
        }
        return decl;
    }

    private void writeLocal(DDeclareLocal local) throws Exception {
        DConstant con;
        if (local.offset() >= 0L) {
            return;
        }
        String decl = this.buildVarDeclaration(local.var());
        if (local.value() == null) {
            this.outputLine("decl " + decl + ";");
            return;
        }
        if (local.value().type() == NodeType.Constant && (con = (DConstant)local.value()).value() == 0L) {
            this.outputLine("new " + decl + ";");
            return;
        }
        String expr = this.buildExpression(local.value());
        this.outputLine("new " + decl + " = " + expr + ";");
    }

    private void writeGenArray(DGenArray array) throws Exception {
        String prefix = array.autozero() ? "new " : "decl ";
        String decl = prefix + array.var().name();
        for (int i = array.numOperands() - 1; i >= 0; --i) {
            decl = decl + "[" + this.buildExpression(array.getOperand(i)) + "]";
        }
        this.outputLine(decl + ";");
    }

    private void writeStatic(DDeclareStatic decl) throws IOException {
        this.writeGlobal(decl.var());
    }

    private void writeSysReq(DSysReq sysreq) throws Exception {
        this.outputLine(this.buildSysReq(sysreq) + ";");
    }

    private void writeCall(DCall call) throws Exception {
        this.outputLine(this.buildCall(call) + ";");
    }

    private void writeStore(DStore store) throws Exception {
        this.outputLine(this.buildStore(store) + ";");
    }

    private void writeReturn(ReturnBlock block) throws Exception {
        String operand;
        if (block.chain() != null) {
            operand = this.buildLogicChain(block.chain());
        } else {
            DReturn ret = (DReturn)block.source().nodes().last();
            operand = this.buildExpression(ret.getOperand(0));
        }
        this.outputLine("return " + operand + ";");
    }

    private void writeIncDec(DIncDec incdec) throws Exception {
        String lhs = this.buildLoadStoreRef(incdec.getOperand(0));
        String rhs = incdec.amount() == 1L ? "++" : "--";
        this.outputLine(lhs + rhs + ";");
    }

    private void writeTempName(DTempName name) throws Exception {
        if (name.getOperand(0) != null) {
            this.outputLine("new " + name.name() + " = " + this.buildExpression(name.getOperand(0)) + ";");
        } else {
            this.outputLine("new " + name.name() + ";");
        }
    }

    private void writeStatement(DNode node) throws Exception {
        switch (node.type()) {
            case DeclareLocal: {
                this.writeLocal((DDeclareLocal)node);
                break;
            }
            case DeclareStatic: {
                this.writeStatic((DDeclareStatic)node);
                break;
            }
            case Jump: 
            case JumpCondition: 
            case Return: 
            case Switch: {
                break;
            }
            case SysReq: {
                this.writeSysReq((DSysReq)node);
                break;
            }
            case Call: {
                this.writeCall((DCall)node);
                break;
            }
            case Store: {
                this.writeStore((DStore)node);
                break;
            }
            case BoundsCheck: {
                break;
            }
            case TempName: {
                this.writeTempName((DTempName)node);
                break;
            }
            case IncDec: {
                this.writeIncDec((DIncDec)node);
                break;
            }
            case GenArray: {
                this.writeGenArray((DGenArray)node);
                break;
            }
            case Label: {
                this.writeLabel((DLabel)node);
                break;
            }
            default: {
                throw new Exception("unknown op (" + (Object)((Object)node.type()) + ")");
            }
        }
    }

    private String lgop(LogicOperator lop) {
        return lop == LogicOperator.And ? "&&" : "||";
    }

    private String buildLogicExpr(LogicChain.Node node) throws Exception {
        if (node.isSubChain()) {
            String text = this.buildLogicChain(node.subChain());
            if (node.subChain().nodes().size() == 1) {
                return text;
            }
            return "(" + text + ")";
        }
        return this.buildExpression(node.expression());
    }

    private String buildLogicChain(LogicChain chain) throws Exception {
        String text = this.buildLogicExpr(chain.nodes().get(0));
        for (int i = 1; i < chain.nodes().size(); ++i) {
            LogicChain.Node node = chain.nodes().get(i);
            text = text + " " + this.lgop(chain.op()) + " " + this.buildLogicExpr(node);
        }
        return text;
    }

    private void writeStatements(NodeBlock block) throws Exception {
        NodeList.iterator iter = block.nodes().begin();
        while (iter.more()) {
            this.writeStatement(iter.node());
            iter.next();
        }
    }

    private void writeIf(IfBlock block) throws Exception {
        String cond;
        this.writeStatements(block.source());
        if (block.logic() == null) {
            DJumpCondition jcc = (DJumpCondition)block.source().nodes().last();
            cond = block.invert() ? (jcc.getOperand(0).type() == NodeType.Unary && ((DUnary)jcc.getOperand(0)).spop() == SPOpcode.not ? this.buildExpression(jcc.getOperand(0).getOperand(0)) : (jcc.getOperand(0).type() == NodeType.Load ? "!" + this.buildExpression(jcc.getOperand(0)) : "!(" + this.buildExpression(jcc.getOperand(0)) + ")")) : this.buildExpression(jcc.getOperand(0));
        } else {
            cond = block.invert() ? "!(" + this.buildLogicChain(block.logic()) + ")" : this.buildLogicChain(block.logic());
        }
        this.outputLine("if (" + cond + ")");
        this.outputLine("{");
        if (block.trueArm() != null) {
            this.increaseIndent();
            this.writeBlock(block.trueArm());
            this.decreaseIndent();
        }
        if (block.falseArm() != null && BlockAnalysis.GetEmptyTarget(block.falseArm().source()) == null) {
            this.outputLine("}");
            this.outputLine("else");
            this.outputLine("{");
            this.increaseIndent();
            this.writeBlock(block.falseArm());
            this.decreaseIndent();
        }
        this.outputLine("}");
        if (block.join() != null) {
            this.writeBlock(block.join());
        }
    }

    private void writeWhileLoop(WhileLoop loop) throws Exception {
        String cond;
        if (loop.logic() == null) {
            this.writeStatements(loop.source());
            DNode jcc = loop.source().nodes().last();
            cond = jcc.type() == NodeType.JumpCondition ? this.buildExpression(jcc.getOperand(0)) : "true";
        } else {
            cond = this.buildLogicChain(loop.logic());
        }
        this.outputLine("while (" + cond + ")");
        this.outputLine("{");
        this.increaseIndent();
        this.writeBlock(loop.body());
        this.decreaseIndent();
        this.outputLine("}");
        if (loop.join() != null) {
            this.writeBlock(loop.join());
        }
    }

    private void writeDoWhileLoop(WhileLoop loop) throws Exception {
        String cond;
        this.outputLine("do {");
        this.increaseIndent();
        if (loop.body() != null) {
            this.writeBlock(loop.body());
        }
        if (loop.logic() == null) {
            this.writeStatements(loop.source());
            this.decreaseIndent();
            DNode last = loop.source().nodes().last();
            if (last.type() == NodeType.JumpCondition) {
                DJumpCondition jcc = (DJumpCondition)last;
                cond = this.buildExpression(jcc.getOperand(0));
            } else {
                if (last.type() == NodeType.Jump) {
                    DJump j = (DJump)last;
                    this.writeStatements(j.target());
                }
                cond = "true";
            }
        } else {
            this.decreaseIndent();
            cond = this.buildLogicChain(loop.logic());
        }
        this.outputLine("} while (" + cond + ");");
        if (loop.join() != null) {
            this.writeBlock(loop.join());
        }
    }

    private void writeSwitch(SwitchBlock switch_) throws Exception {
        this.writeStatements(switch_.source());
        DSwitch last = (DSwitch)switch_.source().nodes().last();
        String cond = this.buildExpression(last.getOperand(0));
        this.outputLine("switch (" + cond + ")");
        this.outputLine("{");
        this.increaseIndent();
        for (int i = 0; i < switch_.numCases(); ++i) {
            SwitchBlock.Case cas = switch_.getCase(i);
            String values = "";
            for (int j = 0; j < cas.numValues(); ++j) {
                if (j > 0) {
                    values = values + ", ";
                }
                values = values + cas.value(j);
            }
            this.outputLine("case " + values + ":");
            this.outputLine("{");
            this.increaseIndent();
            this.writeBlock(cas.target());
            this.decreaseIndent();
            this.outputLine("}");
        }
        this.outputLine("default:");
        this.outputLine("{");
        this.increaseIndent();
        this.writeBlock(switch_.defaultCase());
        this.decreaseIndent();
        this.outputLine("}");
        this.decreaseIndent();
        this.outputLine("}");
        if (switch_.join() != null) {
            this.writeBlock(switch_.join());
        }
    }

    private void writeLabel(DLabel label) {
        this.outputLine(label.label() + ":");
    }

    private void writeGoto(GotoBlock goto_) throws Exception {
        this.writeStatements(goto_.source());
        DLabel label = (DLabel)goto_.target().nodes().first();
        this.outputLine(String.format("goto %s;", label.label()));
    }

    private void writeStatementBlock(StatementBlock block) throws Exception {
        this.writeStatements(block.source());
        if (block.next() != null) {
            this.writeBlock(block.next());
        }
    }

    private void writeBlock(ControlBlock block) throws Exception {
        switch (block.type()) {
            case If: {
                this.writeIf((IfBlock)block);
                break;
            }
            case WhileLoop: {
                this.writeWhileLoop((WhileLoop)block);
                break;
            }
            case DoWhileLoop: {
                this.writeDoWhileLoop((WhileLoop)block);
                break;
            }
            case Statement: {
                this.writeStatementBlock((StatementBlock)block);
                break;
            }
            case Return: {
                this.writeStatements(block.source());
                this.writeReturn((ReturnBlock)block);
                break;
            }
            case Switch: {
                this.writeSwitch((SwitchBlock)block);
                break;
            }
            case Goto: {
                this.writeGoto((GotoBlock)block);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private String replaceChatColorCharacters(String str) {
        str = str.replace("\u0000", "\\x00");
        str = str.replace("\u0001", "\\x01");
        str = str.replace("\u0002", "\\x02");
        str = str.replace("\u0003", "\\x03");
        str = str.replace("\u0004", "\\x04");
        str = str.replace("\u0005", "\\x05");
        str = str.replace("\u0006", "\\x06");
        str = str.replace("\u0007", "\\x07");
        str = str.replace("\b", "\\x08");
        str = str.replace("\t", "\\x09");
        str = str.replace("\n", "\\n");
        str = str.replace("\u000b", "\\x0B");
        str = str.replace("\f", "\\x0C");
        str = str.replace("\u000e", "\\x0E");
        str = str.replace("\u000f", "\\x0F");
        str = str.replace("\u0010", "\\x10");
        return str;
    }

    private boolean isArrayValid(long address, int[] dims, int level) {
        if (level == dims.length - 1) {
            return this.file_.isValidDataAddress(address);
        }
        for (int i = 0; i < dims[level]; ++i) {
            long abase = address + (long)(i * 4);
            long inner = this.file_.int32FromData(abase);
            long finalX = abase + inner;
            if (this.isArrayValid(finalX, dims, level + 1)) continue;
            return false;
        }
        return true;
    }

    private boolean isArrayEmpty(long address, int bytes) {
        for (long i = address + 0L; i < address + (long)bytes; ++i) {
            if ((long)this.file_.DAT().length <= i || this.file_.DAT()[(int)i] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isArrayEmpty(long address, int[] dims, int level) {
        if (level == dims.length - 1) {
            return this.isArrayEmpty(address, dims[level] * 4);
        }
        for (int i = 0; i < dims[level]; ++i) {
            long abase = address + (long)(i * 4);
            long inner = this.file_.int32FromData(abase);
            if (inner == 0L) {
                return true;
            }
            long finalX = abase + inner;
            if (this.isArrayEmpty(finalX, dims, level + 1)) continue;
            return false;
        }
        return true;
    }

    private boolean isArrayEmpty(Variable var) {
        int[] dims = new int[var.dims().length];
        for (int i = 0; i < var.dims().length; ++i) {
            dims[i] = var.dims()[i].size();
        }
        if (var.isString()) {
            int n = dims.length - 1;
            dims[n] = dims[n] / 4;
        }
        if (!this.isArrayValid(var.address(), dims, 0)) {
            return true;
        }
        if (var.dims().length > 0 && var.dims()[var.dims().length - 1].size() == 0) {
            return false;
        }
        return this.isArrayEmpty(var.address(), dims, 0);
    }

    private String dumpStringArray(long address, int size) {
        String text = "";
        for (int i = 0; i < size; ++i) {
            long abase = address + (long)(i * 4);
            long inner = this.file_.int32FromData(abase);
            long finalX = abase + inner;
            String str = this.file_.stringFromData(finalX);
            String printStr = this.buildString(str);
            if (i != size - 1) {
                printStr = printStr + ",";
            }
            text = text + this.prepareOutputLine(printStr);
        }
        return text;
    }

    private String dumpStringArray(Variable var, long address, int level) {
        if (level == var.dims().length - 2) {
            return this.dumpStringArray(address, var.dims()[level].size());
        }
        String text = "";
        for (int i = 0; i < var.dims()[level].size(); ++i) {
            long abase = address + (long)(i * 4);
            long inner = this.file_.int32FromData(abase);
            long finalX = abase + inner;
            text = text + this.prepareOutputLine("{");
            this.increaseIndent();
            text = text + this.dumpStringArray(var, finalX, level + 1);
            this.decreaseIndent();
            text = i == var.dims()[level].size() - 1 ? text + this.prepareOutputLine("}") : text + this.prepareOutputLine("},");
        }
        return text;
    }

    private String dumpEntireArray(long address, int size) {
        String text = "";
        for (int i = 0; i < size; ++i) {
            long cell = this.file_.int32FromData(address + (long)(i * 4));
            text = text + cell;
            if (i == size - 1) continue;
            text = text + ", ";
        }
        return this.prepareOutputLine(text);
    }

    private String dumpArray(long address, int size) {
        long first = this.file_.int32FromData(address);
        for (int i = 1; i < size; ++i) {
            long cell = this.file_.int32FromData(address + (long)(i * 4));
            if (first == cell) continue;
            return this.dumpEntireArray(address, size);
        }
        return this.prepareOutputLine(first + ", ...");
    }

    private String dumpArray(Variable var, long address, int level) {
        if (level == var.dims().length - 1) {
            return this.dumpArray(address, var.dims()[level].size());
        }
        String text = "";
        for (int i = 0; i < var.dims()[level].size(); ++i) {
            long abase = address + (long)(i * 4);
            long inner = this.file_.int32FromData(abase);
            long finalX = abase + inner;
            text = text + this.prepareOutputLine("{");
            this.increaseIndent();
            text = text + this.dumpArray(var, finalX, level + 1);
            this.decreaseIndent();
            text = i == var.dims()[level].size() - 1 ? text + this.prepareOutputLine("}") : text + this.prepareOutputLine("},");
        }
        return text;
    }

    private void writeGlobal(Variable var) throws IOException {
        String decl;
        String string = decl = var.scope() == Scope.Global ? "new" : "static";
        if (var.name().equals("myinfo")) {
            int nameOffset = this.file_.int32FromData(var.address() + 0L);
            int descriptionOffset = this.file_.int32FromData(var.address() + 4L);
            int authorOffset = this.file_.int32FromData(var.address() + 8L);
            int versionOffset = this.file_.int32FromData(var.address() + 12L);
            int urlOffset = this.file_.int32FromData(var.address() + 16L);
            String name = this.file_.isValidDataAddress(nameOffset) ? this.file_.stringFromData(nameOffset) : "[INVALID_STRING]";
            String description = this.file_.isValidDataAddress(descriptionOffset) ? this.file_.stringFromData(descriptionOffset) : "[INVALID_STRING]";
            String author = this.file_.isValidDataAddress(authorOffset) ? this.file_.stringFromData(authorOffset) : "[INVALID_STRING]";
            String version = this.file_.isValidDataAddress(versionOffset) ? this.file_.stringFromData(versionOffset) : "[INVALID_STRING]";
            String url = this.file_.isValidDataAddress(urlOffset) ? this.file_.stringFromData(urlOffset) : "[INVALID_STRING]";
            this.outputLine("public Plugin:myinfo =");
            this.outputLine("{");
            this.increaseIndent();
            this.outputLine("name = " + this.buildString(name) + ",");
            this.outputLine("description = " + this.buildString(description) + ",");
            this.outputLine("author = " + this.buildString(author) + ",");
            this.outputLine("version = " + this.buildString(version) + ",");
            this.outputLine("url = " + this.buildString(url));
            this.decreaseIndent();
            this.outputLine("};");
        } else if (var.name().startsWith("__ext_")) {
            int nameOffset = this.file_.int32FromData(var.address() + 0L);
            int fileOffset = this.file_.int32FromData(var.address() + 4L);
            int autoload = this.file_.int32FromData(var.address() + 8L);
            int required = this.file_.int32FromData(var.address() + 12L);
            String name = this.file_.isValidDataAddress(nameOffset) ? this.file_.stringFromData(nameOffset) : "[INVALID_STRING]";
            String file = this.file_.isValidDataAddress(fileOffset) ? this.file_.stringFromData(fileOffset) : "[INVALID_STRING]";
            this.outputLine("public Extension:" + var.name() + " =");
            this.outputLine("{");
            this.increaseIndent();
            this.outputLine("name = " + this.buildString(name) + ",");
            this.outputLine("file = " + this.buildString(file) + ",");
            this.outputLine("autoload = " + autoload + ",");
            this.outputLine("required = " + required + ",");
            this.decreaseIndent();
            this.outputLine("};");
        } else if (var.name().startsWith("__pl_")) {
            int nameOffset = this.file_.int32FromData(var.address() + 0L);
            int fileOffset = this.file_.int32FromData(var.address() + 4L);
            int required = this.file_.int32FromData(var.address() + 8L);
            String name = this.file_.isValidDataAddress(nameOffset) ? this.file_.stringFromData(nameOffset) : "[INVALID_STRING]";
            String file = this.file_.isValidDataAddress(fileOffset) ? this.file_.stringFromData(fileOffset) : "[INVALID_STRING]";
            this.outputLine("public SharedPlugin:" + var.name() + " =");
            this.outputLine("{");
            this.increaseIndent();
            this.outputLine("name = " + this.buildString(name) + ",");
            this.outputLine("file = " + this.buildString(file) + ",");
            this.outputLine("required = " + required + ",");
            this.decreaseIndent();
            this.outputLine("};");
        } else if (var.name().equals("__version")) {
            int version = this.file_.int32FromData(var.address() + 0L);
            int fileversOffset = this.file_.int32FromData(var.address() + 4L);
            int dateOffset = this.file_.int32FromData(var.address() + 8L);
            int timeOffset = this.file_.int32FromData(var.address() + 12L);
            String filevers = this.file_.isValidDataAddress(fileversOffset) ? this.file_.stringFromData(fileversOffset) : "[INVALID_STRING]";
            String date = this.file_.isValidDataAddress(dateOffset) ? this.file_.stringFromData(dateOffset) : "[INVALID_STRING]";
            String time = this.file_.isValidDataAddress(timeOffset) ? this.file_.stringFromData(timeOffset) : "[INVALID_STRING]";
            this.outputLine("public PlVers:__version =");
            this.outputLine("{");
            this.increaseIndent();
            this.outputLine("version = " + version + ",");
            this.outputLine("filevers = " + this.buildString(filevers) + ",");
            this.outputLine("date = " + this.buildString(date) + ",");
            this.outputLine("time = " + this.buildString(time));
            this.decreaseIndent();
            this.outputLine("};");
        } else if (var.isString()) {
            if (var.dims().length == 1) {
                String text = decl + " String:" + var.name() + "[" + var.dims()[0].size() * 4 + "]";
                String primer = this.file_.stringFromData(var.address());
                if (primer.length() > 0) {
                    text = text + " = " + this.buildString(primer);
                }
                this.outputLine(text + ";");
            } else {
                String text = decl + " " + this.buildType(var) + var.name();
                if (var.dims() != null) {
                    for (int i = 0; i < var.dims().length; ++i) {
                        int size = var.dims()[i].size();
                        if (i == var.dims().length - 1) {
                            size *= 4;
                        }
                        text = size == 0 ? text + "[]" : text + "[" + size + "]";
                    }
                }
                if (this.isArrayEmpty(var)) {
                    this.outputLine(text + ";");
                    return;
                }
                this.outputLine(text + " =");
                this.outputLine("{");
                this.increaseIndent();
                this.out_.print(this.dumpStringArray(var, var.address(), 0));
                this.decreaseIndent();
                this.outputLine("};");
            }
        } else if (var.dims() == null || var.dims().length == 0) {
            String text = decl + " " + this.buildType(var) + var.name();
            long value = this.file_.int32FromData(var.address());
            if (value != 0L) {
                text = text + " = " + value;
            }
            text = text + ";";
            if (var.isStateVariable()) {
                text = text + this.buildStateVarComment(var);
            }
            this.outputLine(text);
        } else if (this.isArrayEmpty(var)) {
            String text = decl + " " + this.buildType(var) + var.name();
            if (var.dims() != null) {
                for (int i = 0; i < var.dims().length; ++i) {
                    text = text + "[" + var.dims()[i].size() + "]";
                }
            }
            this.outputLine(text + ";");
        } else {
            String text = decl + " " + this.buildType(var) + var.name();
            if (var.dims() != null) {
                for (int i = 0; i < var.dims().length; ++i) {
                    text = text + "[" + var.dims()[i].size() + "]";
                }
            }
            this.outputLine(text + " =");
            this.outputLine("{");
            this.increaseIndent();
            this.out_.print(this.dumpArray(var, var.address(), 0));
            this.decreaseIndent();
            this.outputLine("};");
        }
    }

    private String buildStateVarComment(Variable var) {
        PawnFile.Automation automation = this.file_.lookupAutomation(var.address());
        if (automation == null) {
            return " // Internal state variable";
        }
        String comment = " // Internal state variable for ";
        comment = automation.automation_id() > 0 ? comment + "automation " + automation.name() : comment + "default automation";
        return comment;
    }

    public void writeGlobals() throws IOException {
        if (this.file_.globals() == null) {
            System.err.println("// File got no pubvars?");
            return;
        }
        for (int i = 0; i < this.file_.globals().length; ++i) {
            this.writeGlobal(this.file_.globals()[i]);
        }
    }

    public void write(ControlBlock root) throws Exception {
        this.writeSignature(root.source());
        this.outputLine("{");
        this.increaseIndent();
        this.writeBlock(root);
        this.decreaseIndent();
        this.outputLine("}");
    }
}

