/*
 * Decompiled with CFR 0.152.
 */
package lysis.instructions;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import lysis.instructions.LControlInstruction;
import lysis.instructions.Opcode;
import lysis.instructions.SwitchCase;
import lysis.lstructure.LBlock;

public class LSwitch
extends LControlInstruction {
    private LBlock defaultCase_;
    private LinkedList<SwitchCase> cases_;

    public LSwitch(LBlock defaultCase, LinkedList<SwitchCase> cases) {
        super(new LBlock[0]);
        this.defaultCase_ = defaultCase;
        this.cases_ = cases;
    }

    public LBlock defaultCase() {
        return this.defaultCase_;
    }

    @Override
    public void replaceSuccessor(int i, LBlock block) {
        if (i == 0) {
            this.defaultCase_ = block;
        } else {
            this.cases_.get((int)(i - 1)).target = block;
        }
    }

    @Override
    public int numSuccessors() {
        return this.cases_.size() + 1;
    }

    @Override
    public LBlock getSuccessor(int i) {
        if (i == 0) {
            return this.defaultCase_;
        }
        return this.cases_.get((int)(i - 1)).target;
    }

    public int numCases() {
        return this.cases_.size();
    }

    public SwitchCase getCase(int i) {
        return this.cases_.get(i);
    }

    @Override
    public Opcode op() {
        return Opcode.Switch;
    }

    @Override
    public void print(DataOutputStream tw) throws IOException, Exception {
        String text = this.defaultCase().id() + (this.numCases() > 0 ? "," : "");
        for (int i = 0; i < this.numCases(); ++i) {
            text = text + this.getCase((int)i).target.id();
            if (i == this.numCases() - 1) continue;
            text = text + ",";
        }
        tw.writeBytes("switch.pri -> " + text);
    }
}

