/*
 * Decompiled with CFR 0.152.
 */
package lysis.lstructure;

import java.util.LinkedList;
import lysis.instructions.LControlInstruction;
import lysis.instructions.LInstruction;

public class LBlock {
    private long pc_;
    private LInstruction[] instructions_;
    private LinkedList<LBlock> predecessors_ = new LinkedList();
    private boolean marked_ = false;
    private int id_;
    private LBlock backedge_ = null;
    private LBlock loop_ = null;
    private LBlock idom_ = null;
    private LBlock[] dominators_ = null;
    private LBlock[] idominated_ = null;

    public LBlock(long pc) {
        this.pc_ = pc;
    }

    public void setInstructions(LInstruction[] instructions) {
        this.instructions_ = instructions;
    }

    public void addPredecessor(LBlock pred) {
        assert (!this.predecessors_.contains(pred));
        this.predecessors_.add(pred);
    }

    public void removePredecessor(LBlock pred) {
        assert (this.predecessors_.contains(pred));
        this.predecessors_.remove(pred);
    }

    public void mark() {
        assert (!this.marked_);
        this.marked_ = true;
    }

    public void unmark() {
        assert (this.marked_);
        this.marked_ = false;
    }

    public boolean marked() {
        return this.marked_;
    }

    public void setId(int id) {
        this.id_ = id;
    }

    public void setLoopHeader(LBlock backedge) {
        this.backedge_ = backedge;
        this.loop_ = this;
    }

    public void setInLoop(LBlock loop) {
        this.loop_ = loop;
    }

    public void setImmediateDominator(LBlock idom) {
        this.idom_ = idom;
    }

    public void setDominators(LBlock[] dominators) {
        this.dominators_ = dominators;
    }

    public void setImmediateDominated(LBlock[] idominated) {
        this.idominated_ = idominated;
    }

    public int id() {
        return this.id_;
    }

    public LBlock idom() {
        return this.idom_;
    }

    public void setPC(long pc) {
        this.pc_ = pc;
    }

    public long pc() {
        return this.pc_;
    }

    public LInstruction[] instructions() {
        return this.instructions_;
    }

    public LBlock backedge() {
        return this.backedge_;
    }

    public int numPredecessors() {
        return this.predecessors_.size();
    }

    public int numSuccessors() {
        return this.last().numSuccessors();
    }

    public LBlock getSuccessor(int successor) {
        return this.last().getSuccessor(successor);
    }

    public LBlock getPredecessor(int predecessor) {
        return this.predecessors_.get(predecessor);
    }

    public LBlock getLoopPredecessor() {
        assert (this.loop_ == this);
        assert (this.numPredecessors() == 2);
        if (this.getPredecessor(0).id() < this.id()) {
            assert (this.getPredecessor(1).id() >= this.id());
            return this.getPredecessor(0);
        }
        assert (this.getPredecessor(1).id() < this.id());
        return this.getPredecessor(1);
    }

    public LBlock[] dominators() {
        return this.dominators_;
    }

    public LBlock[] idominated() {
        return this.idominated_;
    }

    public LBlock loop() {
        return this.loop_;
    }

    public void replaceSuccessor(int pos, LBlock split) {
        this.last().replaceSuccessor(pos, split);
    }

    public void replacePredecessor(LBlock from, LBlock split) {
        assert (this.predecessors_.contains(from));
        for (int i = 0; i < this.numPredecessors(); ++i) {
            if (this.getPredecessor(i) != from) continue;
            this.predecessors_.set(i, split);
            break;
        }
        assert (!this.predecessors_.contains(from));
    }

    public LControlInstruction last() {
        return (LControlInstruction)this.instructions()[this.instructions().length - 1];
    }
}

