/*
 * Decompiled with CFR 0.152.
 */
package lysis.lstructure;

import lysis.lstructure.Dimension;
import lysis.lstructure.Scope;
import lysis.lstructure.Tag;
import lysis.lstructure.VariableType;
import lysis.types.rtti.RttiType;

public class Variable {
    long addr_;
    long tag_id_;
    Tag tag_;
    long codeStart_;
    long codeEnd_;
    VariableType type_;
    Scope scope_;
    String name_;
    Dimension[] dims_;
    boolean statevar_;
    RttiType rtti_type_;

    public Variable(long addr, int tag_id, Tag tag, long codeStart, long codeEnd, VariableType type, Scope scope, String name, Dimension[] dims) {
        this.addr_ = addr;
        this.tag_id_ = tag_id;
        this.tag_ = tag;
        this.codeStart_ = codeStart;
        this.codeEnd_ = codeEnd;
        this.type_ = type;
        this.scope_ = scope;
        this.name_ = name;
        this.dims_ = dims;
        this.statevar_ = false;
        this.rtti_type_ = null;
    }

    public Variable(long addr, int tag_id, Tag tag, long codeStart, long codeEnd, VariableType type, Scope scope, String name) {
        this(addr, tag_id, tag, codeStart, codeEnd, type, scope, name, null);
    }

    public Variable(long addr, long codeStart, long codeEnd, VariableType type, Scope scope, String name, Dimension[] dims, RttiType rttiType) {
        this(addr, -1, null, codeStart, codeEnd, type, scope, name, dims);
        this.rtti_type_ = rttiType;
    }

    public long address() {
        return this.addr_;
    }

    public long codeStart() {
        return this.codeStart_;
    }

    public long codeEnd() {
        return this.codeEnd_;
    }

    public String name() {
        return this.name_;
    }

    public VariableType type() {
        return this.type_;
    }

    public Scope scope() {
        return this.scope_;
    }

    public Tag tag() {
        return this.tag_;
    }

    public long tag_id() {
        return this.tag_id_;
    }

    public Dimension[] dims() {
        return this.dims_;
    }

    public boolean isStateVariable() {
        return this.statevar_;
    }

    public void setTag(Tag tag) {
        this.tag_ = tag;
        this.tag_id_ = tag.tag_id();
    }

    public void setTagId(long tag_id) {
        this.tag_id_ = tag_id;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public void markAsStateVariable() {
        this.statevar_ = true;
    }

    public RttiType rttiType() {
        return this.rtti_type_;
    }

    public void updateByRef() {
        this.rtti_type_.setByRef();
        this.type_ = this.rtti_type_.toVariableType();
    }

    public boolean isString() {
        if (this.tag_ != null && this.tag_.isString()) {
            return true;
        }
        return this.rtti_type_ != null && this.rtti_type_.isString();
    }

    public boolean isFloat() {
        if (this.tag_ != null && this.tag_.isFloat()) {
            return true;
        }
        return this.rtti_type_ != null && this.rtti_type_.isFloat();
    }
}

