/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes;

import lysis.lstructure.LBlock;
import lysis.lstructure.LGraph;
import lysis.lstructure.Register;
import lysis.nodes.AbstractStack;
import lysis.nodes.NodeList;
import lysis.nodes.NodeType;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DPhi;

public class NodeBlock {
    private LBlock lir_;
    private AbstractStack stack_;
    private NodeList nodes_;

    public NodeBlock(LBlock lir) {
        this.lir_ = lir;
        this.nodes_ = new NodeList();
    }

    private void joinRegs(Register reg, DNode value) throws Exception {
        DPhi phi;
        if (value == null || this.stack_.reg(reg) == value) {
            return;
        }
        if (this.stack_.reg(reg) == null) {
            this.stack_.set(reg, value);
            return;
        }
        DNode node = this.stack_.reg(reg);
        if (node.type() != NodeType.Phi || node.block() != this) {
            phi = new DPhi(node);
            this.stack_.set(reg, (DNode)phi);
            this.add(phi);
        } else {
            phi = (DPhi)node;
        }
        phi.addInput(value);
    }

    public void inherit(LGraph graph, NodeBlock other) throws Exception {
        if (other == null) {
            this.stack_ = new AbstractStack(graph.nargs);
            for (int i = 0; i < graph.nargs; ++i) {
                DDeclareLocal local = new DDeclareLocal(this.lir_.pc(), null);
                local.setOffset(i * 4 + 12);
                this.add(local);
                this.stack_.init(i * 4 + 12, local);
            }
        } else if (this.stack_ == null) {
            assert (other.stack_ != null);
            this.stack_ = new AbstractStack(other.stack_);
        } else {
            this.joinRegs(Register.Pri, other.stack_.pri());
            this.joinRegs(Register.Alt, other.stack_.alt());
        }
    }

    public void add(DNode node) {
        node.setBlock(this);
        this.nodes_.add(node);
    }

    public void prepend(DNode node) {
        node.setBlock(this);
        this.nodes_.insertBefore(this.nodes_.last(), node);
    }

    public void replace(NodeList.iterator_base where, DNode with) {
        with.setBlock(this);
        this.nodes_.replace(where, with);
    }

    public void replace(DNode where, DNode with) {
        with.setBlock(this);
        this.nodes_.replace(where, with);
    }

    public LBlock lir() {
        return this.lir_;
    }

    public AbstractStack stack() {
        return this.stack_;
    }

    public NodeList nodes() {
        return this.nodes_;
    }
}

