/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import lysis.PawnFile;
import lysis.StupidWrapper;
import lysis.instructions.LAddConstant;
import lysis.instructions.LBinary;
import lysis.instructions.LBounds;
import lysis.instructions.LCall;
import lysis.instructions.LConstant;
import lysis.instructions.LDecGlobal;
import lysis.instructions.LDecLocal;
import lysis.instructions.LDecReg;
import lysis.instructions.LEqualConstant;
import lysis.instructions.LFill;
import lysis.instructions.LGenArray;
import lysis.instructions.LGoto;
import lysis.instructions.LHeap;
import lysis.instructions.LIncGlobal;
import lysis.instructions.LIncLocal;
import lysis.instructions.LIncReg;
import lysis.instructions.LIndexAddress;
import lysis.instructions.LInitArray;
import lysis.instructions.LInstruction;
import lysis.instructions.LJump;
import lysis.instructions.LJumpCondition;
import lysis.instructions.LLoadCtrl;
import lysis.instructions.LLoadGlobal;
import lysis.instructions.LLoadIndex;
import lysis.instructions.LLoadLocal;
import lysis.instructions.LLoadLocalRef;
import lysis.instructions.LMemCopy;
import lysis.instructions.LMove;
import lysis.instructions.LMulConstant;
import lysis.instructions.LPop;
import lysis.instructions.LPushConstant;
import lysis.instructions.LPushGlobal;
import lysis.instructions.LPushLocal;
import lysis.instructions.LPushReg;
import lysis.instructions.LPushStackAddress;
import lysis.instructions.LShiftLeftConstant;
import lysis.instructions.LStack;
import lysis.instructions.LStackAddress;
import lysis.instructions.LStackAdjust;
import lysis.instructions.LStoreCtrl;
import lysis.instructions.LStoreGlobal;
import lysis.instructions.LStoreGlobalConstant;
import lysis.instructions.LStoreLocal;
import lysis.instructions.LStoreLocalConstant;
import lysis.instructions.LStoreLocalRef;
import lysis.instructions.LSwap;
import lysis.instructions.LSwitch;
import lysis.instructions.LSysReq;
import lysis.instructions.LUnary;
import lysis.instructions.LZeroGlobal;
import lysis.instructions.LZeroLocal;
import lysis.instructions.Opcode;
import lysis.lstructure.Function;
import lysis.lstructure.LBlock;
import lysis.lstructure.LGraph;
import lysis.lstructure.Register;
import lysis.lstructure.Scope;
import lysis.lstructure.Variable;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeType;
import lysis.nodes.types.DArrayRef;
import lysis.nodes.types.DBinary;
import lysis.nodes.types.DBoundsCheck;
import lysis.nodes.types.DCall;
import lysis.nodes.types.DConstant;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DDeclareStatic;
import lysis.nodes.types.DGenArray;
import lysis.nodes.types.DGlobal;
import lysis.nodes.types.DHeap;
import lysis.nodes.types.DIncDec;
import lysis.nodes.types.DJump;
import lysis.nodes.types.DJumpCondition;
import lysis.nodes.types.DLabel;
import lysis.nodes.types.DLoad;
import lysis.nodes.types.DLocalRef;
import lysis.nodes.types.DMemCopy;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DReturn;
import lysis.nodes.types.DStore;
import lysis.nodes.types.DString;
import lysis.nodes.types.DSwitch;
import lysis.nodes.types.DSysReq;
import lysis.nodes.types.DUnary;
import lysis.sourcepawn.SPOpcode;

public class NodeBuilder {
    PawnFile file_;
    private LGraph graph_;
    private NodeBlock[] blocks_;

    public NodeBuilder(PawnFile file, LGraph graph) {
        this.file_ = file;
        this.graph_ = graph;
        this.blocks_ = new NodeBlock[this.graph_.blocks.length];
        for (int i = 0; i < this.graph_.blocks.length; ++i) {
            this.blocks_[i] = new NodeBlock(this.graph_.blocks[i]);
        }
    }

    public void traverse(NodeBlock block) throws Exception {
        for (int i = 0; i < block.lir().numPredecessors(); ++i) {
            NodeBlock pred = this.blocks_[block.lir().getPredecessor(i).id()];
            if (pred.lir().id() >= block.lir().id()) continue;
            block.inherit(this.graph_, pred);
        }
        block68: for (LInstruction uins : block.lir().instructions()) {
            if (uins.op() != Opcode.Goto) {
                int i = -1;
                while (true) {
                    StupidWrapper iStupid = new StupidWrapper(i);
                    Variable var = this.file_.lookupDeclarations(uins.pc(), iStupid, Scope.Static);
                    i = iStupid.i;
                    if (var == null) break;
                    block.add(new DDeclareStatic(var));
                }
            }
            switch (uins.op()) {
                case DebugBreak: {
                    continue block68;
                }
                case Stack: {
                    DDeclareLocal local;
                    LStack ins = (LStack)uins;
                    if (ins.amount() < 0L) {
                        int i = 0;
                        while ((long)i < -ins.amount() / 4L) {
                            local = new DDeclareLocal(ins.pc(), null);
                            block.stack().push(local);
                            block.add(local);
                            ++i;
                        }
                        continue block68;
                    }
                    int i = 0;
                    while ((long)i < ins.amount() / 4L) {
                        block.stack().pop();
                        ++i;
                    }
                    continue block68;
                }
                case Fill: {
                    LFill ins = (LFill)uins;
                    DNode node = block.stack().alt();
                    DDeclareLocal local = (DDeclareLocal)node;
                    assert (block.stack().pri().type() == NodeType.Constant);
                    int i = 0;
                    while ((long)i < ins.amount()) {
                        block.stack().set(local.offset() + (long)i, block.stack().pri());
                        i += 4;
                    }
                    DConstant con = (DConstant)block.stack().pri();
                    if (local.value() == null && con.value() == 0L) {
                        local.initOperand(0, con);
                    }
                    if (ins.amount() != 4L || con.value() == 0L) continue block68;
                    ByteBuffer buffer = ByteBuffer.allocate(4);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    buffer.putInt((int)con.value());
                    int requiredBytes = (int)(Math.ceil(Math.log(con.value()) / Math.log(2.0)) / 8.0) + 1;
                    byte[] bytes = new byte[requiredBytes];
                    for (int i2 = 0; i2 < requiredBytes; ++i2) {
                        bytes[i2] = buffer.get(i2);
                    }
                    DStore store = new DStore(local, new DString(new String(bytes, StandardCharsets.UTF_8)));
                    block.add(store);
                    continue block68;
                }
                case Constant: {
                    LConstant ins = (LConstant)uins;
                    DConstant v = new DConstant(ins.val(), ins.pc());
                    block.stack().set(ins.reg(), (DNode)v);
                    block.add(v);
                    continue block68;
                }
                case PushConstant: {
                    LPushConstant ins = (LPushConstant)uins;
                    DConstant v = new DConstant(ins.val(), ins.pc());
                    DDeclareLocal local = new DDeclareLocal(ins.pc(), v);
                    block.stack().push(local);
                    block.add(v);
                    block.add(local);
                    continue block68;
                }
                case PushReg: {
                    LPushReg ins = (LPushReg)uins;
                    DDeclareLocal local = new DDeclareLocal(ins.pc(), block.stack().reg(ins.reg()));
                    block.stack().push(local);
                    block.add(local);
                    continue block68;
                }
                case Pop: {
                    LPop ins = (LPop)uins;
                    DNode node = block.stack().popAsTemp();
                    block.stack().set(ins.reg(), node);
                    continue block68;
                }
                case StackAddress: {
                    LStackAddress ins = (LStackAddress)uins;
                    DDeclareLocal local = (DDeclareLocal)block.stack().getName(ins.offset());
                    block.stack().set(ins.reg(), (DNode)local);
                    continue block68;
                }
                case PushStackAddress: {
                    LPushStackAddress ins = (LPushStackAddress)uins;
                    DLocalRef lref = new DLocalRef((DDeclareLocal)block.stack().getName(ins.offset()));
                    DDeclareLocal local = new DDeclareLocal(ins.pc(), lref);
                    block.stack().push(local);
                    block.add(lref);
                    block.add(local);
                    continue block68;
                }
                case Goto: {
                    LGoto ins = (LGoto)uins;
                    DNode node = new DJump(this.blocks_[ins.target().id()]);
                    block.add(node);
                    continue block68;
                }
                case Jump: {
                    LJump ins = (LJump)uins;
                    DNode node = new DJump(this.blocks_[ins.target().id()]);
                    block.add(node);
                    continue block68;
                }
                case JumpCondition: {
                    LJumpCondition ins = (LJumpCondition)uins;
                    NodeBlock lhtarget = this.blocks_[ins.trueTarget().id()];
                    NodeBlock rhtarget = this.blocks_[ins.falseTarget().id()];
                    DNode cmp = block.stack().pri();
                    SPOpcode jmp = ins.spop();
                    if (jmp != SPOpcode.jzer && jmp != SPOpcode.jnz) {
                        SPOpcode newop;
                        switch (ins.spop()) {
                            case jeq: {
                                newop = SPOpcode.neq;
                                jmp = SPOpcode.jzer;
                                break;
                            }
                            case jneq: {
                                newop = SPOpcode.eq;
                                jmp = SPOpcode.jzer;
                                break;
                            }
                            case jsgeq: {
                                newop = SPOpcode.sless;
                                jmp = SPOpcode.jzer;
                                break;
                            }
                            case jsgrtr: {
                                newop = SPOpcode.sleq;
                                jmp = SPOpcode.jzer;
                                break;
                            }
                            case jsleq: {
                                newop = SPOpcode.sgrtr;
                                jmp = SPOpcode.jzer;
                                break;
                            }
                            case jsless: {
                                newop = SPOpcode.sgeq;
                                jmp = SPOpcode.jzer;
                                break;
                            }
                            default: {
                                assert (false);
                                return;
                            }
                        }
                        cmp = new DBinary(newop, block.stack().pri(), block.stack().alt());
                        block.add(cmp);
                    }
                    DJumpCondition jcc = new DJumpCondition(jmp, cmp, lhtarget, rhtarget);
                    block.add(jcc);
                    continue block68;
                }
                case LoadLocal: {
                    LLoadLocal ins = (LLoadLocal)uins;
                    DLoad load = new DLoad(block.stack().getName(ins.offset()));
                    block.stack().set(ins.reg(), (DNode)load);
                    block.add(load);
                    continue block68;
                }
                case LoadLocalRef: {
                    LLoadLocalRef ins = (LLoadLocalRef)uins;
                    DLoad load = new DLoad(block.stack().getName(ins.offset()));
                    load = new DLoad(load);
                    block.stack().set(ins.reg(), (DNode)load);
                    block.add(load);
                    continue block68;
                }
                case StoreLocal: {
                    LStoreLocal ins = (LStoreLocal)uins;
                    DNode regNode = block.stack().reg(ins.reg());
                    if (regNode == null) {
                        DNode prev = block.nodes().last();
                        assert (prev.type() == NodeType.Store);
                        if (prev.type() == NodeType.Store) {
                            regNode = prev.getOperand(1);
                        }
                    }
                    DStore store = new DStore(block.stack().getName(ins.offset()), regNode);
                    block.add(store);
                    continue block68;
                }
                case StoreLocalRef: {
                    LStoreLocalRef ins = (LStoreLocalRef)uins;
                    DLoad load = new DLoad(block.stack().getName(ins.offset()));
                    DStore store = new DStore(load, block.stack().reg(ins.reg()));
                    block.add(store);
                    continue block68;
                }
                case SysReq: {
                    LSysReq sysreq = (LSysReq)uins;
                    DConstant ins = (DConstant)block.stack().popValue();
                    long argslength = ins.value();
                    if (this.file_.PassArgCountAsSize()) {
                        argslength /= 4L;
                    }
                    LinkedList<DNode> arguments = new LinkedList<DNode>();
                    int i = 0;
                    while ((long)i < argslength) {
                        arguments.add(block.stack().popName());
                        ++i;
                    }
                    DSysReq call = new DSysReq(sysreq.nativeX(), arguments.toArray(new DNode[0]));
                    block.stack().set(Register.Pri, (DNode)call);
                    block.add(call);
                    continue block68;
                }
                case AddConstant: {
                    LAddConstant ins = (LAddConstant)uins;
                    DConstant val = new DConstant(ins.amount());
                    DNode node = new DBinary(SPOpcode.add, block.stack().pri(), val);
                    block.stack().set(Register.Pri, node);
                    block.add(val);
                    block.add(node);
                    continue block68;
                }
                case MulConstant: {
                    LMulConstant ins = (LMulConstant)uins;
                    DConstant val = new DConstant(ins.amount());
                    DNode node = new DBinary(SPOpcode.smul, block.stack().pri(), val);
                    block.stack().set(Register.Pri, node);
                    block.add(val);
                    block.add(node);
                    continue block68;
                }
                case Bounds: {
                    LBounds ins = (LBounds)uins;
                    DNode node = new DBoundsCheck(block.stack().pri(), ins.amount());
                    block.add(node);
                    continue block68;
                }
                case IndexAddress: {
                    LIndexAddress ins = (LIndexAddress)uins;
                    DNode node = new DArrayRef(block.stack().alt(), block.stack().pri(), ins.shift());
                    block.stack().set(Register.Pri, node);
                    block.add(node);
                    continue block68;
                }
                case Move: {
                    LMove ins = (LMove)uins;
                    if (ins.reg() == Register.Pri) {
                        block.stack().set(Register.Pri, block.stack().alt());
                        continue block68;
                    }
                    block.stack().set(Register.Alt, block.stack().pri());
                    continue block68;
                }
                case Store: {
                    DStore store = new DStore(block.stack().alt(), block.stack().pri());
                    block.add(store);
                    continue block68;
                }
                case Load: {
                    DLoad load = new DLoad(block.stack().pri());
                    block.stack().set(Register.Pri, (DNode)load);
                    block.add(load);
                    continue block68;
                }
                case Swap: {
                    LSwap ins = (LSwap)uins;
                    DNode lhs = block.stack().popAsTemp();
                    DNode rhs = block.stack().reg(ins.reg());
                    DDeclareLocal local = new DDeclareLocal(ins.pc(), rhs);
                    block.stack().set(ins.reg(), lhs);
                    block.stack().push(local);
                    block.add(local);
                    continue block68;
                }
                case IncI: {
                    DIncDec inc = new DIncDec(block.stack().pri(), 1);
                    block.add(inc);
                    continue block68;
                }
                case DecI: {
                    DIncDec dec = new DIncDec(block.stack().pri(), -1);
                    block.add(dec);
                    continue block68;
                }
                case IncLocal: {
                    LIncLocal ins = (LIncLocal)uins;
                    DDeclareLocal local = (DDeclareLocal)block.stack().getName(ins.offset());
                    DIncDec inc = new DIncDec(local, 1);
                    block.add(inc);
                    continue block68;
                }
                case IncReg: {
                    LIncReg ins = (LIncReg)uins;
                    DIncDec dec = new DIncDec(block.stack().reg(ins.reg()), 1);
                    block.add(dec);
                    continue block68;
                }
                case DecLocal: {
                    LDecLocal ins = (LDecLocal)uins;
                    DDeclareLocal local = (DDeclareLocal)block.stack().getName(ins.offset());
                    DIncDec dec = new DIncDec(local, -1);
                    block.add(dec);
                    continue block68;
                }
                case DecReg: {
                    LDecReg ins = (LDecReg)uins;
                    DIncDec dec = new DIncDec(block.stack().reg(ins.reg()), -1);
                    block.add(dec);
                    continue block68;
                }
                case Return: {
                    DReturn node = new DReturn(block.stack().pri());
                    block.add(node);
                    continue block68;
                }
                case PushLocal: {
                    LPushLocal ins = (LPushLocal)uins;
                    DLoad load = new DLoad(block.stack().getName(ins.offset()));
                    DDeclareLocal local = new DDeclareLocal(ins.pc(), load);
                    block.stack().push(local);
                    block.add(load);
                    block.add(local);
                    continue block68;
                }
                case Exchange: {
                    DNode node = block.stack().alt();
                    block.stack().set(Register.Alt, block.stack().pri());
                    block.stack().set(Register.Pri, node);
                    continue block68;
                }
                case Unary: {
                    LUnary ins = (LUnary)uins;
                    DUnary unary = new DUnary(ins.spop(), block.stack().reg(ins.reg()));
                    block.stack().set(Register.Pri, (DNode)unary);
                    block.add(unary);
                    continue block68;
                }
                case Binary: {
                    LBinary ins = (LBinary)uins;
                    DNode nodeLHS = block.stack().reg(ins.lhs());
                    DNode nodeRHS = block.stack().reg(ins.rhs());
                    DBinary binary = new DBinary(ins.spop(), nodeLHS, nodeRHS);
                    block.stack().set(Register.Pri, (DNode)binary);
                    block.add(binary);
                    if (ins.spop() != SPOpcode.sdiv_alt && ins.spop() != SPOpcode.sdiv) continue block68;
                    binary = new DBinary(SPOpcode.sdiv_alt_mod, nodeLHS, nodeRHS);
                    block.stack().set(Register.Alt, (DNode)binary);
                    block.add(binary);
                    continue block68;
                }
                case ShiftLeftConstant: {
                    LShiftLeftConstant ins = (LShiftLeftConstant)uins;
                    DConstant val = new DConstant(ins.val());
                    DNode node = new DBinary(SPOpcode.shl, block.stack().reg(ins.reg()), val);
                    block.stack().set(ins.reg(), node);
                    block.add(val);
                    block.add(node);
                    continue block68;
                }
                case PushGlobal: {
                    LPushGlobal ins = (LPushGlobal)uins;
                    Variable global = this.file_.lookupGlobal(ins.address());
                    if (global == null) {
                        global = this.file_.lookupVariable(ins.pc(), ins.address(), Scope.Static);
                    }
                    DGlobal dglobal = new DGlobal(global);
                    DLoad node = new DLoad(dglobal);
                    DDeclareLocal local = new DDeclareLocal(ins.pc(), node);
                    block.stack().push(local);
                    block.add(dglobal);
                    block.add(node);
                    block.add(local);
                    continue block68;
                }
                case LoadGlobal: {
                    LLoadGlobal ins = (LLoadGlobal)uins;
                    Variable global = this.file_.lookupGlobal(ins.address());
                    if (global == null) {
                        global = this.file_.lookupVariable(ins.pc(), ins.address(), Scope.Static);
                    }
                    DGlobal dglobal = new DGlobal(global);
                    DLoad node = new DLoad(dglobal);
                    block.stack().set(ins.reg(), (DNode)node);
                    block.add(dglobal);
                    block.add(node);
                    continue block68;
                }
                case StoreGlobal: {
                    LStoreGlobal ins = (LStoreGlobal)uins;
                    Variable global = this.file_.lookupGlobal(ins.address());
                    if (global == null) {
                        global = this.file_.lookupVariable(ins.pc(), ins.address(), Scope.Static);
                    }
                    DNode node = new DGlobal(global);
                    DStore store = new DStore(node, block.stack().reg(ins.reg()));
                    block.add(node);
                    block.add(store);
                    continue block68;
                }
                case Call: {
                    LCall ins = (LCall)uins;
                    Function f = this.file_.lookupFunction(ins.address());
                    DConstant args = (DConstant)block.stack().popValue();
                    long argslength = args.value();
                    if (this.file_.PassArgCountAsSize()) {
                        argslength /= 4L;
                    }
                    LinkedList<DNode> arguments = new LinkedList<DNode>();
                    int i = 0;
                    while ((long)i < argslength) {
                        arguments.add(block.stack().popName());
                        ++i;
                    }
                    DCall call = new DCall(f, arguments.toArray(new DNode[0]));
                    block.stack().set(Register.Pri, (DNode)call);
                    block.add(call);
                    continue block68;
                }
                case EqualConstant: {
                    LEqualConstant ins = (LEqualConstant)uins;
                    DConstant c = new DConstant(ins.value());
                    DNode node = new DBinary(SPOpcode.eq, block.stack().reg(ins.reg()), c);
                    block.stack().set(Register.Pri, node);
                    block.add(c);
                    block.add(node);
                    continue block68;
                }
                case LoadIndex: {
                    LLoadIndex ins = (LLoadIndex)uins;
                    DArrayRef aref = new DArrayRef(block.stack().alt(), block.stack().pri(), ins.shift());
                    DLoad load = new DLoad(aref);
                    block.stack().set(Register.Pri, (DNode)load);
                    block.add(aref);
                    block.add(load);
                    continue block68;
                }
                case ZeroGlobal: {
                    LZeroGlobal ins = (LZeroGlobal)uins;
                    Variable global = this.file_.lookupGlobal(ins.address());
                    if (global == null) {
                        global = this.file_.lookupVariable(ins.pc(), ins.address(), Scope.Static);
                    }
                    DGlobal dglobal = new DGlobal(global);
                    DConstant rhs = new DConstant(0L);
                    DStore lhs = new DStore(dglobal, rhs);
                    block.add(dglobal);
                    block.add(rhs);
                    block.add(lhs);
                    continue block68;
                }
                case IncGlobal: {
                    LIncGlobal ins = (LIncGlobal)uins;
                    Variable global = this.file_.lookupGlobal(ins.address());
                    if (global == null) {
                        global = this.file_.lookupVariable(ins.pc(), ins.address(), Scope.Static);
                    }
                    DGlobal dglobal = new DGlobal(global);
                    DLoad load = new DLoad(dglobal);
                    DConstant val = new DConstant(1L);
                    DBinary add = new DBinary(SPOpcode.add, load, val);
                    DStore store = new DStore(dglobal, add);
                    block.add(load);
                    block.add(val);
                    block.add(add);
                    block.add(store);
                    continue block68;
                }
                case DecGlobal: {
                    LDecGlobal ins = (LDecGlobal)uins;
                    Variable global = this.file_.lookupGlobal(ins.address());
                    if (global == null) {
                        global = this.file_.lookupVariable(ins.pc(), ins.address(), Scope.Static);
                    }
                    DGlobal dglobal = new DGlobal(global);
                    DLoad load = new DLoad(dglobal);
                    DConstant val = new DConstant(1L);
                    DBinary sub = new DBinary(SPOpcode.sub, load, val);
                    DStore store = new DStore(dglobal, sub);
                    block.add(load);
                    block.add(val);
                    block.add(sub);
                    block.add(store);
                    continue block68;
                }
                case StoreGlobalConstant: {
                    LStoreGlobalConstant lstore = (LStoreGlobalConstant)uins;
                    Object var = this.file_.lookupGlobal(lstore.address());
                    if (var == null) {
                        var = this.file_.lookupVariable(lstore.pc(), lstore.address(), Scope.Static);
                    }
                    DConstant val = new DConstant(lstore.value());
                    DGlobal global = new DGlobal((Variable)var);
                    DStore store = new DStore(global, val);
                    block.add(val);
                    block.add(global);
                    block.add(store);
                    continue block68;
                }
                case StoreLocalConstant: {
                    LStoreLocalConstant lstore = (LStoreLocalConstant)uins;
                    Object var = (DDeclareLocal)block.stack().getName(lstore.address());
                    DConstant val = new DConstant(lstore.value());
                    DStore store = new DStore((DNode)var, val);
                    block.add(val);
                    block.add(store);
                    continue block68;
                }
                case ZeroLocal: {
                    LZeroLocal lstore = (LZeroLocal)uins;
                    Object var = (DDeclareLocal)block.stack().getName(lstore.address());
                    DConstant val = new DConstant(0L);
                    DStore store = new DStore((DNode)var, val);
                    block.add(val);
                    block.add(store);
                    continue block68;
                }
                case Heap: {
                    LHeap ins = (LHeap)uins;
                    DHeap heap = new DHeap(ins.amount());
                    block.add(heap);
                    block.stack().set(Register.Alt, (DNode)heap);
                    continue block68;
                }
                case MemCopy: {
                    LMemCopy ins = (LMemCopy)uins;
                    DMemCopy copy = new DMemCopy(block.stack().alt(), block.stack().pri(), ins.bytes());
                    block.add(copy);
                    continue block68;
                }
                case Switch: {
                    LSwitch ins = (LSwitch)uins;
                    DSwitch switch_ = new DSwitch(block.stack().pri(), ins);
                    block.add(switch_);
                    continue block68;
                }
                case GenArray: {
                    LGenArray ins = (LGenArray)uins;
                    DNode[] dims = new DNode[ins.dims()];
                    for (int i = 0; i < ins.dims(); ++i) {
                        dims[i] = block.stack().popValue();
                    }
                    DGenArray genarray_ = new DGenArray(ins.pc() + (long)(4 * ins.dims()) + 4L, dims, ins.autozero());
                    block.stack().push(genarray_);
                    block.add(genarray_);
                    continue block68;
                }
                case InitArray: {
                    LInitArray ins = (LInitArray)uins;
                    continue block68;
                }
                case StackAdjust: {
                    int i;
                    int amt;
                    LStackAdjust ins = (LStackAdjust)uins;
                    assert (ins.value() % 4 == 0);
                    if (ins.value() < block.stack().depth()) {
                        amt = (ins.value() - block.stack().depth()) / -4;
                        for (i = 0; i < amt; ++i) {
                            DDeclareLocal local = new DDeclareLocal(ins.pc(), null);
                            block.stack().push(local);
                            block.add(local);
                        }
                    } else {
                        amt = (block.stack().depth() - ins.value()) / -4;
                        for (i = 0; i < amt; ++i) {
                            block.stack().pop();
                        }
                    }
                    if (ins.value() <= 0 && block.nodes().first() != block.nodes().last()) continue block68;
                    block.add(new DLabel(ins.pc()));
                    continue block68;
                }
                case LoadCtrl: {
                    LLoadCtrl ins = (LLoadCtrl)uins;
                    assert (ins.ctrlregindex() == 5);
                    block.stack().set(Register.Pri, (DNode)new DConstant(0L));
                    continue block68;
                }
                case StoreCtrl: {
                    int i;
                    long amt;
                    LStoreCtrl ins = (LStoreCtrl)uins;
                    assert (ins.ctrlregindex() == 4);
                    DNode pri = block.stack().pri();
                    assert (pri.type() == NodeType.Binary);
                    DBinary add = (DBinary)pri;
                    assert (add.lhs().type() == NodeType.Constant && add.rhs().type() == NodeType.Constant);
                    DConstant frm = (DConstant)add.lhs();
                    assert (frm.value() == 0L);
                    DConstant stkadjust = (DConstant)add.rhs();
                    assert (stkadjust.value() <= 0L);
                    assert (stkadjust.value() % 4L == 0L);
                    if (stkadjust.value() < (long)block.stack().depth()) {
                        amt = (stkadjust.value() - (long)block.stack().depth()) / -4L;
                        i = 0;
                        while ((long)i < amt) {
                            DDeclareLocal local = new DDeclareLocal(ins.pc(), null);
                            block.stack().push(local);
                            block.add(local);
                            ++i;
                        }
                    } else {
                        amt = ((long)block.stack().depth() - stkadjust.value()) / -4L;
                        i = 0;
                        while ((long)i < amt) {
                            block.stack().pop();
                            ++i;
                        }
                    }
                    block.add(new DLabel(ins.pc()));
                    continue block68;
                }
                default: {
                    throw new Exception("unhandled opcode " + (Object)((Object)uins.op()));
                }
            }
        }
        for (int i = 0; i < block.lir().idominated().length; ++i) {
            LBlock lir = block.lir().idominated()[i];
            if (lir == null) continue;
            this.traverse(this.blocks_[lir.id()]);
        }
    }

    public NodeBlock[] buildNodes() throws Exception {
        this.blocks_[0].inherit(this.graph_, null);
        this.traverse(this.blocks_[0]);
        return this.blocks_;
    }
}

