/*
 * Decompiled with CFR 0.152.
 */
package lysis;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import lysis.PawnFile;
import lysis.builder.MethodParser;
import lysis.builder.SourceBuilder;
import lysis.builder.structure.ControlBlock;
import lysis.builder.structure.SourceStructureBuilder;
import lysis.lstructure.Argument;
import lysis.lstructure.Function;
import lysis.lstructure.LGraph;
import lysis.lstructure.VariableType;
import lysis.nodes.NodeAnalysis;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeBuilder;
import lysis.nodes.NodeGraph;
import lysis.nodes.NodeRenamer;
import lysis.nodes.NodeRewriter;
import lysis.types.BackwardTypePropagation;
import lysis.types.ForwardTypePropagation;

public class Lysis {
    public static void PreprocessMethod(PawnFile file, Function func) throws Exception {
        MethodParser mp = new MethodParser(file, func);
        mp.preprocess();
        int nargs = mp.getNumArgs();
        if (func.codeEnd() == (long)(file.code().bytes().length + 1)) {
            func.setCodeEnd(mp.getExitPC() - 4L);
        }
        if (func.args() == null || func.args().length < nargs) {
            Argument arg;
            int i;
            LinkedList<Argument> args = new LinkedList<Argument>();
            int start = 0;
            int num = nargs;
            if (func.args() != null) {
                start = func.args().length;
                for (Argument arg2 : func.args()) {
                    args.add(arg2);
                }
            }
            for (i = start; i < num; ++i) {
                Argument arg3 = new Argument(VariableType.Normal, "_arg" + i, 0, null, null);
                arg3.markGenerated();
                if (!file.addArgumentDummyVar(func, i)) {
                    arg3 = file.buildArgumentInfo(func, i);
                }
                args.add(arg3);
            }
            i = num;
            while ((arg = file.buildArgumentInfo(func, i)) != null) {
                args.add(arg);
                ++i;
            }
            func.setArguments(args);
        }
    }

    public static void DumpMethod(PawnFile file, SourceBuilder source, Function func) throws Exception {
        MethodParser mp = new MethodParser(file, func);
        LGraph graph = mp.parse();
        if (graph == null) {
            return;
        }
        NodeBuilder nb = new NodeBuilder(file, graph);
        NodeBlock[] nblocks = nb.buildNodes();
        NodeGraph ngraph = new NodeGraph(file, nblocks);
        NodeAnalysis.RemoveDeadCode(ngraph);
        NodeRewriter rewriter = new NodeRewriter(ngraph);
        rewriter.rewrite();
        NodeAnalysis.CollapseArrayReferences(ngraph);
        ForwardTypePropagation ftypes = new ForwardTypePropagation(ngraph);
        ftypes.propagate();
        BackwardTypePropagation btypes = new BackwardTypePropagation(ngraph);
        btypes.propagate();
        ftypes.propagate();
        btypes.propagate();
        NodeAnalysis.CollapseArrayReferences(ngraph);
        ftypes.propagate();
        btypes.propagate();
        NodeAnalysis.CoalesceLoadStores(ngraph);
        NodeAnalysis.HandleMemCopys(ngraph);
        NodeAnalysis.AnalyzeHeapUsage(ngraph);
        NodeAnalysis.RemoveGuards(ngraph);
        NodeAnalysis.RemoveDeadCode(ngraph);
        NodeRenamer renamer = new NodeRenamer(ngraph);
        renamer.rename();
        NodeAnalysis.CoalesceLoadsAndDeclarations(ngraph);
        SourceStructureBuilder sb = new SourceStructureBuilder(ngraph);
        ControlBlock structure = sb.build();
        source.write(structure);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: <file.smx> or <file.amxx> or <file.amx>");
            return;
        }
        try {
            PrintStream sysout = new PrintStream((OutputStream)System.out, true, "UTF-8");
            System.setOut(sysout);
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        String path = args[0];
        PawnFile file = null;
        try {
            file = PawnFile.FromFile(path);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return;
        }
        if (file == null) {
            System.err.println("Failed to parse file.");
            return;
        }
        for (int i = 0; i < file.functions().length; ++i) {
            Function fun = file.functions()[i];
            try {
                Lysis.PreprocessMethod(file, fun);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.out.println("");
                System.out.println("/* ERROR PREPROCESSING! " + e.getMessage() + " */");
                System.out.println(" function \"" + fun.name() + "\" (number " + i + ")");
            }
        }
        SourceBuilder source = new SourceBuilder(file, System.out);
        try {
            source.writeGlobals();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < file.functions().length; ++i) {
            Function fun = file.functions()[i];
            try {
                Lysis.DumpMethod(file, source, fun);
                System.out.println("");
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.out.println("");
                System.out.println("/* ERROR! " + e.getMessage() + " */");
                System.out.println(" function \"" + fun.name() + "\" (number " + i + ")");
                source = new SourceBuilder(file, System.out);
            }
        }
    }
}

