/*
 * Decompiled with CFR 0.152.
 */
package lysis;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.Arrays;
import lysis.BitConverter;
import lysis.Public;
import lysis.StupidWrapper;
import lysis.amxmodx.AMXModXFile;
import lysis.lstructure.Argument;
import lysis.lstructure.Function;
import lysis.lstructure.Native;
import lysis.lstructure.Scope;
import lysis.lstructure.Tag;
import lysis.lstructure.Variable;
import lysis.lstructure.VariableType;
import lysis.sourcepawn.SourcePawnFile;

public abstract class PawnFile {
    protected Function[] functions_;
    protected Public[] publics_;
    protected Variable[] globals_;
    protected Variable[] variables_ = new Variable[0];
    protected Tag[] tags_;
    protected Code code_;
    protected Data data_;
    protected PubVar[] pubvars_;
    protected Native[] natives_;
    protected DebugFile[] debugFiles_;
    protected DebugLine[] debugLines_;
    protected DebugHeader debugHeader_ = new DebugHeader();

    public static PawnFile FromFile(String path) throws Exception {
        int b;
        FileInputStream fs = new FileInputStream(path);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while ((b = fs.read()) >= 0) {
            bytes.write(b);
        }
        fs.close();
        byte[] vec = bytes.toByteArray();
        long magic = BitConverter.ToUInt32(vec, 0);
        int amx_magic = BitConverter.ToUInt16(vec, 4);
        if (magic == 1397769798L) {
            return new SourcePawnFile(vec);
        }
        if (magic == 1095587928L || magic == 1095587906L || (long)amx_magic == 57585L) {
            return new AMXModXFile(vec);
        }
        throw new Exception("not a .amxx or .smx file!");
    }

    public abstract String stringFromData(long var1);

    public abstract String stringFromData(long var1, int var3);

    public abstract float floatFromData(long var1);

    public abstract int int32FromData(long var1);

    public boolean isValidDataAddress(long address) {
        return address >= 0L && address < (long)this.DAT().length;
    }

    protected Tag findTag(long tag_id) {
        for (int i = 0; i < this.tags_.length; ++i) {
            if (this.tags_[i].tag_id() != tag_id) continue;
            return this.tags_[i];
        }
        return null;
    }

    protected Tag findTag(String name) {
        for (int i = 0; i < this.tags_.length; ++i) {
            if (!name.equals(this.tags_[i].name())) continue;
            return this.tags_[i];
        }
        return null;
    }

    protected Tag findOrCreateTag(String name) {
        return this.addTag(name, this.tags_[this.tags_.length - 1].tag_id() + 1L);
    }

    protected Tag addTag(String name, long tag_id) {
        Tag tag = this.findTag(name);
        if (tag != null) {
            assert (tag.tag_id() == tag_id);
            return tag;
        }
        tag = this.findTag(tag_id);
        if (tag != null) {
            assert (name.equals(tag.name()));
            return tag;
        }
        tag = new Tag(name, tag_id);
        this.tags_ = Arrays.copyOf(this.tags_, this.tags_.length + 1);
        this.tags_[this.tags_.length - 1] = tag;
        return tag;
    }

    public Function lookupFunction(long pc) {
        for (int i = 0; i < this.functions_.length; ++i) {
            Function f = this.functions_[i];
            if (pc < f.codeStart() || pc >= f.codeEnd()) continue;
            return f;
        }
        return null;
    }

    public Public lookupPublic(String name) {
        for (int i = 0; i < this.publics_.length; ++i) {
            if (this.publics_[i].name() != name) continue;
            return this.publics_[i];
        }
        return null;
    }

    public Public lookupPublic(long addr) {
        for (int i = 0; i < this.publics_.length; ++i) {
            if (this.publics_[i].address() != addr) continue;
            return this.publics_[i];
        }
        return null;
    }

    public String lookupFile(long address) {
        if (this.debugFiles_ == null) {
            return null;
        }
        int high = this.debugFiles_.length;
        int low = -1;
        while (high - low > 1) {
            int mid = low + high >> 1;
            if (this.debugFiles_[mid].address() <= address) {
                low = mid;
                continue;
            }
            high = mid;
        }
        if (low == -1) {
            return null;
        }
        return this.debugFiles_[low].name();
    }

    public int lookupLine(long address) {
        if (this.debugLines_ == null) {
            return -1;
        }
        int high = this.debugLines_.length;
        int low = -1;
        while (high - low > 1) {
            int mid = low + high >> 1;
            if (this.debugLines_[mid].address() <= address) {
                low = mid;
                continue;
            }
            high = mid;
        }
        if (low == -1) {
            return -1;
        }
        return this.debugLines_[low].line();
    }

    public Variable lookupDeclarations(long pc, StupidWrapper i, Scope scope) {
        ++i.i;
        while (i.i < this.variables_.length) {
            Variable var = this.variables_[i.i];
            if (pc == var.codeStart() && var.scope() == scope) {
                return var;
            }
            ++i.i;
        }
        return null;
    }

    public Variable lookupDeclarations(long pc, StupidWrapper i) {
        return this.lookupDeclarations(pc, i, Scope.Local);
    }

    public Variable lookupVariable(long pc, long offset, Scope scope) {
        for (int i = 0; i < this.variables_.length; ++i) {
            Variable var = this.variables_[i];
            if (pc < var.codeStart() || pc >= var.codeEnd() || offset != var.address() || var.scope() != scope) continue;
            return var;
        }
        return null;
    }

    public Variable lookupVariable(long pc, long offset) {
        return this.lookupVariable(pc, offset, Scope.Local);
    }

    public Variable lookupGlobal(long address) {
        for (int i = 0; i < this.globals_.length; ++i) {
            Variable var = this.globals_[i];
            if (var.address() != address) continue;
            return var;
        }
        return null;
    }

    public Function addFunction(long addr) {
        Function f;
        for (int i = 0; i < this.functions_.length; ++i) {
            if (this.functions_[i].address() != addr) continue;
            return this.functions_[i];
        }
        this.functions_ = Arrays.copyOf(this.functions_, this.functions_.length + 1);
        this.functions_[this.functions_.length - 1] = f = new Function(addr, addr, (long)(this.code().bytes().length + 1), "sub_" + Long.toHexString(addr), 0L);
        return f;
    }

    public boolean addArgumentDummyVar(Function func, int num) {
        long varAddr = 12 + num * 4;
        if (this.lookupVariable(func.address(), varAddr) != null) {
            return false;
        }
        Variable var = new Variable(varAddr, 0, null, func.codeStart(), func.codeEnd(), VariableType.Normal, Scope.Local, "_arg" + num, null);
        this.variables_ = Arrays.copyOf(this.variables_, this.variables_.length + 1);
        this.variables_[this.variables_.length - 1] = var;
        return true;
    }

    public Argument buildArgumentInfo(Function func, int argNum) {
        int argOffset = 12 + 4 * argNum;
        Variable var = this.lookupVariable(func.address(), argOffset);
        if (var == null) {
            return null;
        }
        return new Argument(var.type(), var.name(), (int)var.tag_id(), var.tag(), var.dims());
    }

    public void addGlobal(long addr) {
        if (this.lookupGlobal(addr) != null) {
            return;
        }
        for (int i = 0; i < this.variables_.length; ++i) {
            Variable var = this.variables_[i];
            if (addr != var.address() || var.scope() != Scope.Static) continue;
            return;
        }
        this.globals_ = Arrays.copyOf(this.globals_, this.globals_.length + 1);
        this.globals_[this.globals_.length - 1] = new Variable(addr, 0, null, 0L, this.code().bytes().length, VariableType.Normal, Scope.Global, "g_var" + Long.toHexString(addr), null);
    }

    public Function[] functions() {
        return this.functions_;
    }

    public Public[] publics() {
        return this.publics_;
    }

    public Variable[] globals() {
        return this.globals_;
    }

    public Code code() {
        return this.code_;
    }

    public Data data() {
        return this.data_;
    }

    public PubVar[] pubvars() {
        return this.pubvars_;
    }

    public Native[] natives() {
        return this.natives_;
    }

    public byte[] DAT() {
        return this.data().bytes();
    }

    public abstract boolean PassArgCountAsSize();

    public abstract Automation lookupAutomation(long var1);

    public abstract String lookupState(short var1, short var2);

    protected static byte[] Slice(byte[] bytes, int offset, int length) {
        byte[] shadow = new byte[length];
        for (int i = 0; i < length; ++i) {
            shadow[i] = bytes[offset + i];
        }
        return shadow;
    }

    public abstract boolean IsMaybeString(long var1);

    public class State {
        private short state_id_;
        private short automation_id_;
        private String name_;

        public State(short state_id, short automation_id, String name) {
            this.state_id_ = state_id;
            this.automation_id_ = automation_id;
            this.name_ = name;
        }

        public short state_id() {
            return this.state_id_;
        }

        public short automation_id() {
            return this.automation_id_;
        }

        public String name() {
            return this.name_;
        }

        public String toString() {
            return String.format("State %d of automation %d : %s", this.state_id_, this.automation_id_, this.name_);
        }
    }

    public class Automation {
        private short automation_id_;
        private long address_;
        private String name_;

        public Automation(short automation_id, long address, String name) {
            this.automation_id_ = automation_id;
            this.address_ = address;
            this.name_ = name;
        }

        public short automation_id() {
            return this.automation_id_;
        }

        public long address() {
            return this.address_;
        }

        public String name() {
            return this.name_;
        }

        public String toString() {
            return String.format("Automation %d @ %x : %s", this.automation_id_, this.address_, this.name_);
        }
    }

    public class DebugLine {
        private long address_;
        private int line_;

        public DebugLine(int line, long address) {
            this.line_ = line;
            this.address_ = address;
        }

        public int line() {
            return this.line_;
        }

        public long address() {
            return this.address_;
        }

        public String toString() {
            return String.format("Line %d @ %x", this.line_, this.address_);
        }
    }

    public class DebugFile {
        private long address_;
        private String name_;

        public DebugFile(String name, long address) {
            this.name_ = name;
            this.address_ = address;
        }

        public String name() {
            return this.name_;
        }

        public long address() {
            return this.address_;
        }

        public String toString() {
            return String.format("File %s @ %x", this.name_, this.address_);
        }
    }

    public class PubVar {
        private long address_;
        private String name_;

        public PubVar(String name, long address) {
            this.name_ = name;
            this.address_ = address;
        }

        public String name() {
            return this.name_;
        }

        public long address() {
            return this.address_;
        }
    }

    public class Data {
        private byte[] data_;
        private int memory_;

        public Data(byte[] data, int memory) {
            this.data_ = data;
            this.memory_ = memory;
        }

        public byte[] bytes() {
            return this.data_;
        }

        public int memory() {
            return this.memory_;
        }
    }

    public class Code {
        private byte[] code_;
        private byte cellsize_;
        private int flags_;
        private long main_;
        private int version_;

        public Code(byte[] code, byte cellsize, int flags, long main, int version) {
            this.code_ = code;
            this.cellsize_ = cellsize;
            this.flags_ = flags;
            this.main_ = main;
            this.version_ = version;
        }

        public byte[] bytes() {
            return this.code_;
        }

        public byte cellsize() {
            return this.cellsize_;
        }

        public int flags() {
            return this.flags_;
        }

        public long main() {
            return this.main_;
        }

        public int version() {
            return this.version_;
        }
    }

    public class DebugHeader {
        public int numFiles;
        public int numLines;
        public int numSyms;
    }
}

