/*
 * Decompiled with CFR 0.152.
 */
package lysis.amxmodx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.zip.Inflater;
import lysis.BitConverter;
import lysis.ExtendedDataInputStream;
import lysis.PawnFile;
import lysis.Public;
import lysis.lstructure.Argument;
import lysis.lstructure.Dimension;
import lysis.lstructure.Function;
import lysis.lstructure.Native;
import lysis.lstructure.Scope;
import lysis.lstructure.Tag;
import lysis.lstructure.Variable;
import lysis.lstructure.VariableType;

public class AMXModXFile
extends PawnFile {
    public static final long MAGIC = 1095587906L;
    public static final long MAGIC2 = 1095587928L;
    public static final long MAGIC2_VERSION = 768L;
    public static final long AMX_MAGIC = 57585L;
    public static final long AMX_DBG_MAGIC = 61425L;
    public static final long MIN_FILE_VERSION = 6L;
    public static final long MIN_DEBUG_FILE_VERSION = 8L;
    public static final long CUR_FILE_VERSION = 8L;
    public static final int DEFSIZE = 8;
    public static final int AMX_FLAG_DEBUG = 2;
    public static final int AMX_FLAG_COMPACT = 4;
    public static final int AMX_FLAG_BYTEOPC = 8;
    public static final int AMX_FLAG_NOCHECKS = 16;
    public static final byte IDENT_VARIABLE = 1;
    public static final byte IDENT_REFERENCE = 2;
    public static final byte IDENT_ARRAY = 3;
    public static final byte IDENT_REFARRAY = 4;
    public static final byte IDENT_FUNCTION = 9;
    public static final byte IDENT_VARARGS = 11;
    private static final long Q_USER_TAG_STRING = 100500L;
    private Variable[] allvars_;
    private Tag stringTag;
    private PawnFile.Automation[] automations_;
    private PawnFile.State[] states_;

    public AMXModXFile(byte[] binary) throws Exception {
        block52: {
            Object r2;
            String name;
            int nameoffset;
            AMX_HEADER amx;
            int i;
            block51: {
                int i2;
                Inflater gzip;
                byte[] bits;
                ExtendedDataInputStream reader = new ExtendedDataInputStream(new ByteArrayInputStream(binary));
                long magic = reader.ReadUInt32();
                if (magic == 1095587906L) {
                    TableEntry tableEntry = null;
                    byte numPlugins = reader.readByte();
                    byte tableIndex = 0;
                    for (tableIndex = 0; tableIndex < numPlugins; tableIndex = (byte)(tableIndex + 1)) {
                        TableEntry t = new TableEntry();
                        t.cellSize = reader.readByte();
                        t.origSize = reader.ReadInt32();
                        t.offset = reader.ReadInt32();
                        if (t.cellSize != 4) continue;
                        tableEntry = t;
                        break;
                    }
                    if (tableEntry == null) {
                        throw new Exception("could not find applicable cell size");
                    }
                    int sectionLength = 0;
                    if (tableIndex + 1 < numPlugins) {
                        TableEntry nextTableEntry = new TableEntry();
                        nextTableEntry.cellSize = reader.readByte();
                        nextTableEntry.origSize = reader.ReadInt32();
                        nextTableEntry.offset = reader.ReadInt32();
                        sectionLength = nextTableEntry.offset - tableEntry.offset;
                    } else {
                        sectionLength = binary.length - tableEntry.offset;
                    }
                    bits = new byte[tableEntry.origSize];
                    gzip = new Inflater(true);
                    gzip.setInput(binary, tableEntry.offset + 2, sectionLength);
                    gzip.inflate(bits, 0, tableEntry.origSize);
                    binary = bits;
                } else if (magic == 1095587928L) {
                    int version = reader.ReadUInt16();
                    if ((long)version > 768L) {
                        throw new Exception("unexpected version");
                    }
                    PluginHeader ph = null;
                    int numPlugins = reader.readByte();
                    for (i = 0; i < numPlugins; i = (byte)(i + 1)) {
                        PluginHeader p = new PluginHeader();
                        p.cellsize = reader.readByte();
                        p.disksize = reader.ReadInt32();
                        p.imagesize = reader.ReadInt32();
                        p.memsize = reader.ReadInt32();
                        p.offset = reader.ReadInt32();
                        if (p.cellsize != 4) continue;
                        ph = p;
                        break;
                    }
                    if (ph == null) {
                        throw new Exception("could not find applicable cell size");
                    }
                    int bufferSize = ph.imagesize > ph.memsize ? ph.imagesize + 1 : ph.memsize + 1;
                    bits = new byte[bufferSize];
                    gzip = new Inflater(true);
                    gzip.setInput(binary, ph.offset + 2, ph.disksize - 2);
                    int read = gzip.inflate(bits, 0, bufferSize);
                    if (read != ph.imagesize) {
                        System.err.printf("uncompressed size mismatch, bad file? expected %d, got %d\n", ph.imagesize, read);
                    }
                    binary = bits;
                } else {
                    int amx_magic = reader.ReadUInt16();
                    if ((long)amx_magic != 57585L) {
                        throw new Exception("unrecognized file");
                    }
                }
                reader.close();
                reader = new ExtendedDataInputStream(new ByteArrayInputStream(binary));
                amx = new AMX_HEADER();
                amx.size = reader.ReadInt32();
                amx.magic = reader.ReadUInt16();
                amx.file_version = reader.readByte();
                amx.amx_version = reader.readByte();
                amx.flags = reader.ReadInt16();
                amx.defsize = reader.ReadInt16();
                amx.cod = reader.ReadInt32();
                amx.dat = reader.ReadInt32();
                amx.hea = reader.ReadInt32();
                amx.stp = reader.ReadInt32();
                amx.cip = reader.ReadInt32();
                amx.publics = reader.ReadInt32();
                amx.natives = reader.ReadInt32();
                amx.libraries = reader.ReadInt32();
                amx.pubvars = reader.ReadInt32();
                amx.tags = reader.ReadInt32();
                amx.nametable = reader.ReadInt32();
                if ((long)amx.magic != 57585L) {
                    throw new Exception(String.format("unrecognized amx header %x", amx.magic));
                }
                if ((long)amx.file_version < 6L || (long)amx.file_version > 8L) {
                    throw new Exception("unrecognized amx version");
                }
                if (amx.defsize != 8) {
                    throw new Exception("unrecognized header defsize");
                }
                if (amx.publics > 0) {
                    int count = (amx.natives - amx.publics) / 8;
                    this.publics_ = new Public[count];
                    this.functions_ = new Function[count];
                    ExtendedDataInputStream r2 = new ExtendedDataInputStream(new ByteArrayInputStream(binary, amx.publics, count * 8));
                    for (i = 0; i < this.publics_.length; ++i) {
                        long address = r2.ReadUInt32();
                        nameoffset = r2.ReadInt32();
                        name = AMXModXFile.ReadName(binary, nameoffset);
                        this.publics_[i] = new Public(name, address);
                        this.functions_[i] = new Function(address, address, 0L, name);
                    }
                    r2.close();
                }
                assert ((amx.flags & 4) == 4 || amx.size == amx.hea);
                if ((amx.flags & 4) == 4) {
                    binary = this.decompressCompactCode(amx, binary);
                }
                byte[] codeBytes = AMXModXFile.Slice(binary, amx.cod, amx.dat - amx.cod);
                this.code_ = new PawnFile.Code(this, codeBytes, 0, 0, 0L, 0);
                r2 = this.functions_;
                i = ((Function[])r2).length;
                for (int address = 0; address < i; ++address) {
                    Function f = r2[address];
                    f.setCodeEnd(this.code().bytes().length + 1);
                }
                byte[] dataBytes = AMXModXFile.Slice(binary, amx.dat, amx.hea - amx.dat);
                this.data_ = new PawnFile.Data(this, dataBytes, amx.hea - amx.dat);
                if (amx.natives > 0) {
                    int count = (amx.libraries - amx.natives) / 8;
                    this.natives_ = new Native[count];
                    r2 = new ExtendedDataInputStream(new ByteArrayInputStream(binary, amx.natives, count * 8));
                    for (i = 0; i < count; ++i) {
                        ((ExtendedDataInputStream)r2).ReadUInt32();
                        int nameoffset2 = ((ExtendedDataInputStream)r2).ReadInt32();
                        String name2 = AMXModXFile.ReadName(binary, nameoffset2);
                        this.natives_[i] = new Native(name2, i);
                    }
                    ((FilterInputStream)r2).close();
                }
                if (amx.pubvars > 0) {
                    int count = (amx.tags - amx.pubvars) / 8;
                    this.pubvars_ = new PawnFile.PubVar[count];
                    this.globals_ = new Variable[count];
                    r2 = new ExtendedDataInputStream(new ByteArrayInputStream(binary, amx.pubvars, count * 8));
                    for (i = 0; i < count; ++i) {
                        long address = ((ExtendedDataInputStream)r2).ReadUInt32();
                        nameoffset = ((ExtendedDataInputStream)r2).ReadInt32();
                        name = AMXModXFile.ReadName(binary, nameoffset);
                        this.pubvars_[i] = new PawnFile.PubVar(this, name, address);
                        this.globals_[i] = new Variable(address, 0, null, 0L, this.code().bytes().length, VariableType.Normal, Scope.Global, name, null);
                    }
                    this.allvars_ = (Variable[])this.globals_.clone();
                    ((FilterInputStream)r2).close();
                }
                if ((long)amx.file_version < 8L || (amx.flags & 2) != 2) break block51;
                ExtendedDataInputStream r3 = new ExtendedDataInputStream(new ByteArrayInputStream(binary, amx.hea, 22));
                AMX_DEBUG_HDR dbg = new AMX_DEBUG_HDR();
                dbg.size = r3.ReadInt32();
                dbg.magic = r3.ReadUInt16();
                dbg.file_version = r3.readByte();
                dbg.amx_version = r3.readByte();
                dbg.flags = r3.ReadInt16();
                dbg.files = r3.ReadInt16();
                dbg.lines = r3.ReadInt16();
                dbg.symbols = r3.ReadInt16();
                dbg.tags = r3.ReadInt16();
                dbg.automatons = r3.ReadInt16();
                dbg.states = r3.ReadInt16();
                if ((long)dbg.magic != 61425L) {
                    throw new Exception("unrecognized debug magic");
                }
                r3 = new ExtendedDataInputStream(new ByteArrayInputStream(binary, amx.hea + 22, dbg.size - 22));
                this.debugHeader_.numFiles = dbg.files;
                this.debugHeader_.numLines = dbg.lines;
                this.debugHeader_.numSyms = dbg.symbols;
                this.debugFiles_ = new PawnFile.DebugFile[dbg.files];
                for (i = 0; i < dbg.files; i = (int)((short)(i + 1))) {
                    long offset = r3.ReadUInt32();
                    String name3 = AMXModXFile.ReadName(r3);
                    this.debugFiles_[i] = new PawnFile.DebugFile(this, name3, offset);
                }
                this.debugLines_ = new PawnFile.DebugLine[dbg.lines];
                for (i = 0; i < dbg.lines; i = (int)((short)(i + 1))) {
                    long offset = r3.ReadUInt32();
                    int lineno = r3.ReadInt32();
                    this.debugLines_[i] = new PawnFile.DebugLine(this, lineno, offset);
                }
                LinkedList<Function> functions = new LinkedList<Function>();
                if (this.functions_ != null) {
                    functions.addAll(Arrays.asList(this.functions_));
                }
                LinkedList<Variable> globals = new LinkedList<Variable>();
                if (this.globals_ != null) {
                    globals.addAll(Arrays.asList(this.globals_));
                }
                LinkedList<Variable> locals = new LinkedList<Variable>();
                LinkedList<Variable> allvars = new LinkedList<Variable>();
                for (i2 = 0; i2 < dbg.symbols; i2 = (short)(i2 + 1)) {
                    int addr = r3.ReadInt32();
                    int tagid = r3.ReadUInt16();
                    long codestart = r3.ReadUInt32();
                    long codeend = r3.ReadUInt32();
                    byte ident = r3.readByte();
                    byte vclassByte = r3.readByte();
                    Scope vclass = Scope.Local;
                    if (vclassByte >= 0 && vclassByte < Scope.values().length) {
                        vclass = Scope.values()[vclassByte];
                    }
                    int dimcount = r3.ReadInt16();
                    String name4 = AMXModXFile.ReadName(r3);
                    if (ident == 9) {
                        Function func = new Function((long)addr, codestart, codeend, name4, tagid);
                        Function existingFunction = null;
                        for (Function otherFunc : functions) {
                            if (!name4.equals(otherFunc.name())) continue;
                            existingFunction = otherFunc;
                            break;
                        }
                        if (existingFunction != null) {
                            if (existingFunction.address() != func.address() || existingFunction.codeStart() != func.codeStart()) {
                                System.err.printf("// Duplicate information for symbol \"%s\" at %x with different addresses. Keeping the existing at %x.%n", name4, func.address(), existingFunction.address());
                            }
                            functions.remove(existingFunction);
                        }
                        functions.add(func);
                        continue;
                    }
                    VariableType type = AMXModXFile.FromIdent(ident);
                    Dimension[] dims = null;
                    if (dimcount > 0) {
                        dims = new Dimension[dimcount];
                        for (int j = 0; j < dimcount; ++j) {
                            short tag_id = r3.ReadInt16();
                            int size = r3.ReadInt32();
                            dims[j] = new Dimension(tag_id, null, size);
                        }
                    }
                    Variable var = new Variable(addr, tagid, null, codestart, codeend, type, vclass, name4, dims);
                    if (vclass == Scope.Global) {
                        Variable existingGlobal = null;
                        for (Variable glob : globals) {
                            if (!name4.equals(glob.name())) continue;
                            existingGlobal = glob;
                            break;
                        }
                        if (existingGlobal != null) {
                            if (existingGlobal.address() != (long)addr) {
                                System.err.printf("// Error reading debug info. Duplicate information for symbol \"%s\" with differing address %x from already known address %x.%n", name4, addr, existingGlobal.address());
                                break;
                            }
                            globals.remove(existingGlobal);
                        }
                        globals.add(var);
                        continue;
                    }
                    locals.add(var);
                }
                Collections.sort(globals, new Comparator<Variable>(){

                    @Override
                    public int compare(Variable var1, Variable var2) {
                        return (int)(var1.address() - var2.address());
                    }
                });
                Collections.sort(functions, new Comparator<Function>(){

                    @Override
                    public int compare(Function fun1, Function fun2) {
                        return (int)(fun1.address() - fun2.address());
                    }
                });
                allvars.addAll(locals);
                allvars.addAll(globals);
                Collections.sort(allvars, new Comparator<Variable>(){

                    @Override
                    public int compare(Variable var1, Variable var2) {
                        return (int)(var1.address() - var2.address());
                    }
                });
                this.variables_ = locals.toArray(new Variable[0]);
                this.globals_ = globals.toArray(new Variable[0]);
                this.functions_ = functions.toArray(new Function[0]);
                this.allvars_ = allvars.toArray(new Variable[0]);
                this.tags_ = new Tag[dbg.tags + 1];
                for (i2 = 0; i2 < dbg.tags; i2 = (short)(i2 + 1)) {
                    int tag_id = r3.ReadUInt16();
                    String name5 = AMXModXFile.ReadName(r3);
                    this.tags_[i2] = new Tag(name5, tag_id);
                }
                this.automations_ = new PawnFile.Automation[dbg.automatons];
                for (i2 = 0; i2 < dbg.automatons; i2 = (short)(i2 + 1)) {
                    short automation_id = r3.ReadInt16();
                    int addr = r3.ReadInt32();
                    String name6 = AMXModXFile.ReadName(r3);
                    this.automations_[i2] = new PawnFile.Automation(this, automation_id, addr, name6);
                }
                this.states_ = new PawnFile.State[dbg.states];
                for (i2 = 0; i2 < dbg.states; i2 = (short)(i2 + 1)) {
                    short state_id = r3.ReadInt16();
                    short automation_id = r3.ReadInt16();
                    String name7 = AMXModXFile.ReadName(r3);
                    this.states_[i2] = new PawnFile.State(this, state_id, automation_id, name7);
                }
                this.tags_[dbg.tags] = this.stringTag = new Tag("String", 100500L);
                for (i2 = 0; i2 < this.functions_.length; ++i2) {
                    this.functions_[i2].setTag(this.findTag(this.functions_[i2].tag_id()));
                }
                for (i2 = 0; i2 < this.variables_.length; ++i2) {
                    this.variables_[i2].setTag(this.findTag(this.variables_[i2].tag_id(), this.variables_[i2]));
                }
                for (i2 = 0; i2 < this.globals_.length; ++i2) {
                    this.globals_[i2].setTag(this.findTag(this.globals_[i2].tag_id(), this.globals_[i2]));
                }
                for (i2 = 0; i2 < this.functions_.length; ++i2) {
                    Argument arg;
                    Function fun = this.functions_[i2];
                    int argNum = 0;
                    LinkedList<Argument> args = new LinkedList<Argument>();
                    while ((arg = this.buildArgumentInfo(fun, argNum)) != null) {
                        args.add(arg);
                        ++argNum;
                    }
                    fun.setArguments(args);
                }
                break block52;
            }
            if (amx.file_version != 7) break block52;
            int count = (amx.nametable - amx.tags) / 8;
            r2 = new ExtendedDataInputStream(new ByteArrayInputStream(binary, amx.tags, count * 8));
            this.tags_ = new Tag[count];
            for (i = 0; i < count; i = (int)((short)(i + 1))) {
                long tag_id = ((ExtendedDataInputStream)r2).ReadUInt32();
                nameoffset = ((ExtendedDataInputStream)r2).ReadInt32();
                name = AMXModXFile.ReadName(binary, nameoffset);
                this.tags_[i] = new Tag(name, tag_id);
            }
        }
    }

    @Override
    public Argument buildArgumentInfo(Function func, int argNum) {
        int argOffset = 12 + 4 * argNum;
        Variable var = this.lookupVariable(func.address(), argOffset);
        if (var == null) {
            return null;
        }
        if (var.type() == VariableType.ArrayReference && var.dims() != null && var.dims().length == 1 && var.dims()[0].size() == 0 && var.tag() != null && var.tag().name() == "_") {
            var.setTag(this.stringTag);
            var.setTagId(100500L);
        }
        int tagId = -1;
        if (var.tag() != null) {
            tagId = (int)var.tag().tag_id();
        }
        return new Argument(var.type(), var.name(), tagId, var.tag(), var.dims());
    }

    private static String ReadName(byte[] bytes, int offset) {
        int count;
        for (count = offset; count < bytes.length && bytes[count] != 0; ++count) {
        }
        try {
            return new String(bytes, offset, count - offset, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String ReadName(DataInputStream r) throws IOException {
        byte b;
        LinkedList<Byte> buffer = new LinkedList<Byte>();
        while ((b = r.readByte()) != 0) {
            buffer.add(b);
        }
        try {
            byte[] bytes = new byte[buffer.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (Byte)buffer.get(i);
            }
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String ReadString(byte[] bytes, int offset) {
        LinkedList<Byte> buffer = new LinkedList<Byte>();
        for (int count = offset; count < bytes.length && bytes[count] != 0; count += 4) {
            int cell = BitConverter.ToInt32(bytes, count);
            buffer.add((byte)cell);
        }
        try {
            byte[] chars = new byte[buffer.size()];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = (Byte)buffer.get(i);
            }
            return new String(chars, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String ReadStringEx(byte[] bytes, int offset, int maxread) {
        int count;
        LinkedList<Byte> buffer = new LinkedList<Byte>();
        int last = count + maxread;
        for (count = offset; count < bytes.length && count <= last && bytes[count] != 0; count += 4) {
            int cell = BitConverter.ToInt32(bytes, count);
            buffer.add((byte)cell);
        }
        try {
            byte[] chars = new byte[buffer.size()];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = (Byte)buffer.get(i);
            }
            return new String(chars, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static VariableType FromIdent(byte ident) {
        switch (ident) {
            case 1: {
                return VariableType.Normal;
            }
            case 2: {
                return VariableType.Reference;
            }
            case 3: {
                return VariableType.Array;
            }
            case 4: {
                return VariableType.ArrayReference;
            }
            case 11: {
                return VariableType.Variadic;
            }
        }
        return VariableType.Normal;
    }

    private Tag findTag(long tag_id, Variable var) {
        Tag tag = this.findTag(tag_id);
        if (!"_".equals(tag.name())) {
            return tag;
        }
        Tag maybe = this.findTagString(var);
        if (maybe != null) {
            return maybe;
        }
        return tag;
    }

    private Tag findTagString(Variable var) {
        if (var.scope() == Scope.Local) {
            return null;
        }
        if (var.dims() == null) {
            return null;
        }
        if (var.dims().length == 1 && (var.type() == VariableType.ArrayReference || var.type() == VariableType.Array || var.type() == VariableType.Reference)) {
            int addr;
            boolean isPastVar = false;
            long size = 0L;
            for (int i = 0; i < this.allvars_.length; ++i) {
                if (this.allvars_[i] == var) {
                    isPastVar = true;
                    continue;
                }
                if (!isPastVar || this.allvars_[i].scope() == Scope.Local) continue;
                size = this.allvars_[i].address() - var.address();
                break;
            }
            if (size <= 0L) {
                return null;
            }
            int end = (int)(var.address() + size - 4L);
            if (BitConverter.ToInt32(this.DAT(), end) != 0) {
                return null;
            }
            for (addr = (int)var.address(); addr < this.DAT().length && addr < end; addr += 4) {
                int cell = BitConverter.ToInt32(this.DAT(), addr);
                if (cell != 0 && Character.isValidCodePoint(cell)) continue;
                return null;
            }
            if (addr != end) {
                return null;
            }
            return this.stringTag;
        }
        return null;
    }

    @Override
    public boolean IsMaybeString(long address) {
        int cell;
        int cell2;
        if (!this.isValidDataAddress(address)) {
            return false;
        }
        if (address >= 4L && (cell2 = BitConverter.ToInt32(this.DAT(), (int)(address - 4L))) > 0 && Character.isValidCodePoint(cell2)) {
            return false;
        }
        int len = 0;
        while (address < (long)this.DAT().length && (cell = BitConverter.ToInt32(this.DAT(), (int)address)) != 0) {
            if (!Character.isValidCodePoint(cell)) {
                return false;
            }
            address += 4L;
            ++len;
        }
        return len > 1;
    }

    public byte[] decompressCompactCode(AMX_HEADER amx, byte[] binary) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(binary.length);
        out.write(binary, 0, amx.cod);
        int codesize = amx.size - amx.cod;
        byte[] code = AMXModXFile.Slice(binary, amx.cod, codesize);
        Stack<Long> stack = new Stack<Long>();
        while (codesize > 0) {
            long c = 0L;
            int shift = 0;
            do {
                --codesize;
                assert (shift < 32);
                assert (shift > 0 || (code[codesize] & 0x80) == 0);
                c |= (long)((code[codesize] & 0x7F) << shift);
            } while (codesize > 0 && (code[codesize - 1] & 0x80) != 0);
            if ((code[codesize] & 0x40) != 0) {
                for (shift = (int)((short)(shift + 7)); shift < 32; shift = (int)((short)(shift + 8))) {
                    c |= (long)(255 << shift);
                }
            }
            stack.push(c);
        }
        while (!stack.empty()) {
            out.write(this.IntToBigEndianByteArray((Long)stack.pop()));
        }
        out.write(binary, amx.size, binary.length - amx.size);
        return out.toByteArray();
    }

    private byte[] IntToBigEndianByteArray(long value) {
        byte[] bytes = new byte[]{(byte)(value >> 0), (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        return bytes;
    }

    @Override
    public String stringFromData(long address) {
        return AMXModXFile.ReadString(this.DAT(), (int)address);
    }

    @Override
    public String stringFromData(long address, int maxread) {
        return AMXModXFile.ReadStringEx(this.DAT(), (int)address, maxread);
    }

    @Override
    public float floatFromData(long address) {
        return BitConverter.ToSingle(this.DAT(), address);
    }

    @Override
    public int int32FromData(long address) {
        assert (address >= 0L && (long)this.DAT().length > address);
        if (address >= 0L && (long)this.DAT().length <= address) {
            return 0;
        }
        return BitConverter.ToInt32(this.DAT(), (int)address);
    }

    @Override
    public boolean PassArgCountAsSize() {
        return true;
    }

    @Override
    public PawnFile.Automation lookupAutomation(long state_addr) {
        for (PawnFile.Automation auto : this.automations_) {
            if (auto.address() != state_addr) continue;
            return auto;
        }
        return null;
    }

    @Override
    public String lookupState(short state_id, short automation_id) {
        for (PawnFile.State state : this.states_) {
            if (state.automation_id() != automation_id || state.state_id() != state_id) continue;
            return state.name();
        }
        return null;
    }

    private class AMX_DEBUG_HDR {
        public int size;
        public int magic;
        public byte file_version;
        public byte amx_version;
        public short flags;
        public short files;
        public short lines;
        public short symbols;
        public short tags;
        public short automatons;
        public short states;
        public static final int SIZE = 22;

        private AMX_DEBUG_HDR() {
        }
    }

    private class AMX_HEADER {
        public int size;
        public int magic;
        public byte file_version;
        public byte amx_version;
        public short flags;
        public short defsize;
        public int cod;
        public int dat;
        public int hea;
        public int stp;
        public int cip;
        public int publics;
        public int natives;
        public int libraries;
        public int pubvars;
        public int tags;
        public int nametable;

        private AMX_HEADER() {
        }
    }

    public class TableEntry {
        public byte cellSize;
        public int origSize;
        public int offset;
    }

    public class PluginHeader {
        public byte cellsize;
        public int disksize;
        public int imagesize;
        public int memsize;
        public int offset;
    }
}

