/*
 * Decompiled with CFR 0.152.
 */
package lysis.builder.structure;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import lysis.PawnFile;
import lysis.instructions.LAddConstant;
import lysis.instructions.LControlInstruction;
import lysis.instructions.LGenArray;
import lysis.instructions.LGoto;
import lysis.instructions.LInstruction;
import lysis.instructions.LJumpCondition;
import lysis.instructions.LPushConstant;
import lysis.instructions.LStack;
import lysis.instructions.LStackAdjust;
import lysis.instructions.LStoreCtrl;
import lysis.instructions.Opcode;
import lysis.lstructure.LBlock;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeType;
import lysis.nodes.types.DJump;

public class BlockAnalysis {
    public static LBlock[] Order(LBlock entry) {
        Stack<LBlock> pending = new Stack<LBlock>();
        Stack<Integer> successors = new Stack<Integer>();
        Stack<LBlock> done = new Stack<LBlock>();
        LBlock current = entry;
        int nextSuccessor = 0;
        while (true) {
            if (!current.marked()) {
                current.mark();
                if (nextSuccessor < current.numSuccessors()) {
                    pending.push(current);
                    successors.push(nextSuccessor);
                    current = current.getSuccessor(nextSuccessor);
                    nextSuccessor = 0;
                    continue;
                }
                done.push(current);
            }
            if (pending.size() == 0) break;
            current = (LBlock)pending.pop();
            current.unmark();
            nextSuccessor = (Integer)successors.pop() + 1;
        }
        LinkedList<LBlock> blocks = new LinkedList<LBlock>();
        while (done.size() > 0) {
            current = (LBlock)done.pop();
            current.unmark();
            current.setId(blocks.size());
            blocks.add(current);
        }
        return blocks.toArray(new LBlock[0]);
    }

    public static void SplitCriticalEdges(LBlock[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            LBlock block = blocks[i];
            if (block.numSuccessors() < 2) continue;
            for (int j = 0; j < block.numSuccessors(); ++j) {
                LBlock target = block.getSuccessor(j);
                if (target.numPredecessors() < 2) continue;
                LBlock split = new LBlock(block.pc());
                LGoto ins = new LGoto(target);
                LInstruction[] instructions = new LInstruction[]{ins};
                split.setInstructions(instructions);
                block.replaceSuccessor(j, split);
                target.replacePredecessor(block, split);
                split.addPredecessor(block);
            }
        }
    }

    public static boolean IsReducible(LBlock[] blocks) {
        int i;
        RBlock[] rblocks = new RBlock[blocks.length];
        for (i = 0; i < blocks.length; ++i) {
            rblocks[i] = new RBlock();
        }
        for (i = 0; i < blocks.length; ++i) {
            int j;
            LBlock block = blocks[i];
            RBlock rblock = rblocks[i];
            for (j = 0; j < block.numPredecessors(); ++j) {
                rblock.predecessors.add(rblocks[block.getPredecessor(j).id()]);
            }
            for (j = 0; j < block.numSuccessors(); ++j) {
                rblock.successors.add(rblocks[block.getSuccessor(j).id()]);
            }
        }
        LinkedList<RBlock> queue = new LinkedList<RBlock>();
        for (int i2 = 0; i2 < rblocks.length; ++i2) {
            queue.add(rblocks[i2]);
        }
        block5: while (true) {
            LinkedList<RBlock> deleteQueue = new LinkedList<RBlock>();
            for (RBlock rblock : queue) {
                if (rblock.predecessors.contains(rblock)) {
                    rblock.predecessors.remove(rblock);
                }
                if (rblock.successors.contains(rblock)) {
                    rblock.successors.remove(rblock);
                }
                if (rblock.predecessors.size() != 1) continue;
                deleteQueue.add(rblock);
                RBlock predecessor = rblock.predecessors.get(0);
                predecessor.successors.remove(rblock);
                for (int i3 = 0; i3 < rblock.successors.size(); ++i3) {
                    RBlock successor = rblock.successors.get(i3);
                    assert (successor.predecessors.contains(rblock));
                    successor.predecessors.remove(rblock);
                    if (!successor.predecessors.contains(predecessor)) {
                        successor.predecessors.add(predecessor);
                    }
                    if (predecessor.successors.contains(successor)) continue;
                    predecessor.successors.add(successor);
                }
            }
            if (deleteQueue.size() == 0) break;
            Iterator iterator2 = deleteQueue.iterator();
            while (true) {
                RBlock rblock;
                if (!iterator2.hasNext()) continue block5;
                rblock = (RBlock)iterator2.next();
                queue.remove(rblock);
            }
            break;
        }
        return queue.size() == 1;
    }

    private static boolean CompareBitSets(BitSet b1, BitSet b2) {
        assert (b1 != b2 && b1.size() == b2.size());
        for (int i = 0; i < b1.size(); ++i) {
            if (b1.get(i) == b2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static void ComputeDominators(LBlock[] blocks) {
        LBlock block;
        int i;
        boolean changed;
        int i2;
        BitSet[] doms = new BitSet[blocks.length];
        for (i2 = 0; i2 < doms.length; ++i2) {
            doms[i2] = new BitSet(doms.length);
        }
        doms[0].set(0, true);
        for (i2 = 1; i2 < blocks.length; ++i2) {
            for (int j = 0; j < blocks.length; ++j) {
                doms[i2].set(0, doms.length + 1);
            }
        }
        do {
            changed = false;
            for (i = 1; i < blocks.length; ++i) {
                block = blocks[i];
                for (int j = 0; j < block.numPredecessors(); ++j) {
                    LBlock pred = block.getPredecessor(j);
                    BitSet u = (BitSet)doms[i].clone();
                    doms[block.id()].and(doms[pred.id()]);
                    doms[block.id()].set(block.id(), true);
                    if (BlockAnalysis.CompareBitSets(doms[block.id()], u)) continue;
                    changed = true;
                }
            }
        } while (changed);
        for (i = 0; i < blocks.length; ++i) {
            block = blocks[i];
            LinkedList<LBlock> list = new LinkedList<LBlock>();
            for (int j = 0; j < blocks.length; ++j) {
                if (!doms[block.id()].get(j)) continue;
                list.add(blocks[j]);
            }
            LBlock[] tempBlocks = list.size() == 0 ? new LBlock[]{} : list.toArray(new LBlock[1]);
            block.setDominators(tempBlocks);
        }
    }

    private static boolean StrictlyDominatesADominator(LBlock from, LBlock dom) {
        for (int i = 0; i < from.dominators().length; ++i) {
            LBlock other = from.dominators()[i];
            if (other == from || other == dom) continue;
            for (int x = 0; x < other.dominators().length; ++x) {
                if (other.dominators()[x] != dom) continue;
                return true;
            }
        }
        return false;
    }

    private static void ComputeImmediateDominator(LBlock block) {
        for (int i = 0; i < block.dominators().length; ++i) {
            LBlock dom = block.dominators()[i];
            if (dom == block || BlockAnalysis.StrictlyDominatesADominator(block, dom)) continue;
            block.setImmediateDominator(dom);
            return;
        }
        assert (false);
    }

    public static void ComputeImmediateDominators(LBlock[] blocks) {
        blocks[0].setImmediateDominator(blocks[0]);
        for (int i = 1; i < blocks.length; ++i) {
            BlockAnalysis.ComputeImmediateDominator(blocks[i]);
        }
    }

    public static void ComputeDominatorTree(LBlock[] blocks) {
        int i;
        class LinkedListLBlock
        extends LinkedList<LBlock> {
            LinkedListLBlock() {
            }
        }
        LinkedListLBlock[] idominated = new LinkedListLBlock[blocks.length];
        for (i = 0; i < blocks.length; ++i) {
            idominated[i] = new LinkedListLBlock();
        }
        for (i = 1; i < blocks.length; ++i) {
            LBlock block = blocks[i];
            idominated[block.idom().id()].add(block);
        }
        for (i = 0; i < blocks.length; ++i) {
            blocks[i].setImmediateDominated(idominated[i].toArray(new LBlock[0]));
        }
    }

    public static LBlock FollowGoto(LBlock block) {
        if (block.instructions().length > 1) {
            return block;
        }
        LControlInstruction last = block.last();
        if (last.op() != Opcode.Goto) {
            return block;
        }
        LGoto go = (LGoto)last;
        return BlockAnalysis.FollowGoto(go.target());
    }

    private static LBlock FindSkippingParent(LBlock[] blocks, int unbalanced_id, LBlock block) {
        LBlock idomBlock = blocks[block.idom().id()];
        LControlInstruction lastIns = idomBlock.last();
        if (lastIns.op() == Opcode.JumpCondition) {
            LBlock target;
            LJumpCondition jcc = (LJumpCondition)lastIns;
            if (jcc.trueTarget() == block) {
                target = jcc.falseTarget();
            } else if (jcc.falseTarget() == block) {
                target = jcc.trueTarget();
            } else {
                return BlockAnalysis.FindSkippingParent(blocks, unbalanced_id, idomBlock);
            }
            if (target.id() > unbalanced_id) {
                return target;
            }
            return BlockAnalysis.FindSkippingParent(blocks, unbalanced_id, idomBlock);
        }
        return null;
    }

    public static LBlock EnforceStackBalance(PawnFile file, LBlock[] blocks) {
        StackBalanceValidator validator = new StackBalanceValidator(file, blocks);
        LBlock unbalanced = validator.FindUnbalancedBlock(blocks[0]);
        if (unbalanced == null) {
            return null;
        }
        LBlock idomBlock = blocks[unbalanced.idom().id()];
        LControlInstruction lastIns = idomBlock.last();
        assert (lastIns.op() == Opcode.JumpCondition);
        return BlockAnalysis.FindSkippingParent(blocks, unbalanced.id(), unbalanced);
    }

    private static LBlock SkipContainedLoop(LBlock block, LBlock header) {
        while (block.loop() != null && block.loop() == block) {
            if (block.loop() != null) {
                block = block.loop();
            }
            if (block == header) break;
            block = block.getLoopPredecessor();
        }
        return block;
    }

    private static void MarkLoop(LBlock backedge) {
        LoopBodyWorklist worklist = new LoopBodyWorklist(backedge);
        worklist.scan(backedge);
        while (!worklist.empty()) {
            LBlock block = worklist.pop();
            worklist.scan(block);
            block.setInLoop(backedge.loop());
        }
    }

    public static void FindLoops(LBlock[] blocks) {
        LBlock block;
        int i;
        block0: for (i = 1; i < blocks.length; ++i) {
            block = blocks[i];
            for (int j = 0; j < block.numSuccessors(); ++j) {
                LBlock successor = block.getSuccessor(j);
                if (successor.id() >= block.id()) continue;
                successor.setLoopHeader(block);
                block.setInLoop(successor);
                continue block0;
            }
        }
        for (i = 0; i < blocks.length; ++i) {
            block = blocks[i];
            if (block.backedge() == null) continue;
            BlockAnalysis.MarkLoop(block.backedge());
        }
    }

    public static NodeBlock GetSingleTarget(NodeBlock block) {
        if (block.nodes().last().type() != NodeType.Jump) {
            return null;
        }
        DJump jump = (DJump)block.nodes().last();
        return jump.target();
    }

    public static NodeBlock GetEmptyTarget(NodeBlock block) {
        if (block.nodes().last() != block.nodes().first()) {
            return null;
        }
        return BlockAnalysis.GetSingleTarget(block);
    }

    public static NodeBlock EffectiveTargetNoLoop(NodeBlock block) {
        if (block == null) {
            return null;
        }
        NodeBlock target = block;
        HashSet<NodeBlock> recursionCheck = new HashSet<NodeBlock>();
        recursionCheck.add(block);
        while ((block = BlockAnalysis.GetEmptyTarget(block)) != null) {
            if (recursionCheck.contains(block)) {
                return null;
            }
            recursionCheck.add(block);
            target = block;
        }
        return target;
    }

    public static NodeBlock EffectiveTarget(NodeBlock block) {
        NodeBlock target = block;
        while ((block = BlockAnalysis.GetEmptyTarget(block)) != null) {
            target = block;
        }
        return target;
    }

    public static NodeBlock ConstantSettingTarget(NodeBlock block) {
        NodeBlock target = block;
        while (target.lir().instructions().length != 2 || target.lir().instructions()[0].op() != Opcode.Constant || target.lir().instructions()[1].op() != Opcode.Jump && target.lir().instructions()[1].op() != Opcode.Goto) {
            if ((block = BlockAnalysis.GetEmptyTarget(block)) == null) {
                return null;
            }
            target = block;
        }
        return target;
    }

    private static class LoopBodyWorklist {
        private Stack<LBlock> stack_ = new Stack();
        private LBlock backedge_;

        public LoopBodyWorklist(LBlock backedge) {
            this.backedge_ = backedge;
        }

        public void scan(LBlock block) {
            for (int i = 0; i < block.numPredecessors(); ++i) {
                LBlock pred = block.getPredecessor(i);
                if (pred.loop() == this.backedge_.loop()) continue;
                pred = BlockAnalysis.SkipContainedLoop(pred, this.backedge_.loop());
                assert (pred.loop() == null || pred.loop() == this.backedge_.loop());
                if (pred.loop() != null) continue;
                this.stack_.push(pred);
            }
        }

        public boolean empty() {
            return this.stack_.size() == 0;
        }

        public LBlock pop() {
            return this.stack_.pop();
        }
    }

    private static class StackBalanceValidator {
        private int[] stack_levels_;
        private PawnFile file_;

        public StackBalanceValidator(PawnFile file, LBlock[] blocks) {
            this.stack_levels_ = new int[blocks.length];
            this.file_ = file;
        }

        /*
         * Enabled aggressive block sorting
         */
        public LBlock FindUnbalancedBlock(LBlock block) {
            for (int i = 0; i < block.numPredecessors(); ++i) {
                LInstruction[] pred = block.getPredecessor(i);
                if (pred.id() >= block.id() || this.stack_levels_[block.id()] != 0) continue;
                this.stack_levels_[block.id()] = this.stack_levels_[pred.id()];
            }
            Long lastConstant = null;
            block12: for (LInstruction ins : block.instructions()) {
                switch (ins.op()) {
                    case Stack: {
                        LStack stk = (LStack)ins;
                        if (stk.amount() < 0L) {
                            int n = block.id();
                            this.stack_levels_[n] = (int)((long)this.stack_levels_[n] + stk.amount() / -4L);
                            break;
                        }
                        int n = block.id();
                        this.stack_levels_[n] = (int)((long)this.stack_levels_[n] - stk.amount() / 4L);
                        break;
                    }
                    case PushConstant: {
                        LPushConstant pushc = (LPushConstant)ins;
                        lastConstant = pushc.val();
                        int n = block.id();
                        this.stack_levels_[n] = this.stack_levels_[n] + 1;
                        continue block12;
                    }
                    case PushGlobal: 
                    case PushLocal: 
                    case PushReg: 
                    case PushStackAddress: {
                        int n = block.id();
                        this.stack_levels_[n] = this.stack_levels_[n] + 1;
                        break;
                    }
                    case AddConstant: {
                        LAddConstant addc = (LAddConstant)ins;
                        lastConstant = addc.amount();
                        continue block12;
                    }
                    case StoreCtrl: {
                        assert (lastConstant != null);
                        LStoreCtrl sctrl = (LStoreCtrl)ins;
                        assert (sctrl.ctrlregindex() == 4);
                        this.stack_levels_[block.id()] = (int)(lastConstant / -4L);
                        break;
                    }
                    case StackAdjust: {
                        LStackAdjust stkadj = (LStackAdjust)ins;
                        this.stack_levels_[block.id()] = stkadj.value() / -4;
                        break;
                    }
                    case Call: 
                    case SysReq: {
                        assert (lastConstant != null);
                        if (this.file_.PassArgCountAsSize()) {
                            lastConstant = lastConstant / 4L;
                        }
                        int n = block.id();
                        this.stack_levels_[n] = (int)((long)this.stack_levels_[n] - lastConstant);
                        int n2 = block.id();
                        this.stack_levels_[n2] = this.stack_levels_[n2] - 1;
                        break;
                    }
                    case GenArray: {
                        LGenArray genarray = (LGenArray)ins;
                        int n = block.id();
                        this.stack_levels_[n] = this.stack_levels_[n] - genarray.dims();
                        int n3 = block.id();
                        this.stack_levels_[n3] = this.stack_levels_[n3] + 1;
                        break;
                    }
                    case Pop: {
                        int n = block.id();
                        this.stack_levels_[n] = this.stack_levels_[n] - 1;
                    }
                }
                lastConstant = null;
                if (this.stack_levels_[block.id()] >= 0) continue;
                return block;
            }
            int i = 0;
            while (i < block.idominated().length) {
                LBlock unbalanced;
                LBlock lir = block.idominated()[i];
                if (lir != null && (unbalanced = this.FindUnbalancedBlock(lir)) != null) {
                    return unbalanced;
                }
                ++i;
            }
            return null;
        }
    }

    private static class RBlock {
        public LinkedList<RBlock> predecessors = new LinkedList();
        public LinkedList<RBlock> successors = new LinkedList();
    }
}

