/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes;

import lysis.lstructure.Scope;
import lysis.lstructure.Signature;
import lysis.lstructure.Variable;
import lysis.lstructure.VariableType;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeGraph;
import lysis.nodes.NodeList;
import lysis.nodes.NodeType;
import lysis.nodes.types.DArrayRef;
import lysis.nodes.types.DBinary;
import lysis.nodes.types.DCall;
import lysis.nodes.types.DConstant;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DGenArray;
import lysis.nodes.types.DGlobal;
import lysis.nodes.types.DHeap;
import lysis.nodes.types.DInlineArray;
import lysis.nodes.types.DLoad;
import lysis.nodes.types.DMemCopy;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DStore;
import lysis.nodes.types.DSysReq;
import lysis.nodes.types.DUse;
import lysis.sourcepawn.SPOpcode;
import lysis.types.TypeSet;
import lysis.types.TypeUnit;

public class NodeAnalysis {
    public static void RemoveGuards(NodeGraph graph) throws Exception {
        for (int i = graph.numBlocks() - 1; i >= 0; --i) {
            NodeBlock block = graph.blocks(i);
            NodeList.reverse_iterator iter = block.nodes().rbegin();
            while (iter.more()) {
                if (iter.node().guard()) {
                    assert (iter.node().idempotent());
                    iter.node().removeFromUseChains();
                    block.nodes().remove(iter);
                    continue;
                }
                iter.next();
            }
        }
    }

    private static void RemoveDeadCodeInBlock(NodeBlock block) throws Exception {
        NodeList.reverse_iterator iter = block.nodes().rbegin();
        while (iter.more()) {
            DDeclareLocal decl;
            if (iter.node().type() == NodeType.DeclareLocal && (decl = (DDeclareLocal)iter.node()).var() == null && (decl.uses().size() == 0 || decl.uses().size() == 1 && decl.value() != null)) {
                if (decl.uses().size() == 1) {
                    DUse use = decl.uses().getFirst();
                    if (decl.value() != null && (decl.value().type() == NodeType.Constant || decl.value().type() == NodeType.LocalRef && decl.value().getOperand(0) != null && decl.value().getOperand(0).getOperand(0) != null && decl.value().getOperand(0).getOperand(0).type() == NodeType.Constant)) {
                        iter.next();
                        continue;
                    }
                    use.node().replaceOperand(use.index(), decl.value());
                }
                iter.node().removeFromUseChains();
                block.nodes().remove(iter);
                continue;
            }
            if (iter.node().type() == NodeType.Store && iter.node().getOperand(0).type() == NodeType.Heap && iter.node().getOperand(0).uses().size() == 1) {
                iter.node().removeFromUseChains();
                block.nodes().remove(iter);
            }
            if (!iter.node().idempotent() || iter.node().guard() || iter.node().uses().size() > 0) {
                iter.next();
                continue;
            }
            iter.node().removeFromUseChains();
            block.nodes().remove(iter);
        }
    }

    public static void RemoveDeadCode(NodeGraph graph) throws Exception {
        for (int i = graph.numBlocks() - 1; i >= 0; --i) {
            NodeAnalysis.RemoveDeadCodeInBlock(graph.blocks(i));
        }
    }

    private static boolean IsArray(TypeSet ts) {
        if (ts == null) {
            return false;
        }
        if (ts.numTypes() != 1) {
            return false;
        }
        TypeUnit tu = ts.types(0);
        if (tu.kind() == TypeUnit.Kind.Array) {
            return true;
        }
        return tu.kind() == TypeUnit.Kind.Reference && tu.inner().kind() == TypeUnit.Kind.Array && tu.inner().type() != null;
    }

    private static DNode GuessArrayBase(DNode op1, DNode op2) {
        DLoad load;
        if (op1.usedAsArrayIndex()) {
            return op2;
        }
        if (op2.usedAsArrayIndex()) {
            return op1;
        }
        if (op1.type() == NodeType.ArrayRef || op1.type() == NodeType.LocalRef || NodeAnalysis.IsArray(op1.typeSet())) {
            return op1;
        }
        if (op2.type() == NodeType.ArrayRef || op2.type() == NodeType.LocalRef || NodeAnalysis.IsArray(op2.typeSet())) {
            return op2;
        }
        if (op1.type() == NodeType.Load && (load = (DLoad)op1).from().type() == NodeType.ArrayRef) {
            return op1;
        }
        if (op2.type() == NodeType.Load && (load = (DLoad)op2).from().type() == NodeType.ArrayRef) {
            return op2;
        }
        return null;
    }

    private static boolean IsReallyLikelyArrayCompute(DNode node, DNode abase) {
        DLoad load;
        if (abase.type() == NodeType.ArrayRef) {
            return true;
        }
        if (abase.type() == NodeType.Load && (load = (DLoad)abase).from().type() == NodeType.ArrayRef) {
            return true;
        }
        if (NodeAnalysis.IsArray(abase.typeSet())) {
            return true;
        }
        for (DUse use : node.uses()) {
            if (use.node().type() != NodeType.Store && use.node().type() != NodeType.Load) continue;
            return true;
        }
        return false;
    }

    private static boolean ShouldOperantsBeSwitched(DNode abase, DNode index, DBinary binary) throws Exception {
        if (abase.type() != NodeType.Load || index.type() != NodeType.Load) {
            return false;
        }
        return abase.getOperand(0) == index && index.getOperand(0).type() == NodeType.DeclareLocal;
    }

    private static boolean CollapseArrayReferences(NodeBlock block) throws Exception {
        boolean changed = false;
        NodeList.reverse_iterator iter = block.nodes().rbegin();
        while (iter.more()) {
            DBinary binary;
            DNode node = iter.node();
            if ((node.type() == NodeType.Store || node.type() == NodeType.Load) && node.getOperand(0).type() != NodeType.ArrayRef && NodeAnalysis.IsArray(node.getOperand(0).typeSet())) {
                DConstant index0 = new DConstant(0L);
                DArrayRef aref0 = new DArrayRef(node.getOperand(0), index0, 0L);
                block.nodes().insertBefore(node, index0);
                block.nodes().insertBefore(node, aref0);
                node.replaceOperand(0, aref0);
                changed = true;
            } else if (node.type() == NodeType.Binary && (binary = (DBinary)node).spop() == SPOpcode.add) {
                DNode abase;
                if (binary.lhs().type() == NodeType.LocalRef) {
                    // empty if block
                }
                if ((abase = NodeAnalysis.GuessArrayBase(binary.lhs(), binary.rhs())) != null) {
                    DStore store;
                    DLoad load;
                    DNode index;
                    DNode dNode = index = abase == binary.lhs() ? binary.rhs() : binary.lhs();
                    if (NodeAnalysis.ShouldOperantsBeSwitched(abase, index, binary)) {
                        abase = binary.rhs();
                        index = binary.lhs();
                    }
                    if (NodeAnalysis.IsReallyLikelyArrayCompute(binary, abase) && (abase.type() != NodeType.Load || (load = (DLoad)abase).from().type() != NodeType.ArrayRef || binary.uses().size() != 1 || index.type() != NodeType.Constant || binary.uses().get(0).node().type() != NodeType.Store || (store = (DStore)binary.uses().get(0).node()).rhs() != binary)) {
                        DLoad load2;
                        int num_dims = 1;
                        DNode check = abase;
                        while (check.type() == NodeType.Load && (load2 = (DLoad)check).from().type() == NodeType.ArrayRef) {
                            ++num_dims;
                            DArrayRef ref = (DArrayRef)load2.from();
                            check = ref.lhs();
                        }
                        if (!NodeAnalysis.HasEnoughArrayDimensions(check, num_dims)) {
                            if (index.type() == NodeType.Load && index.getOperand(0) == abase) {
                                node.replaceAllUsesWith(index);
                                node.removeFromUseChains();
                                block.nodes().remove(iter);
                                changed = true;
                            } else {
                                if (index.type() == NodeType.Constant) {
                                    index.setUsedAsArrayIndex();
                                }
                                DArrayRef aref = new DArrayRef(abase, index);
                                iter.node().replaceAllUsesWith(aref);
                                iter.node().removeFromUseChains();
                                block.nodes().remove(iter);
                                block.nodes().insertBefore(iter.node(), aref);
                                changed = true;
                            }
                        }
                    }
                }
            }
            iter.next();
        }
        return changed;
    }

    public static void CollapseArrayReferences(NodeGraph graph) throws Exception {
        boolean changed;
        do {
            changed = false;
            for (int i = graph.numBlocks() - 1; i >= 0; --i) {
                changed |= NodeAnalysis.CollapseArrayReferences(graph.blocks(i));
            }
        } while (changed);
    }

    public static boolean HasEnoughArrayDimensions(DNode check, int num_dims) throws Exception {
        switch (check.type()) {
            case Load: {
                return NodeAnalysis.HasEnoughArrayDimensions(((DLoad)check).from(), num_dims);
            }
            case DeclareLocal: {
                DDeclareLocal local = (DDeclareLocal)check;
                if (local.var() == null || local.var().dims() == null || local.var().dims().length >= num_dims) break;
                return true;
            }
            case Global: {
                DGlobal global = (DGlobal)check;
                if (global.var() == null || global.var().dims() == null || global.var().dims().length >= num_dims) break;
                return true;
            }
            case GenArray: {
                DGenArray genarray = (DGenArray)check;
                if (genarray.var() == null || genarray.var().dims() == null || genarray.var().dims().length >= num_dims) break;
                return true;
            }
            case Constant: {
                if (check.uses().size() != 1 || check.uses().get(0).node().type() != NodeType.Binary) break;
                return NodeAnalysis.HasEnoughArrayDimensions(check.uses().get(0).node().getOperand(0), num_dims);
            }
        }
        return false;
    }

    public static void CoalesceLoadsAndDeclarations(NodeGraph graph) throws Exception {
        for (int i = 0; i < graph.numBlocks(); ++i) {
            NodeBlock block = graph.blocks(i);
            NodeList.iterator iter = block.nodes().begin();
            while (iter.more()) {
                DNode node = iter.node();
                if (node.type() == NodeType.DeclareLocal) {
                    DStore store;
                    DDeclareLocal local = (DDeclareLocal)node;
                    if (node.next().type() == NodeType.Store && (store = (DStore)node.next()).getOperand(0) == local && store.getOperand(1).type() != NodeType.Unary) {
                        DNode replacement = store.spop() != SPOpcode.nop ? new DBinary(store.spop(), local.getOperand(0), store.getOperand(1)) : store.getOperand(1);
                        local.replaceOperand(0, replacement);
                        store.removeFromUseChains();
                        iter.next();
                        block.nodes().remove(iter);
                        continue;
                    }
                }
                iter.next();
            }
        }
    }

    private static void CoalesceLoadStores(NodeBlock block) throws Exception {
        NodeList.reverse_iterator riter = block.nodes().rbegin();
        while (riter.more()) {
            if (riter.node().type() == NodeType.Store) {
                DStore store = (DStore)riter.node();
                DNode coalesce = null;
                if (store.rhs().type() == NodeType.Binary) {
                    DBinary rhs = (DBinary)store.rhs();
                    if (rhs.lhs().type() == NodeType.Load) {
                        DLoad load = (DLoad)rhs.lhs();
                        if (load.from() == store.lhs()) {
                            coalesce = rhs.rhs();
                        } else if (load.from().type() == NodeType.ArrayRef && store.lhs().type() == NodeType.Load) {
                            DArrayRef aref = (DArrayRef)load.from();
                            load = (DLoad)store.lhs();
                            if (aref.abase() == load && aref.index().type() == NodeType.Constant && ((DConstant)aref.index()).value() == 0L) {
                                coalesce = rhs.rhs();
                                store.replaceOperand(0, aref);
                            }
                        }
                    }
                    if (coalesce != null) {
                        store.makeStoreOp(rhs.spop());
                    }
                } else if (store.rhs().type() == NodeType.Load && store.rhs().getOperand(0) == store.lhs() && store.prev().type() == NodeType.IncDec && store.prev().getOperand(0) == store.rhs()) {
                    store.removeFromUseChains();
                    block.nodes().remove(riter);
                    assert (riter.node().type() == NodeType.IncDec);
                    riter.node().replaceOperand(0, riter.node().getOperand(0).getOperand(0));
                }
                if (coalesce != null) {
                    store.replaceOperand(1, coalesce);
                }
            }
            riter.next();
        }
    }

    public static void CoalesceLoadStores(NodeGraph graph) throws Exception {
        for (int i = 0; i < graph.numBlocks(); ++i) {
            NodeAnalysis.CoalesceLoadStores(graph.blocks(i));
        }
    }

    private static Signature SignatureOf(DNode node) {
        if (node.type() == NodeType.Call) {
            return ((DCall)node).function();
        }
        return ((DSysReq)node).nativeX();
    }

    public static void HandleMemCopys(NodeGraph graph) throws Exception {
        for (int i = 0; i < graph.numBlocks(); ++i) {
            NodeBlock block = graph.blocks(i);
            NodeList.iterator iter = block.nodes().begin();
            while (iter.more()) {
                DNode node = iter.node();
                if (node.type() == NodeType.MemCopy) {
                    DStore store;
                    DDeclareLocal local;
                    DMemCopy mcpy = (DMemCopy)node;
                    if (mcpy.from().type() == NodeType.Load && mcpy.to().type() == NodeType.DeclareLocal) {
                        DLoad load = (DLoad)mcpy.from();
                        local = (DDeclareLocal)mcpy.to();
                        if (local.var() != null && local.var().type() == VariableType.Array) {
                            store = new DStore(local, load);
                            block.nodes().insertAfter(node, store);
                        }
                    } else if (mcpy.from().type() == NodeType.ArrayRef && mcpy.to().type() == NodeType.Load) {
                        DArrayRef arrayref = (DArrayRef)mcpy.from();
                        DLoad load = (DLoad)mcpy.to();
                        store = new DStore(load, arrayref);
                        block.nodes().insertAfter(node, store);
                    } else if (mcpy.from().type() == NodeType.DeclareLocal && mcpy.to().type() == NodeType.ArrayRef) {
                        DDeclareLocal local2 = (DDeclareLocal)mcpy.from();
                        DArrayRef arrayref = (DArrayRef)mcpy.to();
                        store = new DStore(local2, arrayref);
                        block.nodes().insertAfter(node, store);
                    } else if (mcpy.from().type() == NodeType.DeclareLocal && mcpy.to().type() == NodeType.DeclareLocal) {
                        DDeclareLocal local_from = (DDeclareLocal)mcpy.from();
                        DDeclareLocal local_to = (DDeclareLocal)mcpy.to();
                        if (local_from.var() != null && local_from.var().type() == VariableType.Array && local_to.var() != null && local_to.var().type() == VariableType.Array) {
                            store = new DStore(local_to, local_from);
                            block.nodes().insertAfter(node, store);
                        }
                    } else if (mcpy.from().type() == NodeType.Constant && mcpy.to().type() == NodeType.Constant) {
                        DConstant con_from = (DConstant)mcpy.from();
                        DConstant con_to = (DConstant)mcpy.to();
                        if (con_from.value() > 0L && con_to.value() > 0L) {
                            Variable global_to;
                            Variable global_from = graph.file().lookupGlobal(con_from.value());
                            if (global_from == null) {
                                global_from = graph.file().lookupVariable(con_from.pc(), con_from.value(), Scope.Static);
                            }
                            if ((global_to = graph.file().lookupGlobal(con_to.value())) == null) {
                                global_to = graph.file().lookupVariable(con_to.pc(), con_to.value(), Scope.Static);
                            }
                            if (global_from != null && global_to != null) {
                                DGlobal dglobal_from = new DGlobal(global_from);
                                DLoad load_from = new DLoad(dglobal_from);
                                DDeclareLocal declare_from = new DDeclareLocal(con_from.pc(), load_from);
                                block.nodes().insertAfter(node, dglobal_from);
                                block.nodes().insertAfter(dglobal_from, load_from);
                                block.nodes().insertAfter(load_from, declare_from);
                                DGlobal dglobal_to = new DGlobal(global_to);
                                DLoad load_to = new DLoad(dglobal_to);
                                DDeclareLocal declare_to = new DDeclareLocal(con_to.pc(), load_to);
                                block.nodes().insertAfter(declare_from, dglobal_to);
                                block.nodes().insertAfter(dglobal_to, load_to);
                                block.nodes().insertAfter(load_to, declare_to);
                                DStore store2 = new DStore(declare_to, declare_from);
                                block.nodes().insertAfter(declare_to, store2);
                            }
                        }
                    } else if (mcpy.from().type() == NodeType.Constant && mcpy.to().type() == NodeType.DeclareLocal || mcpy.from().type() == NodeType.DeclareLocal && mcpy.to().type() == NodeType.Constant) {
                        DConstant con = null;
                        local = null;
                        if (mcpy.from().type() == NodeType.Constant) {
                            con = (DConstant)mcpy.from();
                            local = (DDeclareLocal)mcpy.to();
                        } else {
                            con = (DConstant)mcpy.to();
                            local = (DDeclareLocal)mcpy.from();
                        }
                        if (con.value() > 0L && local.var() != null && local.var().type() == VariableType.Array) {
                            Variable global = graph.file().lookupGlobal(con.value());
                            if (global == null) {
                                global = graph.file().lookupVariable(con.pc(), con.value(), Scope.Static);
                            }
                            if (global == null) {
                                DInlineArray ia = new DInlineArray(con.value(), mcpy.bytes());
                                block.nodes().insertAfter(node, ia);
                                TypeUnit tu = TypeUnit.FromVariable(local.var());
                                ia.addType(tu);
                                if (local.block().lir().id() == con.block().lir().id()) {
                                    local.replaceOperand(0, ia);
                                } else {
                                    DStore store3 = new DStore(local, ia);
                                    block.nodes().insertAfter(ia, store3);
                                }
                            } else {
                                DStore store4;
                                DGlobal dglobal = new DGlobal(global);
                                DLoad load = new DLoad(dglobal);
                                DDeclareLocal declare = new DDeclareLocal(con.pc(), load);
                                block.nodes().insertAfter(node, dglobal);
                                block.nodes().insertAfter(dglobal, load);
                                block.nodes().insertAfter(load, declare);
                                if (mcpy.from().type() == NodeType.Constant) {
                                    store4 = new DStore(local, declare);
                                    block.nodes().insertAfter(declare, store4);
                                } else {
                                    store4 = new DStore(declare, local);
                                    block.nodes().insertAfter(declare, store4);
                                }
                            }
                        }
                    }
                }
                iter.next();
            }
        }
    }

    private static boolean AnalyzeHeapNode(NodeBlock block, DHeap node) throws Exception {
        DUse use;
        if (node.uses().size() == 2) {
            DUse lastUse = node.uses().getLast();
            DUse firstUse = node.uses().getFirst();
            if ((lastUse.node().type() == NodeType.Call || lastUse.node().type() == NodeType.SysReq) && firstUse.node().type() == NodeType.Store && firstUse.index() == 0) {
                lastUse.node().replaceOperand(lastUse.index(), firstUse.node().getOperand(1));
                return true;
            }
            if ((lastUse.node().type() == NodeType.Call || lastUse.node().type() == NodeType.SysReq) && firstUse.node().type() == NodeType.MemCopy && firstUse.index() == 0) {
                DMemCopy memcopy = (DMemCopy)firstUse.node();
                DConstant cv = (DConstant)memcopy.from();
                DInlineArray ia = new DInlineArray(cv.value(), memcopy.bytes());
                block.nodes().insertAfter(node, ia);
                lastUse.node().replaceOperand(lastUse.index(), ia);
                Signature signature = NodeAnalysis.SignatureOf(lastUse.node());
                if (signature.args() != null) {
                    TypeUnit tu = TypeUnit.FromArgument(signature.args()[lastUse.index()]);
                    ia.addType(tu);
                }
                return true;
            }
            if (lastUse.node().type() == NodeType.Store && firstUse.node().type() == NodeType.Phi && firstUse.node().numOperands() == 2 && node.next().type() == NodeType.Call) {
                lastUse.node().replaceOperand(lastUse.index(), node.next());
                return true;
            }
        } else if (node.uses().size() == 1 && ((use = node.uses().getLast()).node().type() == NodeType.SysReq || use.node().type() == NodeType.Call)) {
            DCall call;
            DNode next;
            for (next = node; next != use.node() && ((DNode)next).type() != NodeType.Call; next = next.next()) {
            }
            if (((DNode)next).type() == NodeType.Call && (call = (DCall)next).function().isStringReturn()) {
                use.node().replaceOperand(use.index(), call);
                return true;
            }
        }
        return false;
    }

    private static void AnalyzeHeapUsage(NodeBlock block) throws Exception {
        NodeList.reverse_iterator riter = block.nodes().rbegin();
        while (riter.more()) {
            if (riter.node().type() == NodeType.Heap && NodeAnalysis.AnalyzeHeapNode(block, (DHeap)riter.node())) {
                block.nodes().remove(riter);
            }
            riter.next();
        }
    }

    public static void AnalyzeHeapUsage(NodeGraph graph) throws Exception {
        for (int i = 0; i < graph.numBlocks(); ++i) {
            NodeAnalysis.AnalyzeHeapUsage(graph.blocks(i));
        }
    }

    public static String PrintRecursively(DNode node, DNode start) {
        String ret = node.type().toString() + "#" + node.hashCode() + " (uses: " + node.uses().size() + ")\n";
        switch (node.type()) {
            case Binary: {
                DBinary binary = (DBinary)node;
                DNode abase = NodeAnalysis.GuessArrayBase(binary.lhs(), binary.rhs());
                ret = ret + "\tbase: " + (abase == null ? "null" : abase.type().toString() + "#" + abase.hashCode() + " (uses: " + abase.uses().size() + ")") + "\n";
                ret = ret + "\tislikelyarray: " + (abase == null ? "false" : Boolean.valueOf(NodeAnalysis.IsReallyLikelyArrayCompute(binary, abase))) + "\n";
                ret = ret + "\tlhs: " + binary.lhs().type().toString() + "#" + binary.lhs().hashCode() + " (uses: " + binary.lhs().uses().size() + ")\n";
                ret = ret + "\top: " + binary.spop().toString() + "\n";
                ret = ret + "\trhs: " + binary.rhs().type().toString() + "#" + binary.rhs().hashCode() + " (uses: " + binary.rhs().uses().size() + ")\n";
                break;
            }
            case Constant: {
                DConstant constant = (DConstant)node;
                ret = ret + "\tval: " + constant.value() + "\n";
                break;
            }
            case Load: {
                DLoad load = (DLoad)node;
                ret = ret + "\tfrom: " + load.from().type().toString() + "#" + load.from().hashCode() + " (uses: " + load.from().uses().size() + ")\n";
                break;
            }
            case Store: {
                DStore store = (DStore)node;
                ret = ret + "\tlhs: " + store.lhs().type().toString() + "#" + store.lhs().hashCode() + " (uses: " + store.lhs().uses().size() + ")\n";
                ret = ret + "\top: " + store.spop().toString() + "\n";
                ret = ret + "\trhs: " + store.rhs().type().toString() + "#" + store.rhs().hashCode() + " (uses: " + store.rhs().uses().size() + ")\n";
                break;
            }
            case ArrayRef: {
                DArrayRef arrayref = (DArrayRef)node;
                ret = ret + "\tlhs: " + arrayref.lhs().type().toString() + "#" + arrayref.lhs().hashCode() + " (uses: " + arrayref.lhs().uses().size() + ")\n";
                ret = ret + "\trhs: " + arrayref.rhs().type().toString() + "#" + arrayref.rhs().hashCode() + " (uses: " + arrayref.rhs().uses().size() + ")\n";
                break;
            }
            case DeclareLocal: {
                DDeclareLocal local = (DDeclareLocal)node;
                ret = ret + "\tvar: " + (local.var() != null ? local.var().name() : "") + "\n";
                ret = ret + "\tvalue: " + (local.value() != null ? local.value().type().toString() + "#" + local.value().hashCode() + " (uses: " + local.value().uses().size() + ")" : "") + "\n";
                break;
            }
        }
        ret = ret + "\n";
        if (node.prev() != start) {
            return ret + NodeAnalysis.PrintRecursively(node.prev(), start);
        }
        return ret;
    }
}

