/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes;

import lysis.nodes.NodeBlock;
import lysis.nodes.NodeGraph;
import lysis.nodes.NodeList;
import lysis.nodes.NodeType;
import lysis.nodes.NodeVisitor;
import lysis.nodes.types.DArrayRef;
import lysis.nodes.types.DBinary;
import lysis.nodes.types.DBoundsCheck;
import lysis.nodes.types.DCall;
import lysis.nodes.types.DConstant;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DFloat;
import lysis.nodes.types.DGlobal;
import lysis.nodes.types.DJump;
import lysis.nodes.types.DJumpCondition;
import lysis.nodes.types.DLoad;
import lysis.nodes.types.DLocalRef;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DPhi;
import lysis.nodes.types.DReturn;
import lysis.nodes.types.DStore;
import lysis.nodes.types.DString;
import lysis.nodes.types.DSysReq;
import lysis.nodes.types.DTempName;
import lysis.nodes.types.DUnary;
import lysis.sourcepawn.SPOpcode;
import lysis.types.CellType;
import lysis.types.PawnType;
import lysis.types.TypeUnit;

public class NodeRewriter
extends NodeVisitor {
    private NodeGraph graph_;
    private NodeBlock current_;
    private NodeList.iterator iterator_;

    @Override
    public void visit(DConstant node) {
    }

    @Override
    public void visit(DDeclareLocal local) {
    }

    @Override
    public void visit(DLocalRef lref) {
    }

    @Override
    public void visit(DJump jump) {
    }

    @Override
    public void visit(DJumpCondition jcc) {
    }

    @Override
    public void visit(DSysReq sysreq) throws Exception {
        DNode rhs;
        DNode lhs;
        SPOpcode spop;
        if (sysreq.numOperands() == 1 && sysreq.nativeX().name().equals("__FLOAT_NOT__")) {
            sysreq.getOperand(0).addType(new TypeUnit(new PawnType(CellType.Float)));
            DUnary unary = new DUnary(SPOpcode.not, sysreq.getOperand(0));
            sysreq.replaceAllUsesWith(unary);
            sysreq.removeFromUseChains();
            this.current_.replace(this.iterator_, (DNode)unary);
        }
        if (sysreq.numOperands() != 2) {
            return;
        }
        switch (sysreq.nativeX().name()) {
            case "FloatAdd": {
                spop = SPOpcode.add;
                break;
            }
            case "FloatSub": {
                spop = SPOpcode.sub;
                break;
            }
            case "FloatMul": {
                spop = SPOpcode.smul;
                break;
            }
            case "FloatDiv": {
                spop = SPOpcode.sdiv_alt;
                break;
            }
            case "__FLOAT_GT__": {
                spop = SPOpcode.sgrtr;
                break;
            }
            case "__FLOAT_GE__": {
                spop = SPOpcode.sgeq;
                break;
            }
            case "__FLOAT_LT__": {
                spop = SPOpcode.sless;
                break;
            }
            case "__FLOAT_LE__": {
                spop = SPOpcode.sleq;
                break;
            }
            case "__FLOAT_EQ__": {
                spop = SPOpcode.eq;
                break;
            }
            case "__FLOAT_NE__": {
                spop = SPOpcode.neq;
                break;
            }
            default: {
                return;
            }
        }
        if ((spop == SPOpcode.add || spop == SPOpcode.smul) && sysreq.getOperand(0).type() == NodeType.DeclareLocal) {
            lhs = sysreq.getOperand(1);
            rhs = sysreq.getOperand(0);
        } else {
            lhs = sysreq.getOperand(0);
            rhs = sysreq.getOperand(1);
        }
        DBinary binary = new DBinary(spop, lhs, rhs);
        sysreq.getOperand(0).addType(new TypeUnit(new PawnType(CellType.Float)));
        sysreq.getOperand(1).addType(new TypeUnit(new PawnType(CellType.Float)));
        sysreq.replaceAllUsesWith(binary);
        sysreq.removeFromUseChains();
        this.current_.replace(this.iterator_, (DNode)binary);
    }

    @Override
    public void visit(DBinary binary) {
    }

    @Override
    public void visit(DBoundsCheck check) {
    }

    @Override
    public void visit(DArrayRef aref) {
    }

    @Override
    public void visit(DStore store) {
    }

    @Override
    public void visit(DLoad load) {
    }

    @Override
    public void visit(DReturn ret) {
    }

    @Override
    public void visit(DGlobal global) {
    }

    @Override
    public void visit(DString node) {
    }

    @Override
    public void visit(DPhi phi) throws Exception {
        NodeBlock idom = this.graph_.blocks(phi.block().lir().idom().id());
        DTempName name = new DTempName(this.graph_.tempName());
        idom.prepend(name);
        for (int i = 0; i < phi.numOperands(); ++i) {
            DNode input = phi.getOperand(i);
            DStore store = new DStore(name, input);
            NodeBlock pred = this.graph_.blocks(phi.block().lir().getPredecessor(i).id());
            pred.prepend(store);
        }
        phi.replaceAllUsesWith(name);
    }

    @Override
    public void visit(DCall call) throws Exception {
        SPOpcode spop;
        if (call.function().name().length() < 8) {
            return;
        }
        if (!call.function().name().substring(0, 8).equals("operator")) {
            return;
        }
        String op = "";
        for (int i = 8; i < call.function().name().length() && call.function().name().charAt(i) != '('; ++i) {
            op = op + call.function().name().charAt(i);
        }
        if (call.numOperands() == 2) {
            switch (op) {
                case ">": {
                    spop = SPOpcode.sgrtr;
                    break;
                }
                case ">=": {
                    spop = SPOpcode.sgeq;
                    break;
                }
                case "<": {
                    spop = SPOpcode.sless;
                    break;
                }
                case "<=": {
                    spop = SPOpcode.sleq;
                    break;
                }
                case "==": {
                    spop = SPOpcode.eq;
                    break;
                }
                case "!=": {
                    spop = SPOpcode.neq;
                    break;
                }
                case "+": {
                    spop = SPOpcode.add;
                    break;
                }
                case "-": {
                    spop = SPOpcode.sub;
                    break;
                }
                case "*": {
                    spop = SPOpcode.smul;
                    break;
                }
                case "/": {
                    spop = SPOpcode.sdiv_alt;
                    break;
                }
                default: {
                    throw new Exception("unknown operator (" + op + ")");
                }
            }
        } else {
            switch (op) {
                case "-": {
                    spop = SPOpcode.neg;
                    break;
                }
                case "!": {
                    spop = SPOpcode.not;
                    break;
                }
                case "++": {
                    spop = SPOpcode.inc;
                    break;
                }
                case "--": {
                    spop = SPOpcode.dec;
                    break;
                }
                default: {
                    throw new Exception("unknown operator (" + op + ")");
                }
            }
        }
        switch (spop) {
            case sgeq: 
            case sleq: 
            case sgrtr: 
            case sless: 
            case eq: 
            case neq: 
            case add: 
            case sub: 
            case smul: 
            case sdiv_alt: {
                DBinary binary = new DBinary(spop, call.getOperand(0), call.getOperand(1));
                call.replaceAllUsesWith(binary);
                call.removeFromUseChains();
                this.current_.replace(this.iterator_, (DNode)binary);
                break;
            }
            case inc: 
            case dec: {
                DBinary rep = new DBinary(spop == SPOpcode.inc ? SPOpcode.add : SPOpcode.sub, call.getOperand(0), new DFloat(1.0f));
                call.replaceAllUsesWith(rep);
                call.removeFromUseChains();
                this.current_.replace(this.iterator_, (DNode)rep);
                break;
            }
            case neg: 
            case not: {
                DUnary unary = new DUnary(spop, call.getOperand(0));
                call.replaceAllUsesWith(unary);
                call.removeFromUseChains();
                this.current_.replace(this.iterator_, (DNode)unary);
                break;
            }
            default: {
                throw new Exception("unknown spop");
            }
        }
    }

    private void rewriteBlock(NodeBlock block) throws Exception {
        this.current_ = block;
        this.iterator_ = block.nodes().begin();
        while (this.iterator_.more()) {
            this.iterator_.node().accept(this);
            this.iterator_.next();
        }
    }

    public NodeRewriter(NodeGraph graph) {
        this.graph_ = graph;
    }

    public void rewrite() throws Exception {
        for (int i = 0; i < this.graph_.numBlocks(); ++i) {
            this.rewriteBlock(this.graph_.blocks(i));
        }
    }
}

