/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes.types;

import java.util.LinkedList;
import lysis.lstructure.Tag;
import lysis.lstructure.VariableType;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeType;
import lysis.nodes.NodeVisitor;
import lysis.nodes.types.DUse;
import lysis.sourcepawn.SourcePawnFile;
import lysis.types.TypeSet;
import lysis.types.TypeUnit;

public abstract class DNode {
    private NodeBlock block_;
    private LinkedList<DUse> uses_ = new LinkedList();
    private DNode next_;
    private DNode prev_;
    private boolean usedAsArrayIndex_ = false;
    private boolean usedAsReference_ = false;
    private TypeSet typeSet_ = null;

    protected void addUse(DNode other, int i) {
        this.uses_.add(new DUse(other, i));
    }

    public void initOperand(int i, DNode node) throws Exception {
        if (node != null) {
            node.addUse(this, i);
        }
        this.setOperand(i, node);
    }

    public void replaceOperand(int i, DNode node) throws Exception {
        if (this.getOperand(i) == node) {
            return;
        }
        if (this.getOperand(i) != null) {
            this.getOperand(i).removeUse(i, this);
        }
        this.initOperand(i, node);
    }

    public void replaceAllUsesWith(DNode node) throws Exception {
        DUse[] copies;
        for (DUse use : copies = this.uses().toArray(new DUse[0])) {
            use.node().replaceOperand(use.index(), node);
        }
    }

    public void removeUse(int index, DNode node) {
        DUse use = null;
        for (DUse u : this.uses()) {
            if (u.index() != index || u.node() != node) continue;
            use = u;
            break;
        }
        assert (use != null);
        this.uses().remove(use);
    }

    public void removeFromUseChains() throws Exception {
        for (int i = 0; i < this.numOperands(); ++i) {
            this.replaceOperand(i, null);
        }
    }

    public void setBlock(NodeBlock block) {
        this.block_ = block;
    }

    public LinkedList<DUse> uses() {
        return this.uses_;
    }

    public NodeBlock block() {
        return this.block_;
    }

    public DNode next() {
        return this.next_;
    }

    public DNode nextSet(DNode value) {
        if (this.next_ != null && this.next_.type() == NodeType.Store || value == null || value.type() == NodeType.Store) {
            // empty if block
        }
        this.next_ = value;
        return this.next_;
    }

    public DNode prev() {
        return this.prev_;
    }

    public DNode prevSet(DNode value) {
        this.prev_ = value;
        return this.prev_;
    }

    public boolean usedAsArrayIndex() {
        return this.usedAsArrayIndex_;
    }

    public void setUsedAsArrayIndex() {
        this.usedAsArrayIndex_ = true;
    }

    public boolean usedAsReference() {
        return this.usedAsReference_;
    }

    public void setUsedAsReference() {
        this.usedAsReference_ = true;
    }

    private TypeSet ensureTypeSet() {
        if (this.typeSet_ == null) {
            this.typeSet_ = new TypeSet();
        }
        return this.typeSet_;
    }

    public void addType(TypeUnit tu) {
        assert (tu != null);
        this.ensureTypeSet().addType(tu);
    }

    public void addTypes(TypeSet ts) {
        this.ensureTypeSet().addTypes(ts);
    }

    public TypeSet typeSet() {
        return this.ensureTypeSet();
    }

    public boolean guard() {
        return false;
    }

    public boolean idempotent() {
        return true;
    }

    public boolean controlFlow() {
        return false;
    }

    public abstract NodeType type();

    public abstract int numOperands();

    public abstract DNode getOperand(int var1) throws Exception;

    protected abstract void setOperand(int var1, DNode var2) throws Exception;

    public abstract void accept(NodeVisitor var1) throws Exception;

    public DNode applyType(SourcePawnFile file, Tag tag, VariableType type) throws Exception {
        return this;
    }
}

