/*
 * Decompiled with CFR 0.152.
 */
package lysis.types;

import java.nio.ByteBuffer;
import lysis.BitConverter;
import lysis.Public;
import lysis.lstructure.Argument;
import lysis.lstructure.Function;
import lysis.lstructure.Scope;
import lysis.lstructure.Signature;
import lysis.lstructure.Variable;
import lysis.lstructure.VariableType;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeGraph;
import lysis.nodes.NodeList;
import lysis.nodes.NodeType;
import lysis.nodes.NodeVisitor;
import lysis.nodes.types.DArrayRef;
import lysis.nodes.types.DBinary;
import lysis.nodes.types.DBoolean;
import lysis.nodes.types.DBoundsCheck;
import lysis.nodes.types.DCall;
import lysis.nodes.types.DCharacter;
import lysis.nodes.types.DConstant;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DDeclareStatic;
import lysis.nodes.types.DFloat;
import lysis.nodes.types.DFunction;
import lysis.nodes.types.DGenArray;
import lysis.nodes.types.DGlobal;
import lysis.nodes.types.DJump;
import lysis.nodes.types.DJumpCondition;
import lysis.nodes.types.DLoad;
import lysis.nodes.types.DLocalRef;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DReturn;
import lysis.nodes.types.DStore;
import lysis.nodes.types.DString;
import lysis.nodes.types.DSysReq;
import lysis.sourcepawn.SPOpcode;
import lysis.types.CellType;
import lysis.types.PawnType;
import lysis.types.TypeUnit;

public class BackwardTypePropagation
extends NodeVisitor {
    private NodeGraph graph_;
    private NodeBlock block_;

    public BackwardTypePropagation(NodeGraph graph) {
        this.graph_ = graph;
    }

    public void propagate() throws Exception {
        for (int i = this.graph_.numBlocks() - 1; i >= 0; --i) {
            this.block_ = this.graph_.blocks(i);
            NodeList.reverse_iterator iter = this.block_.nodes().rbegin();
            while (iter.more()) {
                iter.node().accept(this);
                iter.next();
            }
        }
    }

    private void propagateInputs(DNode lhs, DNode rhs) {
        lhs.typeSet().addTypes(rhs.typeSet());
        rhs.typeSet().addTypes(lhs.typeSet());
    }

    private DNode ConstantToReference(DConstant node, TypeUnit tu) {
        Variable global = this.graph_.file().lookupGlobal(node.value());
        if (global == null) {
            global = this.graph_.file().lookupVariable(node.pc(), node.value(), Scope.Static);
        }
        if (global != null) {
            return new DGlobal(global);
        }
        if (tu != null && tu.isString()) {
            return new DString(this.graph_.file().stringFromData(node.value()));
        }
        return null;
    }

    @Override
    public void visit(DConstant node) throws Exception {
        DNode replacement = null;
        if (node.typeSet().numTypes() == 1) {
            TypeUnit tu = node.typeSet().types(0);
            block0 : switch (tu.kind()) {
                case Cell: {
                    switch (tu.type().type()) {
                        case Bool: {
                            replacement = new DBoolean(node.value() != 0L);
                            break block0;
                        }
                        case Character: {
                            replacement = new DCharacter((char)node.value());
                            break block0;
                        }
                        case Float: {
                            byte[] bits = BitConverter.GetBytes(node.value());
                            ByteBuffer b = ByteBuffer.wrap(bits);
                            float v = b.getFloat();
                            replacement = new DFloat(v);
                            break block0;
                        }
                        case Function: {
                            if (node.value() < 0L) break block0;
                            Public p = this.graph_.file().publics()[(int)(node.value() >> 1)];
                            Function function = this.graph_.file().lookupFunction(p.address());
                            replacement = new DFunction(p.address(), function);
                            break block0;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case Array: {
                    replacement = this.ConstantToReference(node, tu);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (replacement == null && node.usedAsReference()) {
            replacement = this.ConstantToReference(node, null);
        }
        if (replacement != null) {
            this.block_.nodes().insertAfter(node, replacement);
            node.replaceAllUsesWith(replacement);
        }
    }

    @Override
    public void visit(DDeclareLocal local) {
        if (local.value() != null && local.var() == null) {
            local.value().addTypes(local.typeSet());
        }
    }

    @Override
    public void visit(DLocalRef lref) {
        lref.addTypes(lref.local().typeSet());
    }

    @Override
    public void visit(DJump jump) {
    }

    @Override
    public void visit(DJumpCondition jcc) {
        if (jcc.getOperand(0).type() == NodeType.Binary) {
            DBinary binary = (DBinary)jcc.getOperand(0);
            this.propagateInputs(binary.lhs(), binary.rhs());
        }
    }

    private void visitSignature(DNode call, Signature signature) throws Exception {
        DNode node;
        int i;
        if (signature.args() == null) {
            for (int i2 = 0; i2 < call.numOperands(); ++i2) {
                DNode arg = call.getOperand(i2);
                this.visitArgument(call, arg, i2);
            }
            return;
        }
        for (i = 0; i < call.numOperands() && i < signature.args().length; ++i) {
            TypeUnit tu;
            DConstant constNode;
            DDeclareLocal localNode;
            Argument arg;
            node = call.getOperand(i);
            Argument argument = arg = i < signature.args().length ? signature.args()[i] : signature.args()[signature.args().length - 1];
            if (arg.generated() || arg.type() == VariableType.ArrayReference && arg.dimensions() != null && arg.dimensions().length == 1 && arg.tag().name().equals("_")) {
                if (node.type() == NodeType.Constant) {
                    DConstant constNode2 = (DConstant)node;
                    if (this.graph_.file().IsMaybeString(constNode2.value())) {
                        call.replaceOperand(i, new DString(this.graph_.file().stringFromData(constNode2.value())));
                        continue;
                    }
                } else if (node.type() == NodeType.DeclareLocal && (localNode = (DDeclareLocal)node).value() != null && localNode.value().type() == NodeType.Constant && (constNode = (DConstant)localNode.value()).value() > 0L && this.graph_.file().IsMaybeString(constNode.value())) {
                    call.replaceOperand(i, new DString(this.graph_.file().stringFromData(constNode.value())));
                    continue;
                }
            }
            if (arg.type() == VariableType.Reference && node.type() == NodeType.DeclareLocal && node.getOperand(0).type() == NodeType.Constant) {
                localNode = (DDeclareLocal)node;
                constNode = (DConstant)localNode.getOperand(0);
                Variable global = this.graph_.file().lookupGlobal(constNode.value());
                if (global == null) {
                    global = this.graph_.file().lookupVariable(localNode.pc(), constNode.value(), Scope.Static);
                }
                if (global != null) {
                    call.replaceOperand(i, new DGlobal(global));
                    node = call.getOperand(i);
                }
            }
            if ((tu = TypeUnit.FromArgument(arg)) == null) continue;
            if (tu.kind() == TypeUnit.Kind.Cell && tu.type().type() == CellType.Function && node.type() == NodeType.DeclareLocal && node.getOperand(0).type() == NodeType.Constant && ((DConstant)node.getOperand(0)).value() < 0L) {
                tu = new TypeUnit(new PawnType(CellType.Tag, arg.tag()));
            }
            node.addType(tu);
        }
        if (signature.args().length > 0 && (signature.args()[signature.args().length - 1].type() == VariableType.Variadic || signature.args().length < call.numOperands())) {
            for (i = signature.args().length - 1; i < call.numOperands(); ++i) {
                node = call.getOperand(i);
                this.visitArgument(call, node, i);
            }
        }
    }

    private void visitArgument(DNode call, DNode arg, int index) throws Exception {
        switch (arg.type()) {
            case DeclareLocal: {
                DDeclareLocal localNode = (DDeclareLocal)arg;
                if (localNode.value() != null && localNode.value().type() == NodeType.Constant) {
                    DConstant constNode = (DConstant)localNode.value();
                    Variable global = this.graph_.file().lookupGlobal(constNode.value());
                    if (global == null) {
                        global = this.graph_.file().lookupVariable(localNode.pc(), constNode.value(), Scope.Static);
                    }
                    if (global != null) {
                        if (!global.isStateVariable()) {
                            call.replaceOperand(index, new DGlobal(global));
                        }
                        return;
                    }
                    if (this.graph_.file().IsMaybeString(constNode.value())) {
                        call.replaceOperand(index, new DString(this.graph_.file().stringFromData(constNode.value())));
                    }
                }
                if (localNode.var() == null) {
                    return;
                }
                TypeUnit tu = TypeUnit.FromVariable(localNode.var());
                if (tu == null) break;
                arg.addType(tu);
                return;
            }
            case DeclareStatic: {
                DDeclareStatic staticNode = (DDeclareStatic)arg;
                if (staticNode.var() == null) {
                    return;
                }
                TypeUnit tu = TypeUnit.FromVariable(staticNode.var());
                if (tu == null) break;
                arg.addType(tu);
                return;
            }
            case Constant: {
                DConstant constNode = (DConstant)arg;
                if (!this.graph_.file().IsMaybeString(constNode.value())) break;
                call.replaceOperand(index, new DString(this.graph_.file().stringFromData(constNode.value())));
                break;
            }
        }
    }

    @Override
    public void visit(DCall call) throws Exception {
        this.visitSignature(call, call.function());
    }

    @Override
    public void visit(DSysReq sysreq) throws Exception {
        this.visitSignature(sysreq, sysreq.nativeX());
    }

    @Override
    public void visit(DBinary binary) {
        if (binary.spop() == SPOpcode.add && binary.usedAsReference()) {
            binary.lhs().setUsedAsReference();
        }
        if (binary.uses().size() != 1) {
            return;
        }
        DDeclareLocal local = null;
        if (binary.lhs().type() == NodeType.DeclareLocal) {
            local = (DDeclareLocal)binary.lhs();
        } else if (binary.rhs().type() == NodeType.DeclareLocal) {
            local = (DDeclareLocal)binary.rhs();
        } else {
            return;
        }
        if (local.value() != null && local.value().type() == NodeType.Constant) {
            TypeUnit unit;
            DStore store;
            DConstant con = (DConstant)local.value();
            if (con.value() < 1000000000L) {
                return;
            }
            if (con.typeSet() != null && con.typeSet().numTypes() > 0) {
                return;
            }
            DNode use = binary.uses().getFirst().node();
            if (use.type() == NodeType.Store && (store = (DStore)use).lhs().typeSet().numTypes() == 1 && (unit = store.lhs().typeSet().types(0)).kind() == TypeUnit.Kind.Reference && unit.inner().type().type() == CellType.Float) {
                con.addType(new TypeUnit(new PawnType(CellType.Float)));
            }
        }
    }

    @Override
    public void visit(DBoundsCheck check) {
    }

    @Override
    public void visit(DArrayRef aref) {
        aref.abase().setUsedAsReference();
    }

    @Override
    public void visit(DStore store) {
        store.getOperand(0).setUsedAsReference();
    }

    @Override
    public void visit(DLoad load) throws Exception {
        TypeUnit tu;
        load.from().setUsedAsReference();
        if (load.from().typeSet() != null && load.from().typeSet().numTypes() == 1 && (tu = load.from().typeSet().types(0)).kind() == TypeUnit.Kind.Array) {
            DArrayRef arrayref;
            if (load.from().type() == NodeType.ArrayRef && (arrayref = (DArrayRef)load.from()).abase().type() == NodeType.Global) {
                return;
            }
            DConstant cv = new DConstant(0L);
            DArrayRef aref = new DArrayRef(load.from(), cv, 1L);
            this.block_.nodes().insertAfter(load.from(), cv);
            this.block_.nodes().insertAfter(cv, aref);
            load.replaceOperand(0, aref);
        }
    }

    @Override
    public void visit(DReturn ret) {
        if (this.graph_.function() != null) {
            DNode input = ret.getOperand(0);
            TypeUnit tu = TypeUnit.FromFunction(this.graph_.function());
            input.typeSet().addType(tu);
        }
    }

    @Override
    public void visit(DGlobal global) {
    }

    @Override
    public void visit(DString node) {
    }

    @Override
    public void visit(DGenArray genarray) throws Exception {
        for (int i = 0; i < genarray.numOperands(); ++i) {
            genarray.getOperand(i).accept(this);
        }
    }
}

