/*
 * Decompiled with CFR 0.152.
 */
package lysis.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import lysis.BitConverter;
import lysis.PawnFile;
import lysis.builder.structure.BlockAnalysis;
import lysis.instructions.LAddConstant;
import lysis.instructions.LBinary;
import lysis.instructions.LBounds;
import lysis.instructions.LCall;
import lysis.instructions.LConstant;
import lysis.instructions.LDebugBreak;
import lysis.instructions.LDecGlobal;
import lysis.instructions.LDecI;
import lysis.instructions.LDecLocal;
import lysis.instructions.LDecReg;
import lysis.instructions.LEqualConstant;
import lysis.instructions.LExchange;
import lysis.instructions.LFill;
import lysis.instructions.LGenArray;
import lysis.instructions.LGoto;
import lysis.instructions.LHeap;
import lysis.instructions.LHeapRestore;
import lysis.instructions.LHeapSave;
import lysis.instructions.LIncGlobal;
import lysis.instructions.LIncI;
import lysis.instructions.LIncLocal;
import lysis.instructions.LIncReg;
import lysis.instructions.LIndexAddress;
import lysis.instructions.LInitArray;
import lysis.instructions.LInstruction;
import lysis.instructions.LJump;
import lysis.instructions.LJumpCondition;
import lysis.instructions.LLoad;
import lysis.instructions.LLoadCtrl;
import lysis.instructions.LLoadGlobal;
import lysis.instructions.LLoadIndex;
import lysis.instructions.LLoadLocal;
import lysis.instructions.LLoadLocalRef;
import lysis.instructions.LMemCopy;
import lysis.instructions.LMove;
import lysis.instructions.LMulConstant;
import lysis.instructions.LPop;
import lysis.instructions.LPushConstant;
import lysis.instructions.LPushGlobal;
import lysis.instructions.LPushLocal;
import lysis.instructions.LPushReg;
import lysis.instructions.LPushStackAddress;
import lysis.instructions.LReturn;
import lysis.instructions.LShiftLeftConstant;
import lysis.instructions.LStack;
import lysis.instructions.LStackAddress;
import lysis.instructions.LStackAdjust;
import lysis.instructions.LStore;
import lysis.instructions.LStoreCtrl;
import lysis.instructions.LStoreGlobal;
import lysis.instructions.LStoreGlobalConstant;
import lysis.instructions.LStoreLocal;
import lysis.instructions.LStoreLocalConstant;
import lysis.instructions.LStoreLocalRef;
import lysis.instructions.LStradjustPri;
import lysis.instructions.LSwap;
import lysis.instructions.LSwitch;
import lysis.instructions.LSysReq;
import lysis.instructions.LTrackerPopSetHeap;
import lysis.instructions.LTrackerPushC;
import lysis.instructions.LUnary;
import lysis.instructions.LZeroGlobal;
import lysis.instructions.LZeroLocal;
import lysis.instructions.SwitchCase;
import lysis.lstructure.Function;
import lysis.lstructure.LBlock;
import lysis.lstructure.LGraph;
import lysis.lstructure.Register;
import lysis.lstructure.Variable;
import lysis.sourcepawn.SPOpcode;

public class MethodParser {
    private PawnFile file_;
    private Function func_;
    private long pc_;
    private long current_pc_;
    private LIR lir_ = new LIR();
    private boolean need_proc_;

    private int readInt32() {
        this.pc_ += 4L;
        return BitConverter.ToInt32(this.file_.code().bytes(), (int)this.pc_ - 4);
    }

    private long readUInt32() {
        this.pc_ += 4L;
        return BitConverter.ToUInt32(this.file_.code().bytes(), (int)this.pc_ - 4);
    }

    private SPOpcode readOp() {
        return SPOpcode.values()[(int)this.readUInt32()];
    }

    private SPOpcode peekOp() {
        long op = this.readUInt32();
        this.pc_ -= 4L;
        return SPOpcode.values()[(int)op];
    }

    private LInstruction add(LInstruction ins) {
        ins.setPc(this.current_pc_);
        this.lir_.instructions.add(ins);
        return ins;
    }

    private LBlock prepareJumpTarget(long offset) {
        if (!this.lir_.targets.containsKey(offset)) {
            this.lir_.targets.put(offset, new LBlock(offset));
        }
        return this.lir_.targets.get(offset);
    }

    private int trackStack(int offset) {
        if (offset < 0) {
            return offset;
        }
        if (offset > this.lir_.argDepth && (offset - 12) / 4 + 1 <= 32) {
            this.lir_.argDepth = offset;
        }
        return offset;
    }

    private int trackGlobal(int addr) {
        this.file_.addGlobal(addr);
        return addr;
    }

    private LInstruction readInstruction(SPOpcode op) throws Exception {
        switch (op) {
            case load_pri: 
            case load_alt: {
                Register reg = op == SPOpcode.load_pri ? Register.Pri : Register.Alt;
                return new LLoadGlobal(this.trackGlobal(this.readInt32()), reg);
            }
            case load_s_pri: 
            case load_s_alt: {
                Register reg = op == SPOpcode.load_s_pri ? Register.Pri : Register.Alt;
                return new LLoadLocal(this.trackStack(this.readInt32()), reg);
            }
            case lref_s_pri: 
            case lref_s_alt: {
                Register reg = op == SPOpcode.lref_s_pri ? Register.Pri : Register.Alt;
                return new LLoadLocalRef(this.trackStack(this.readInt32()), reg);
            }
            case stor_s_pri: 
            case stor_s_alt: {
                Register reg = op == SPOpcode.stor_s_pri ? Register.Pri : Register.Alt;
                return new LStoreLocal(reg, this.trackStack(this.readInt32()));
            }
            case sref_s_pri: 
            case sref_s_alt: {
                Register reg = op == SPOpcode.sref_s_pri ? Register.Pri : Register.Alt;
                return new LStoreLocalRef(reg, this.trackStack(this.readInt32()));
            }
            case load_i: {
                return new LLoad(4L);
            }
            case lodb_i: {
                return new LLoad(this.readInt32());
            }
            case const_pri: 
            case const_alt: {
                Register reg = op == SPOpcode.const_pri ? Register.Pri : Register.Alt;
                return new LConstant(this.readInt32(), reg);
            }
            case addr_pri: 
            case addr_alt: {
                Register reg = op == SPOpcode.addr_pri ? Register.Pri : Register.Alt;
                return new LStackAddress(this.trackStack(this.readInt32()), reg);
            }
            case stor_pri: 
            case stor_alt: {
                Register reg = op == SPOpcode.stor_pri ? Register.Pri : Register.Alt;
                return new LStoreGlobal(this.trackGlobal(this.readInt32()), reg);
            }
            case stor_i: {
                return new LStore(4L);
            }
            case strb_i: {
                return new LStore(this.readInt32());
            }
            case lidx: {
                return new LLoadIndex(4L);
            }
            case lidx_b: {
                return new LLoadIndex(this.readInt32());
            }
            case idxaddr: {
                return new LIndexAddress(2L);
            }
            case idxaddr_b: {
                return new LIndexAddress(this.readInt32());
            }
            case move_pri: 
            case move_alt: {
                Register reg = op == SPOpcode.move_pri ? Register.Pri : Register.Alt;
                return new LMove(reg);
            }
            case xchg: {
                return new LExchange();
            }
            case push_pri: 
            case push_alt: {
                Register reg = op == SPOpcode.push_pri ? Register.Pri : Register.Alt;
                return new LPushReg(reg);
            }
            case push_c: {
                return new LPushConstant(this.readInt32());
            }
            case push: {
                return new LPushGlobal(this.trackGlobal(this.readInt32()));
            }
            case push_s: {
                return new LPushLocal(this.trackStack(this.readInt32()));
            }
            case pop_pri: 
            case pop_alt: {
                Register reg = op == SPOpcode.pop_pri ? Register.Pri : Register.Alt;
                return new LPop(reg);
            }
            case stack: {
                return new LStack(this.readInt32());
            }
            case retn: {
                return new LReturn();
            }
            case call: {
                long addr = this.readInt32();
                this.file_.addFunction(addr);
                return new LCall(addr);
            }
            case jump: {
                long offset = this.readUInt32();
                return new LJump(this.prepareJumpTarget(offset), offset);
            }
            case jeq: 
            case jneq: 
            case jnz: 
            case jzer: 
            case jsgeq: 
            case jsless: 
            case jsgrtr: 
            case jsleq: {
                long offset = this.readUInt32();
                if (offset == this.pc_) {
                    return new LJump(this.prepareJumpTarget(offset), offset);
                }
                return new LJumpCondition(op, this.prepareJumpTarget(offset), this.prepareJumpTarget(this.pc_), offset);
            }
            case sdiv_alt: 
            case sub_alt: {
                return new LBinary(op, Register.Alt, Register.Pri);
            }
            case add: 
            case and: 
            case or: 
            case smul: 
            case sdiv: 
            case shr: 
            case shl: 
            case sub: 
            case sshr: 
            case xor: {
                return new LBinary(op, Register.Pri, Register.Alt);
            }
            case shl_c_pri: 
            case shl_c_alt: {
                Register reg = op == SPOpcode.shl_c_pri ? Register.Pri : Register.Alt;
                return new LShiftLeftConstant(this.readInt32(), reg);
            }
            case not: 
            case neg: 
            case invert: {
                return new LUnary(op, Register.Pri);
            }
            case add_c: {
                return new LAddConstant(this.readInt32());
            }
            case smul_c: {
                return new LMulConstant(this.readInt32());
            }
            case zero_pri: 
            case zero_alt: {
                Register reg = op == SPOpcode.zero_pri ? Register.Pri : Register.Alt;
                return new LConstant(0L, reg);
            }
            case zero_s: {
                return new LZeroLocal(this.trackStack(this.readInt32()));
            }
            case zero: {
                return new LZeroGlobal(this.trackGlobal(this.readInt32()));
            }
            case eq: 
            case neq: 
            case sleq: 
            case sgeq: 
            case sgrtr: 
            case sless: {
                return new LBinary(op, Register.Pri, Register.Alt);
            }
            case eq_c_pri: 
            case eq_c_alt: {
                Register reg = op == SPOpcode.eq_c_pri ? Register.Pri : Register.Alt;
                return new LEqualConstant(reg, this.readInt32());
            }
            case inc: {
                return new LIncGlobal(this.trackGlobal(this.readInt32()));
            }
            case dec: {
                return new LDecGlobal(this.trackGlobal(this.readInt32()));
            }
            case inc_s: {
                return new LIncLocal(this.trackStack(this.readInt32()));
            }
            case dec_s: {
                return new LDecLocal(this.trackStack(this.readInt32()));
            }
            case inc_i: {
                return new LIncI();
            }
            case inc_pri: 
            case inc_alt: {
                Register reg = op == SPOpcode.inc_pri ? Register.Pri : Register.Alt;
                return new LIncReg(reg);
            }
            case dec_pri: 
            case dec_alt: {
                Register reg = op == SPOpcode.dec_pri ? Register.Pri : Register.Alt;
                return new LDecReg(reg);
            }
            case dec_i: {
                return new LDecI();
            }
            case fill: {
                return new LFill(this.readInt32());
            }
            case bounds: {
                return new LBounds(this.readInt32());
            }
            case swap_pri: 
            case swap_alt: {
                Register reg = op == SPOpcode.swap_pri ? Register.Pri : Register.Alt;
                return new LSwap(reg);
            }
            case push_adr: {
                return new LPushStackAddress(this.trackStack(this.readInt32()));
            }
            case sysreq_c: {
                long index = this.readUInt32();
                long prePeep = this.pc_;
                SPOpcode nextOp = this.readOp();
                int nextValue = this.readInt32();
                long argSize = ((LPushConstant)this.lir_.instructions.get(this.lir_.instructions.size() - 1)).val();
                if (!this.file_.PassArgCountAsSize()) {
                    argSize *= 4L;
                }
                assert (nextOp == SPOpcode.stack && (long)nextValue == (argSize += 4L));
                if (nextOp != SPOpcode.stack || (long)nextValue != argSize) {
                    this.pc_ = prePeep;
                }
                return new LSysReq(this.file_.natives()[(int)index]);
            }
            case sysreq_n: {
                long index = this.readUInt32();
                this.add(new LPushConstant((int)this.readUInt32()));
                return new LSysReq(this.file_.natives()[(int)index]);
            }
            case dbreak: {
                return new LDebugBreak();
            }
            case push2_s: {
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                return new LPushLocal(this.trackStack(this.readInt32()));
            }
            case push2_adr: {
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                return new LPushStackAddress(this.trackStack(this.readInt32()));
            }
            case push2_c: {
                this.add(new LPushConstant(this.readInt32()));
                return new LPushConstant(this.readInt32());
            }
            case push2: {
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                return new LPushGlobal(this.trackGlobal(this.readInt32()));
            }
            case push3_s: {
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                return new LPushLocal(this.trackStack(this.readInt32()));
            }
            case push3_adr: {
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                return new LPushStackAddress(this.trackStack(this.readInt32()));
            }
            case push3_c: {
                this.add(new LPushConstant(this.readInt32()));
                this.add(new LPushConstant(this.readInt32()));
                return new LPushConstant(this.readInt32());
            }
            case push3: {
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                return new LPushGlobal(this.trackGlobal(this.readInt32()));
            }
            case push4_s: {
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                return new LPushLocal(this.trackStack(this.readInt32()));
            }
            case push4_adr: {
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                return new LPushStackAddress(this.trackStack(this.readInt32()));
            }
            case push4_c: {
                this.add(new LPushConstant(this.readInt32()));
                this.add(new LPushConstant(this.readInt32()));
                this.add(new LPushConstant(this.readInt32()));
                return new LPushConstant(this.readInt32());
            }
            case push4: {
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                return new LPushGlobal(this.trackGlobal(this.readInt32()));
            }
            case push5_s: {
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                this.add(new LPushLocal(this.trackStack(this.readInt32())));
                return new LPushLocal(this.trackStack(this.readInt32()));
            }
            case push5_c: {
                this.add(new LPushConstant(this.readInt32()));
                this.add(new LPushConstant(this.readInt32()));
                this.add(new LPushConstant(this.readInt32()));
                this.add(new LPushConstant(this.readInt32()));
                return new LPushConstant(this.readInt32());
            }
            case push5_adr: {
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                this.add(new LPushStackAddress(this.trackStack(this.readInt32())));
                return new LPushStackAddress(this.trackStack(this.readInt32()));
            }
            case push5: {
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                this.add(new LPushGlobal(this.trackGlobal(this.readInt32())));
                return new LPushGlobal(this.trackGlobal(this.readInt32()));
            }
            case load_both: {
                this.add(new LLoadGlobal(this.trackGlobal(this.readInt32()), Register.Pri));
                return new LLoadGlobal(this.trackGlobal(this.readInt32()), Register.Alt);
            }
            case load_s_both: {
                this.add(new LLoadLocal(this.trackStack(this.readInt32()), Register.Pri));
                return new LLoadLocal(this.trackStack(this.readInt32()), Register.Alt);
            }
            case const_: {
                return new LStoreGlobalConstant(this.trackGlobal(this.readInt32()), this.readInt32());
            }
            case const_s: {
                return new LStoreLocalConstant(this.trackStack(this.readInt32()), this.readInt32());
            }
            case heap: {
                return new LHeap(this.readInt32());
            }
            case movs: {
                return new LMemCopy(this.readInt32());
            }
            case switch_: {
                long table = this.readUInt32();
                long savePc = this.pc_;
                this.pc_ = table;
                SPOpcode casetbl = SPOpcode.values()[(int)this.readUInt32()];
                assert (casetbl == SPOpcode.casetbl);
                int ncases = this.readInt32();
                long defaultCase = this.readUInt32();
                LinkedList<SwitchCase> cases = new LinkedList<SwitchCase>();
                for (int i = 0; i < ncases; ++i) {
                    int value = this.readInt32();
                    long pc = this.readUInt32();
                    LBlock target = this.prepareJumpTarget(pc);
                    boolean bMultipleValues = false;
                    for (int j = 0; j < cases.size(); ++j) {
                        if (!cases.get((int)j).target.equals(target)) continue;
                        cases.get(j).addValue(value);
                        bMultipleValues = true;
                        break;
                    }
                    if (bMultipleValues) continue;
                    cases.add(new SwitchCase(value, target));
                }
                this.pc_ = savePc;
                return new LSwitch(this.prepareJumpTarget(defaultCase), cases);
            }
            case casetbl: {
                int ncases = this.readInt32();
                this.pc_ += (long)ncases * 8L + 4L;
                return new LDebugBreak();
            }
            case genarray: {
                int dims = this.readInt32();
                return new LGenArray(dims, false);
            }
            case genarray_z: {
                int dims = this.readInt32();
                return new LGenArray(dims, true);
            }
            case tracker_pop_setheap: {
                return new LTrackerPopSetHeap();
            }
            case tracker_push_c: {
                int value = this.readInt32();
                return new LTrackerPushC(value);
            }
            case stradjust_pri: {
                return new LStradjustPri();
            }
            case stackadjust: {
                int value = this.readInt32();
                assert (value <= 0);
                return new LStackAdjust(value);
            }
            case heap_save: {
                return new LHeapSave();
            }
            case heap_restore: {
                return new LHeapRestore();
            }
            case initarray_pri: 
            case initarray_alt: {
                Register reg = op == SPOpcode.initarray_pri ? Register.Pri : Register.Alt;
                return new LInitArray(reg, this.readInt32(), this.readInt32(), this.readInt32(), this.readInt32(), this.readInt32());
            }
            case nop: {
                return new LDebugBreak();
            }
            case halt: {
                this.readInt32();
                return new LDebugBreak();
            }
            case lctrl: {
                int index = this.readInt32();
                return new LLoadCtrl(index);
            }
            case sctrl: {
                int index = this.readInt32();
                return new LStoreCtrl(index);
            }
            case line: {
                this.readUInt32();
                this.readUInt32();
                return new LDebugBreak();
            }
            case file: {
                long num = this.readUInt32();
                this.readUInt32();
                this.pc_ += num - 4L;
                return new LDebugBreak();
            }
            case srange: {
                this.readUInt32();
                this.readUInt32();
                return new LDebugBreak();
            }
            case symtag: {
                this.readUInt32();
                return new LDebugBreak();
            }
            case symbol: {
                long num = this.readUInt32();
                this.readUInt32();
                this.readUInt32();
                this.pc_ += num - 8L;
                return new LDebugBreak();
            }
        }
        throw new Exception("Unrecognized opcode: " + (Object)((Object)op));
    }

    private void readAll() throws Exception {
        SPOpcode op;
        this.lir_.entry_pc = this.pc_;
        if (this.need_proc_) {
            block3: while (this.pc_ < (long)this.file_.code().bytes().length) {
                this.current_pc_ = this.pc_;
                op = this.readOp();
                if (op == SPOpcode.proc) break;
                switch (op) {
                    case symtag: {
                        this.add(this.readInstruction(op));
                        continue block3;
                    }
                }
                throw new Exception(String.format("invalid method, first op must be PROC, but found %s", new Object[]{op}));
            }
        }
        while (this.pc_ < (long)this.file_.code().bytes().length) {
            this.current_pc_ = this.pc_;
            op = this.readOp();
            if (op == SPOpcode.proc || op == SPOpcode.endproc) break;
            this.add(this.readInstruction(op));
        }
        this.lir_.exit_pc = this.pc_;
    }

    private void readStateTable() throws Exception {
        this.lir_.entry_pc = this.pc_;
        this.current_pc_ = this.pc_;
        SPOpcode op = this.readOp();
        assert (op == SPOpcode.load_pri);
        this.add(this.readInstruction(op));
        this.current_pc_ = this.pc_;
        op = this.readOp();
        assert (op == SPOpcode.switch_);
        this.add(this.readInstruction(op));
        while (this.pc_ < (long)this.file_.code().bytes().length) {
            this.current_pc_ = this.pc_;
            op = this.readOp();
            if (op != SPOpcode.casetbl) break;
            this.add(this.readInstruction(op));
        }
        this.lir_.exit_pc = this.current_pc_;
        LLoadGlobal state_var = (LLoadGlobal)this.lir_.instructions.get(0);
        Variable var = this.file_.lookupGlobal(state_var.address());
        var.setName("g_statevar_" + var.address());
        var.markAsStateVariable();
        LSwitch function_list = (LSwitch)this.lir_.instructions.get(1);
        Function default_func = this.file_.addFunction(function_list.defaultCase().pc());
        default_func.setName(this.func_.name());
        default_func.setStateAddr(state_var.address());
        default_func.setTag(this.func_.returnTag());
        default_func.setTagId(this.func_.tag_id());
        for (int i = 0; i < function_list.numCases(); ++i) {
            SwitchCase case_ = function_list.getCase(i);
            assert (case_.numValues() == 1);
            long state_id = case_.value(0);
            long start_addr = case_.target.pc();
            Function state_func = this.file_.addFunction(start_addr);
            state_func.setName(this.func_.name());
            state_func.setStateId((short)state_id);
            state_func.setStateAddr(state_var.address());
            state_func.setTag(this.func_.returnTag());
            state_func.setTagId(this.func_.tag_id());
        }
    }

    private boolean ContainsBlock(LBlock[] blocks, LBlock needle) {
        for (LBlock block : blocks) {
            if (block != needle) continue;
            return true;
        }
        return false;
    }

    private LGraph buildBlocks() throws Exception {
        LBlock[] blocks;
        this.lir_.entry = new LBlock(this.lir_.entry_pc);
        BlockBuilder builder = new BlockBuilder(this.lir_);
        LBlock entry = builder.parse();
        for (LBlock block : blocks = BlockAnalysis.Order(entry)) {
            int numPredecessors = block.numPredecessors();
            for (int i = 0; i < numPredecessors; ++i) {
                if (this.ContainsBlock(blocks, block.getPredecessor(i))) continue;
                block.removePredecessor(block.getPredecessor(i));
                --numPredecessors;
            }
        }
        if (!BlockAnalysis.IsReducible(blocks)) {
            throw new Exception("control flow graph is not reducible");
        }
        BlockAnalysis.SplitCriticalEdges(blocks);
        blocks = BlockAnalysis.Order(entry);
        assert (BlockAnalysis.IsReducible(blocks));
        BlockAnalysis.ComputeDominators(blocks);
        BlockAnalysis.ComputeImmediateDominators(blocks);
        BlockAnalysis.ComputeDominatorTree(blocks);
        LBlock newEntry = BlockAnalysis.EnforceStackBalance(this.file_, blocks);
        if (newEntry != null) {
            newEntry = BlockAnalysis.FollowGoto(newEntry);
            MethodParser subParser = new MethodParser(this.file_, this.func_, newEntry.pc());
            subParser.readAll();
            LGraph graph = subParser.buildBlocks();
            graph.entry.setPC(this.lir_.entry_pc);
            return graph;
        }
        BlockAnalysis.FindLoops(blocks);
        LGraph graph = new LGraph();
        graph.blocks = blocks;
        graph.entry = blocks[0];
        graph.nargs = this.getNumArgs();
        return graph;
    }

    private MethodParser(PawnFile file, Function func, long pc) {
        this.file_ = file;
        this.func_ = func;
        this.pc_ = pc;
        this.need_proc_ = false;
    }

    public MethodParser(PawnFile file, Function func) {
        this.file_ = file;
        this.func_ = func;
        this.pc_ = func.address();
        this.need_proc_ = true;
    }

    public boolean preprocess() throws Exception {
        SPOpcode op = this.peekOp();
        if (op == SPOpcode.load_pri) {
            this.readStateTable();
            this.func_.setCodeEnd(this.getExitPC());
            return false;
        }
        this.readAll();
        return true;
    }

    public LGraph parse() throws Exception {
        if (!this.preprocess()) {
            return null;
        }
        return this.buildBlocks();
    }

    public long getExitPC() {
        return this.lir_.exit_pc;
    }

    public int getNumArgs() {
        if (this.lir_.argDepth > 0) {
            return (this.lir_.argDepth - 12) / 4 + 1;
        }
        return 0;
    }

    private class BlockBuilder {
        private List<LInstruction> pending_ = null;
        private LBlock block_ = null;
        private LIR lir_;

        private void transitionBlocks(LBlock next) {
            assert (this.pending_.size() == 0 || this.block_ != null);
            if (this.block_ != null) {
                assert (this.pending_.get(this.pending_.size() - 1).isControl());
                assert (this.block_.pc() >= this.lir_.entry_pc && this.block_.pc() < this.lir_.exit_pc);
                this.block_.setInstructions(this.pending_.toArray(new LInstruction[0]));
                this.pending_.clear();
            }
            this.block_ = next;
        }

        public BlockBuilder(LIR lir) {
            this.pending_ = new ArrayList<LInstruction>(lir.instructions.size());
            this.lir_ = lir;
            this.block_ = this.lir_.entry;
        }

        public LBlock parse() {
            block6: for (int i = 0; i < this.lir_.instructions.size(); ++i) {
                LBlock next;
                LInstruction ins = this.lir_.instructions.get(i);
                if (this.lir_.isTarget(ins.pc()) && this.block_ != (next = this.lir_.blockOfTarget(ins.pc()))) {
                    if (this.block_ != null) {
                        assert (!this.pending_.get(this.pending_.size() - 1).isControl());
                        this.pending_.add(new LGoto(next));
                        next.addPredecessor(this.block_);
                    }
                    this.transitionBlocks(next);
                }
                if (this.block_ == null) continue;
                this.pending_.add(ins);
                switch (ins.op()) {
                    case Return: {
                        this.transitionBlocks(null);
                        continue block6;
                    }
                    case Jump: {
                        LJump jump = (LJump)ins;
                        jump.target().addPredecessor(this.block_);
                        this.transitionBlocks(null);
                        continue block6;
                    }
                    case JumpCondition: {
                        LJumpCondition jcc = (LJumpCondition)ins;
                        jcc.trueTarget().addPredecessor(this.block_);
                        jcc.falseTarget().addPredecessor(this.block_);
                        assert (this.lir_.instructions.get(i + 1).pc() == jcc.falseTarget().pc());
                        this.transitionBlocks(null);
                        continue block6;
                    }
                    case Switch: {
                        LSwitch switch_ = (LSwitch)ins;
                        for (int j = 0; j < switch_.numSuccessors(); ++j) {
                            switch_.getSuccessor(j).addPredecessor(this.block_);
                        }
                        this.transitionBlocks(null);
                        continue block6;
                    }
                }
            }
            return this.lir_.entry;
        }
    }

    private class LIR {
        public LBlock entry;
        public List<LInstruction> instructions = new ArrayList<LInstruction>();
        public HashMap<Long, LBlock> targets = new HashMap();
        public long entry_pc = 0L;
        public long exit_pc = 0L;
        public int argDepth = 0;

        private LIR() {
        }

        public boolean isTarget(long offs) {
            assert (offs >= this.entry_pc && offs < this.exit_pc);
            return this.targets.containsKey(offs);
        }

        public LBlock blockOfTarget(long offs) {
            assert (offs >= this.entry_pc && offs < this.exit_pc);
            assert (this.targets.get(offs) != null);
            return this.targets.get(offs);
        }
    }
}

