/*
 * Decompiled with CFR 0.152.
 */
package lysis.builder.structure;

import java.util.LinkedList;
import lysis.builder.structure.LogicOperator;
import lysis.nodes.types.DNode;

public class LogicChain {
    private LogicOperator op_;
    private LinkedList<Node> nodes_ = new LinkedList();

    public LogicChain(LogicOperator op) {
        this.op_ = op;
    }

    public void append(DNode expression) {
        this.nodes_.add(new Node(expression));
    }

    public void append(LogicChain subChain) {
        this.nodes_.add(new Node(subChain));
    }

    public LogicOperator op() {
        return this.op_;
    }

    public LinkedList<Node> nodes() {
        return this.nodes_;
    }

    public class Node {
        private DNode expression_;
        private LogicChain subChain_;

        public Node(DNode expression) {
            this.expression_ = expression;
        }

        public Node(LogicChain subChain) {
            this.subChain_ = subChain;
        }

        public DNode expression() {
            assert (!this.isSubChain());
            return this.expression_;
        }

        public boolean isSubChain() {
            return this.subChain_ != null;
        }

        public LogicChain subChain() {
            return this.subChain_;
        }
    }
}

