/*
 * Decompiled with CFR 0.152.
 */
package lysis.builder.structure;

import java.util.LinkedList;
import java.util.Stack;
import lysis.builder.structure.BlockAnalysis;
import lysis.builder.structure.ControlBlock;
import lysis.builder.structure.ControlType;
import lysis.builder.structure.GotoBlock;
import lysis.builder.structure.IfBlock;
import lysis.builder.structure.LogicChain;
import lysis.builder.structure.LogicOperator;
import lysis.builder.structure.ReturnBlock;
import lysis.builder.structure.StatementBlock;
import lysis.builder.structure.SwitchBlock;
import lysis.builder.structure.WhileLoop;
import lysis.instructions.LConstant;
import lysis.instructions.LInstruction;
import lysis.instructions.Opcode;
import lysis.lstructure.LBlock;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeGraph;
import lysis.nodes.NodeType;
import lysis.nodes.types.DJump;
import lysis.nodes.types.DJumpCondition;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DStore;
import lysis.nodes.types.DSwitch;
import lysis.sourcepawn.SPOpcode;

public class SourceStructureBuilder {
    private NodeGraph graph_;
    private Stack<NodeBlock> joinStack_ = new Stack();

    public SourceStructureBuilder(NodeGraph graph) {
        this.graph_ = graph;
    }

    private void pushScope(NodeBlock block) {
        this.joinStack_.push(block);
    }

    private NodeBlock popScope() {
        return this.joinStack_.pop();
    }

    private boolean isJoin(NodeBlock block) {
        for (int i = this.joinStack_.size() - 1; i >= 0; --i) {
            if (this.joinStack_.elementAt(i) != block) continue;
            return true;
        }
        return false;
    }

    private static boolean HasSharedTarget(NodeBlock pred, DJumpCondition jcc) {
        NodeBlock trueTarget = BlockAnalysis.EffectiveTarget(jcc.trueTarget());
        if (trueTarget.lir().numPredecessors() == 1) {
            return false;
        }
        if (trueTarget.lir().loop() != null && trueTarget.lir().loop().backedge() == trueTarget.lir()) {
            return false;
        }
        if (pred.lir().idominated().length > 3) {
            return true;
        }
        return trueTarget.lir().instructions().length == 2 && trueTarget.lir().instructions()[0].op() == Opcode.Constant && trueTarget.lir().instructions()[1].op() == Opcode.Jump;
    }

    private static LogicOperator ToLogicOp(DJumpCondition jcc) {
        NodeBlock trueTarget = BlockAnalysis.ConstantSettingTarget(jcc.trueTarget());
        LConstant constant = (LConstant)trueTarget.lir().instructions()[0];
        boolean targetIsTruthy = constant.val() == 1L;
        LogicOperator logicop = jcc.spop() == SPOpcode.jnz && targetIsTruthy ? LogicOperator.Or : LogicOperator.And;
        return logicop;
    }

    private static NodeBlock SingleTarget(NodeBlock block) {
        DJump jump = (DJump)block.nodes().last();
        return jump.target();
    }

    private static void AssertInnerJoinValidity(NodeBlock join, NodeBlock earlyExit) {
        DJumpCondition jcc = (DJumpCondition)join.nodes().last();
        assert (BlockAnalysis.EffectiveTarget(jcc.trueTarget()) == earlyExit || join == SourceStructureBuilder.SingleTarget(earlyExit));
    }

    /*
     * Unable to fully structure code
     */
    private LinkedList<Object> buildLogicChain(NodeBlock block, NodeBlock earlyExitStop, NodeBlock join) {
        retValue = new LinkedList<Object>();
        retValue.add(null);
        retValue.add(null);
        jcc = (DJumpCondition)block.nodes().last();
        chain = new LogicChain(SourceStructureBuilder.ToLogicOp(jcc));
        earlyExit = BlockAnalysis.EffectiveTarget(jcc.trueTarget());
        exprBlock = block;
        block0: while (true) {
            if (BlockAnalysis.EffectiveTarget((childJcc = (DJumpCondition)exprBlock.nodes().last()).trueTarget()) != earlyExit) {
                innerJoin = null;
                listRet = this.buildLogicChain(exprBlock, earlyExit, innerJoin);
                rhs = (LogicChain)listRet.get(1);
                innerJoin = (NodeBlock)listRet.get(0);
                SourceStructureBuilder.AssertInnerJoinValidity(innerJoin, earlyExit);
                chain.append(rhs);
                exprBlock = innerJoin;
                childJcc = (DJumpCondition)exprBlock.nodes().last();
            } else {
                chain.append(childJcc.getOperand(0));
            }
            if ((exprBlock = childJcc.falseTarget()).nodes().last().type() == NodeType.JumpCondition) continue;
            while (true) {
                if (!SourceStructureBuilder.$assertionsDisabled && exprBlock.lir().instructions()[0].op() != Opcode.Constant) {
                    throw new AssertionError();
                }
                condBlock = SourceStructureBuilder.SingleTarget(exprBlock);
                retValue.set(0, condBlock);
                if (earlyExitStop != null && SourceStructureBuilder.SingleTarget(earlyExitStop) == condBlock) {
                    retValue.set(1, chain);
                    return retValue;
                }
                if (condBlock.lir().instructions()[0].op() == Opcode.Jump && earlyExit == SourceStructureBuilder.SingleTarget(condBlock)) {
                    retValue.set(1, chain);
                    return retValue;
                }
                if (condBlock.nodes().first().type() == NodeType.Store) {
                    retValue.set(1, chain);
                    return retValue;
                }
                if (condBlock.nodes().last().type() == NodeType.Return) {
                    retValue.set(1, chain);
                    return retValue;
                }
                if (condBlock.nodes().last().type() == NodeType.Jump && BlockAnalysis.EffectiveTarget(condBlock) == earlyExit) {
                    retValue.set(1, chain);
                    return retValue;
                }
                if (condBlock.nodes().last().type() == NodeType.Jump && condBlock.lir().loop() != null && BlockAnalysis.GetSingleTarget(condBlock).lir() == condBlock.lir().loop()) {
                    retValue.set(1, chain);
                    return retValue;
                }
                condJcc = (DJumpCondition)condBlock.nodes().last();
                if (BlockAnalysis.EffectiveTarget(condJcc.trueTarget()) == earlyExitStop) {
                    retValue.set(1, chain);
                    return retValue;
                }
                if (!SourceStructureBuilder.HasSharedTarget(condBlock, condJcc)) {
                    retValue.set(1, chain);
                    return retValue;
                }
                earlyExit = BlockAnalysis.EffectiveTarget(condJcc.trueTarget());
                if (earlyExit.lir().instructions()[0].op() != Opcode.Constant) {
                    retValue.set(1, chain);
                    return retValue;
                }
                innerJoin = null;
                listRet = this.buildLogicChain(condJcc.falseTarget(), earlyExit, innerJoin);
                rhs = (LogicChain)listRet.get(1);
                innerJoin = (NodeBlock)listRet.get(0);
                root = new LogicChain(SourceStructureBuilder.ToLogicOp(condJcc));
                root.append(chain);
                root.append(rhs);
                chain = root;
                if (innerJoin.nodes().last().type() == NodeType.Return) {
                    retValue.set(0, innerJoin);
                    retValue.set(1, chain);
                    return retValue;
                }
                SourceStructureBuilder.AssertInnerJoinValidity(innerJoin, earlyExit);
                innerJcc = (DJumpCondition)innerJoin.nodes().last();
                if (innerJcc.falseTarget().nodes().last().type() == NodeType.JumpCondition) {
                    exprBlock = innerJcc.falseTarget();
                    childJcc = (DJumpCondition)exprBlock.nodes().last();
                    exit = BlockAnalysis.EffectiveTarget(childJcc.trueTarget());
                    if (exit.lir().instructions()[0].op() != Opcode.Constant) ** break;
                    continue block0;
                    retValue.set(0, innerJoin);
                    retValue.set(1, chain);
                    return retValue;
                }
                exprBlock = earlyExit;
            }
            break;
        }
    }

    private NodeBlock findJoinOfSimpleIf(NodeBlock block, DJumpCondition jcc) {
        assert (block.nodes().last() == jcc);
        assert (block.lir().idominated()[0] == jcc.falseTarget().lir() || block.lir().idominated()[0] == jcc.trueTarget().lir());
        assert (block.lir().idominated()[1] == jcc.falseTarget().lir() || block.lir().idominated()[1] == jcc.trueTarget().lir());
        if (block.lir().idominated().length == 2) {
            NodeBlock trueTarget = BlockAnalysis.EffectiveTargetNoLoop(jcc.trueTarget());
            if (trueTarget != null && jcc.trueTarget() != trueTarget) {
                return jcc.trueTarget();
            }
            NodeBlock falseTarget = BlockAnalysis.EffectiveTargetNoLoop(jcc.falseTarget());
            if (falseTarget != null && jcc.falseTarget() != falseTarget) {
                return jcc.falseTarget();
            }
            return null;
        }
        return this.graph_.blocks(block.lir().idominated()[2].id());
    }

    private ControlBlock traverseComplexIf(NodeBlock block, DJumpCondition jcc) {
        NodeBlock join = null;
        LinkedList<Object> listRet = this.buildLogicChain(block, null, join);
        LogicChain chain = (LogicChain)listRet.get(1);
        join = (NodeBlock)listRet.get(0);
        if (join.nodes().last().type() == NodeType.Jump) {
            return new IfBlock(block, false, chain, null, null, null);
        }
        if (join.nodes().first().type() == NodeType.Store) {
            DStore store_ = (DStore)join.nodes().first();
            store_.setLogicChain(chain);
            return new StatementBlock(block, this.traverseBlock(this.graph_.blocks(join.lir().id())));
        }
        if (join.nodes().last().type() == NodeType.Return) {
            return new ReturnBlock(block, chain);
        }
        DJumpCondition finalJcc = (DJumpCondition)join.nodes().last();
        assert (finalJcc.spop() == SPOpcode.jzer);
        NodeBlock joinBlock = this.findJoinOfSimpleIf(join, finalJcc);
        NodeBlock trueBlock = finalJcc.falseTarget();
        NodeBlock falseBlock = finalJcc.trueTarget();
        if (joinBlock == null) {
            joinBlock = falseBlock;
        }
        if (falseBlock == joinBlock) {
            falseBlock = null;
        }
        boolean invert = false;
        if (trueBlock == joinBlock) {
            trueBlock = falseBlock;
            falseBlock = null;
            invert ^= true;
        }
        if (join.lir().idominated().length == 2 || BlockAnalysis.EffectiveTarget(falseBlock) == joinBlock) {
            if (join.lir().idominated().length == 3) {
                joinBlock = BlockAnalysis.EffectiveTarget(falseBlock);
            }
            this.pushScope(joinBlock);
            ControlBlock trueArm1 = this.traverseBlock(trueBlock);
            this.popScope();
            ControlBlock joinArm1 = this.traverseJoin(joinBlock);
            return new IfBlock(block, invert, chain, trueArm1, joinArm1);
        }
        this.pushScope(joinBlock);
        ControlBlock trueArm2 = this.traverseBlock(trueBlock);
        ControlBlock falseArm = this.traverseBlock(falseBlock);
        this.popScope();
        ControlBlock joinArm2 = this.traverseJoin(joinBlock);
        return new IfBlock(block, invert, chain, trueArm2, falseArm, joinArm2);
    }

    private ControlBlock traverseIf(NodeBlock block, DJumpCondition jcc) {
        if (SourceStructureBuilder.HasSharedTarget(block, jcc)) {
            return this.traverseComplexIf(block, jcc);
        }
        NodeBlock trueTarget = jcc.spop() == SPOpcode.jzer ? jcc.falseTarget() : jcc.trueTarget();
        NodeBlock falseTarget = jcc.spop() == SPOpcode.jzer ? jcc.trueTarget() : jcc.falseTarget();
        NodeBlock joinTarget = this.findJoinOfSimpleIf(block, jcc);
        if (joinTarget == null) {
            joinTarget = falseTarget;
        }
        if (falseTarget == joinTarget || BlockAnalysis.EffectiveTargetNoLoop(falseTarget) == joinTarget) {
            falseTarget = null;
        }
        boolean invert = false;
        if (trueTarget == joinTarget || BlockAnalysis.EffectiveTargetNoLoop(trueTarget) == joinTarget) {
            trueTarget = falseTarget;
            falseTarget = null;
            invert ^= true;
        }
        if (BlockAnalysis.EffectiveTargetNoLoop(trueTarget) == null) {
            trueTarget = null;
        }
        if (BlockAnalysis.EffectiveTargetNoLoop(joinTarget) == null) {
            trueTarget = joinTarget;
            joinTarget = null;
            invert ^= true;
        }
        ControlBlock trueArm = null;
        if (trueTarget != null) {
            this.pushScope(joinTarget);
            trueArm = this.traverseBlock(trueTarget);
            this.popScope();
        }
        ControlBlock joinArm = this.traverseJoin(joinTarget);
        if (falseTarget == null) {
            return new IfBlock(block, invert, trueArm, joinArm);
        }
        this.pushScope(joinTarget);
        ControlBlock falseArm = this.traverseBlock(falseTarget);
        this.popScope();
        return new IfBlock(block, invert, trueArm, falseArm, joinArm);
    }

    private LinkedList<Object> findLoopJoinAndBody(NodeBlock header, NodeBlock effectiveHeader) {
        assert (effectiveHeader.lir().numSuccessors() >= 1);
        LinkedList<Object> retList = new LinkedList<Object>();
        retList.add(null);
        retList.add(null);
        retList.add(null);
        retList.add(null);
        LBlock succ1 = effectiveHeader.lir().getSuccessor(0);
        LBlock succ2 = null;
        if (effectiveHeader.lir().numSuccessors() == 2) {
            succ2 = effectiveHeader.lir().getSuccessor(1);
        }
        if (succ1.loop() == header.lir() && succ2 == null || succ2 != null && (succ1.loop() != header.lir() || succ2.loop() != header.lir())) {
            assert (succ1.loop() == header.lir() || succ2 != null && succ2.loop() == header.lir());
            if (succ1.loop() != header.lir()) {
                retList.set(1, this.graph_.blocks(succ1.id()));
                retList.set(2, succ2 != null ? this.graph_.blocks(succ2.id()) : null);
            } else {
                retList.set(1, succ2 != null ? this.graph_.blocks(succ2.id()) : null);
                retList.set(2, this.graph_.blocks(succ1.id()));
            }
            retList.set(3, header);
            if (header == effectiveHeader && BlockAnalysis.GetEmptyTarget((NodeBlock)retList.get(2)) == header) {
                retList.set(2, null);
                retList.set(0, (Object)ControlType.DoWhileLoop);
                return retList;
            }
            retList.set(0, (Object)ControlType.WhileLoop);
            return retList;
        }
        LBlock backedge = header.lir().backedge();
        if (BlockAnalysis.GetEmptyTarget(this.graph_.blocks(backedge.id())) == header) {
            assert (backedge.numPredecessors() == 1);
            backedge = backedge.getPredecessor(0);
        }
        assert (backedge.numSuccessors() == 1 || backedge.numSuccessors() == 2);
        succ1 = backedge.getSuccessor(0);
        succ2 = backedge.numSuccessors() > 1 ? backedge.getSuccessor(1) : null;
        retList.set(2, header);
        retList.set(3, this.graph_.blocks(backedge.id()));
        if (succ1.loop() != header.lir()) {
            retList.set(1, this.graph_.blocks(succ1.id()));
        } else if (succ2 != null) {
            assert (succ2.loop() != header.lir());
            retList.set(1, this.graph_.blocks(succ2.id()));
        } else {
            retList.set(1, null);
        }
        retList.set(0, (Object)ControlType.DoWhileLoop);
        return retList;
    }

    private ControlBlock traverseLoop(NodeBlock block) {
        DJumpCondition jcc;
        DNode last = block.nodes().last();
        NodeBlock effectiveHeader = block;
        LogicChain chain = null;
        if (last.type() == NodeType.JumpCondition && SourceStructureBuilder.HasSharedTarget(block, jcc = (DJumpCondition)last)) {
            LinkedList<Object> listRet = this.buildLogicChain(block, null, effectiveHeader);
            chain = (LogicChain)listRet.get(1);
            effectiveHeader = (NodeBlock)listRet.get(0);
        }
        if ((last = effectiveHeader.nodes().last()).type() == NodeType.Switch) {
            SwitchBlock switchBlock = (SwitchBlock)this.traverseSwitch(block, (DSwitch)last);
            return new WhileLoop(ControlType.DoWhileLoop, effectiveHeader, (ControlBlock)switchBlock, null);
        }
        assert (last.type() == NodeType.JumpCondition || last.type() == NodeType.Jump);
        if (last.type() == NodeType.JumpCondition || last.type() == NodeType.Jump) {
            assert (BlockAnalysis.GetSingleTarget(this.graph_.blocks(block.lir().backedge().id())) == block);
            LinkedList<Object> byValueWorkaround = this.findLoopJoinAndBody(block, effectiveHeader);
            ControlType type = (ControlType)((Object)byValueWorkaround.get(0));
            NodeBlock join = (NodeBlock)byValueWorkaround.get(1);
            NodeBlock body = (NodeBlock)byValueWorkaround.get(2);
            NodeBlock cond = (NodeBlock)byValueWorkaround.get(3);
            ControlBlock joinArm = null;
            if (join != null) {
                this.pushScope(block);
                this.pushScope(cond);
                joinArm = this.traverseJoin(join);
                this.popScope();
                this.popScope();
            }
            ControlBlock bodyArm = null;
            if (body != null) {
                this.pushScope(block);
                this.pushScope(cond);
                bodyArm = this.traverseBlockNoLoop(body);
                this.popScope();
                this.popScope();
            }
            if (chain != null && type != ControlType.DoWhileLoop) {
                return new WhileLoop(type, chain, bodyArm, joinArm);
            }
            return new WhileLoop(type, cond, bodyArm, joinArm);
        }
        return null;
    }

    private ControlBlock traverseSwitch(NodeBlock block, DSwitch switch_) {
        int i;
        LinkedList<LBlock> dominators = new LinkedList<LBlock>();
        for (i = 0; i < block.lir().idominated().length; ++i) {
            dominators.add(block.lir().idominated()[i]);
        }
        dominators.remove(switch_.defaultCase());
        for (i = 0; i < switch_.numCases(); ++i) {
            dominators.remove(switch_.getCase((int)i).target);
        }
        NodeBlock join = null;
        if (dominators.size() > 0) {
            assert (dominators.size() == 1);
            join = this.graph_.blocks(((LBlock)dominators.get(dominators.size() - 1)).id());
        }
        ControlBlock joinArm = null;
        if (join != null && BlockAnalysis.EffectiveTarget(join).lir().id() > block.lir().id()) {
            joinArm = this.traverseJoin(join);
        }
        this.pushScope(block);
        this.pushScope(join);
        LinkedList<SwitchBlock.Case> cases = new LinkedList<SwitchBlock.Case>();
        NodeBlock defaultBlock = this.graph_.blocks(switch_.defaultCase().id());
        ControlBlock defaultArm = null;
        if (!this.isJoin(defaultBlock)) {
            defaultArm = this.traverseBlock(defaultBlock);
        }
        this.pushScope(defaultBlock);
        for (int i2 = 0; i2 < switch_.numCases(); ++i2) {
            ControlBlock arm = this.traverseBlock(this.graph_.blocks(switch_.getCase((int)i2).target.id()));
            cases.add(new SwitchBlock.Case(switch_.getCase(i2).values(), arm));
        }
        this.popScope();
        this.popScope();
        this.popScope();
        return new SwitchBlock(block, defaultArm, cases, joinArm);
    }

    private ControlBlock traverseJoin(NodeBlock block) {
        if (this.isJoin(block)) {
            return null;
        }
        return this.traverseBlock(block);
    }

    private ControlBlock traverseBlockNoLoop(NodeBlock block) {
        DNode last = block.nodes().last();
        if (last.type() == NodeType.JumpCondition) {
            return this.traverseIf(block, (DJumpCondition)last);
        }
        if (last.type() == NodeType.Jump) {
            LInstruction[] ins;
            DJump jump = (DJump)last;
            NodeBlock target = jump.target();
            if (target.nodes().first().type() == NodeType.Label && (ins = block.lir().instructions())[ins.length - 1].op() == Opcode.Jump) {
                return new GotoBlock(block, target);
            }
            ControlBlock next = null;
            if (!this.isJoin(target)) {
                next = this.traverseBlock(target);
            }
            return new StatementBlock(block, next);
        }
        if (last.type() == NodeType.Switch) {
            return this.traverseSwitch(block, (DSwitch)last);
        }
        assert (last.type() == NodeType.Return);
        return new ReturnBlock(block);
    }

    private ControlBlock traverseBlock(NodeBlock block) {
        if (block.lir().backedge() != null) {
            return this.traverseLoop(block);
        }
        return this.traverseBlockNoLoop(block);
    }

    public ControlBlock build() {
        return this.traverseBlock(this.graph_.blocks(0));
    }
}

