/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes;

import java.util.LinkedList;
import lysis.lstructure.Register;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DGenArray;
import lysis.nodes.types.DNode;

public class AbstractStack {
    private LinkedList<StackEntry> stack_ = new LinkedList();
    private StackEntry[] args_;
    private DNode pri_;
    private DNode alt_;

    public AbstractStack(int nargs) {
        this.args_ = new StackEntry[nargs];
        for (int i = 0; i < this.args_.length; ++i) {
            this.args_[i] = new StackEntry(null, null);
        }
    }

    public AbstractStack(AbstractStack other) {
        int i;
        for (i = 0; i < other.stack_.size(); ++i) {
            this.stack_.add(new StackEntry(other.stack_.get((int)i).declaration, other.stack_.get((int)i).assignment));
        }
        this.args_ = new StackEntry[other.args_.length];
        for (i = 0; i < this.args_.length; ++i) {
            this.args_[i] = new StackEntry(other.args_[i].declaration, other.args_[i].assignment);
        }
        this.pri_ = other.pri_;
        this.alt_ = other.alt_;
    }

    public void push(DDeclareLocal local) {
        this.stack_.add(new StackEntry(local, local.value()));
        local.setOffset(this.depth());
    }

    public void push(DGenArray array) {
        this.stack_.add(new StackEntry(array, null));
        array.setOffset(this.depth());
    }

    private StackEntry popEntry() throws UnbalancedStackException {
        if (this.stack_.size() == 0) {
            throw new UnbalancedStackException();
        }
        StackEntry e = this.stack_.get(this.stack_.size() - 1);
        this.stack_.remove(this.stack_.size() - 1);
        return e;
    }

    public void pop() throws UnbalancedStackException {
        this.popEntry();
    }

    public DNode popAsTemp() throws UnbalancedStackException {
        StackEntry entry = this.popEntry();
        if (entry.declaration.uses().size() == 0) {
            return entry.assignment;
        }
        assert (false);
        return null;
    }

    public DNode popName() throws UnbalancedStackException {
        DNode value = this.stack_.get((int)(this.stack_.size() - 1)).declaration;
        this.pop();
        return value;
    }

    public DNode popValue() throws UnbalancedStackException {
        DNode value = this.stack_.get((int)(this.stack_.size() - 1)).assignment;
        this.pop();
        return value;
    }

    public DNode peekName() {
        DNode value = this.stack_.get((int)(this.stack_.size() - 1)).declaration;
        return value;
    }

    private StackEntry entry(long offset) {
        if (offset < 0L) {
            return this.stack_.get((int)(-offset / 4L - 1L));
        }
        int argidx = (int)((offset - 12L) / 4L);
        if (argidx < 0 || argidx >= this.args_.length) {
            return new StackEntry(null, null);
        }
        return this.args_[argidx];
    }

    public DNode getName(long offset) {
        return this.entry((long)offset).declaration;
    }

    public int nargs() {
        return this.args_.length;
    }

    public int depth() {
        return -(this.stack_.size() * 4);
    }

    public DNode pri() {
        return this.pri_;
    }

    public DNode alt() {
        return this.alt_;
    }

    public DNode reg(Register reg) {
        return reg == Register.Pri ? this.pri_ : this.alt_;
    }

    public void set(Register reg, DNode node) {
        if (reg == Register.Pri) {
            this.pri_ = node;
        } else {
            this.alt_ = node;
        }
    }

    public void set(long offset, DNode value) {
        this.entry((long)offset).assignment = value;
    }

    public void init(long offset, DDeclareLocal local) {
        this.entry((long)offset).declaration = local;
        this.entry((long)offset).assignment = null;
    }

    private class StackEntry {
        public DNode declaration;
        public DNode assignment;

        public StackEntry(DNode decl, DNode assn) {
            this.declaration = decl;
            this.assignment = assn;
        }
    }

    public class UnbalancedStackException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

