/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes;

import lysis.nodes.NodeType;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DSentinel;

public class NodeList {
    private DNode head_ = new DSentinel();

    public NodeList() {
        this.head_.prevSet(this.head_);
        this.head_.nextSet(this.head_);
    }

    public void insertBefore(DNode at, DNode node) {
        node.nextSet(at);
        node.prevSet(at.prev());
        at.prev().nextSet(node);
        at.prevSet(node);
    }

    public void insertAfter(DNode at, DNode node) {
        node.nextSet(at);
        node.prevSet(at.prev());
        at.prev().nextSet(node);
        at.prevSet(node);
    }

    public void add(DNode node) {
        this.insertBefore(this.head_, node);
    }

    public iterator begin() {
        return new iterator(this.head_.next());
    }

    public reverse_iterator rbegin() {
        return new reverse_iterator(this.head_.prev());
    }

    public void remove(iterator_base where) {
        DNode node = where.node();
        where.next();
        this.remove(node);
    }

    public void remove(DNode node) {
        node.prev().nextSet(node.next());
        node.next().prevSet(node.prev());
        node.nextSet(null);
        node.prevSet(null);
    }

    public void replace(DNode at, DNode with) {
        with.prevSet(at.prev());
        with.nextSet(at.next());
        at.prev().nextSet(with);
        at.next().prevSet(with);
        at.prevSet(null);
        at.nextSet(null);
    }

    public void replace(iterator_base where, DNode with) {
        this.replace(where.node(), with);
        where.nodeSet(with);
    }

    public DNode last() {
        return this.head_.prev();
    }

    public DNode first() {
        return this.head_.next();
    }

    public class reverse_iterator
    extends iterator_base {
        public reverse_iterator(DNode node) {
            super(node);
        }

        @Override
        public void next() {
            this.node_ = this.node_.prev();
        }
    }

    public class iterator
    extends iterator_base {
        public iterator(DNode node) {
            super(node);
        }

        @Override
        public void next() {
            this.node_ = this.node_.next();
        }
    }

    public abstract class iterator_base {
        protected DNode node_;

        public iterator_base(DNode node) {
            this.node_ = node;
        }

        public boolean more() {
            return this.node_.type() != NodeType.Sentinel;
        }

        public abstract void next();

        public DNode node() {
            return this.node_;
        }

        public DNode nodeSet(DNode value) {
            this.node_ = value;
            return this.node_;
        }
    }
}

