/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes;

import lysis.nodes.NodeBlock;
import lysis.nodes.NodeGraph;
import lysis.nodes.NodeList;
import lysis.nodes.NodeType;
import lysis.nodes.types.DBinary;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DTempName;
import lysis.nodes.types.DUse;
import lysis.sourcepawn.SPOpcode;

public class NodeRenamer {
    private NodeGraph graph_;

    private void renameBlock(NodeBlock block) throws Exception {
        NodeList.iterator iter = block.nodes().begin();
        block16: while (iter.more()) {
            DNode node = iter.node();
            switch (node.type()) {
                case TempName: 
                case Jump: 
                case JumpCondition: 
                case Store: 
                case Return: 
                case IncDec: 
                case DeclareStatic: 
                case Switch: 
                case GenArray: 
                case Label: {
                    iter.next();
                    continue block16;
                }
                case DeclareLocal: {
                    DDeclareLocal decl = (DDeclareLocal)node;
                    if (decl.var() == null) {
                        if (decl.uses().size() <= 1) {
                            if (decl.uses().size() == 1) {
                                DUse use = decl.uses().getFirst();
                                use.node().replaceOperand(use.index(), decl.value());
                            }
                            block.nodes().remove(iter);
                            continue block16;
                        }
                        DTempName name = new DTempName(this.graph_.tempName());
                        node.replaceAllUsesWith(name);
                        name.init(decl.value());
                        block.nodes().replace(iter, (DNode)name);
                    }
                    iter.next();
                    continue block16;
                }
                case SysReq: 
                case Call: {
                    if (node.uses().size() > 1) break;
                    if (node.uses().size() == 1) {
                        block.nodes().remove(iter);
                        continue block16;
                    }
                    iter.next();
                    continue block16;
                }
                case Constant: {
                    block.nodes().remove(iter);
                    continue block16;
                }
                default: {
                    if (node.uses().size() > 1) break;
                    block.nodes().remove(iter);
                    continue block16;
                }
            }
            if (node.uses().size() == 2) {
                DBinary connector;
                DUse firstUse = node.uses().get(0);
                DUse secondUse = node.uses().get(1);
                if (firstUse.node().type() == NodeType.Store && (secondUse.node().type() == NodeType.Binary || secondUse.node().type() == NodeType.JumpCondition)) {
                    secondUse.node().replaceOperand(secondUse.index(), firstUse.node());
                    block.nodes().remove(firstUse.node());
                    block.nodes().remove(iter);
                    continue;
                }
                if (firstUse.node().type() == NodeType.Binary && secondUse.node().type() == NodeType.Binary && firstUse.node().uses().size() == 1 && secondUse.node().uses().size() == 1 && firstUse.node().uses().get(0).node() == secondUse.node().uses().get(0).node() && firstUse.node().uses().get(0).node().type() == NodeType.Binary && (connector = (DBinary)firstUse.node().uses().get(0).node()).spop() == SPOpcode.and) {
                    assert (firstUse.index() == 1);
                    DBinary leftSide = (DBinary)connector.rhs();
                    DBinary rightSide = (DBinary)connector.lhs();
                    leftSide.replaceOperand(1, rightSide);
                    if (secondUse.index() == 1) {
                        SPOpcode invertedOP = rightSide.spop();
                        switch (rightSide.spop()) {
                            case jsleq: {
                                invertedOP = SPOpcode.jsgeq;
                                break;
                            }
                            case jsless: {
                                invertedOP = SPOpcode.jsgrtr;
                                break;
                            }
                            case jsgrtr: {
                                invertedOP = SPOpcode.jsless;
                                break;
                            }
                            case jsgeq: {
                                invertedOP = SPOpcode.jsleq;
                                break;
                            }
                            case sleq: {
                                invertedOP = SPOpcode.sgeq;
                                break;
                            }
                            case sless: {
                                invertedOP = SPOpcode.sgrtr;
                                break;
                            }
                            case sgrtr: {
                                invertedOP = SPOpcode.sless;
                                break;
                            }
                            case sgeq: {
                                invertedOP = SPOpcode.sleq;
                                break;
                            }
                        }
                        DBinary rightInverted = new DBinary(invertedOP, rightSide.rhs(), rightSide.lhs());
                        rightSide.replaceAllUsesWith(rightInverted);
                        rightSide.removeFromUseChains();
                    }
                    connector.replaceAllUsesWith(leftSide);
                    connector.removeFromUseChains();
                    block.nodes().remove(rightSide);
                    block.nodes().remove(connector);
                    block.nodes().remove(iter);
                    continue;
                }
            }
            DTempName replacement = new DTempName(this.graph_.tempName());
            node.replaceAllUsesWith(replacement);
            replacement.init(node);
            block.nodes().replace(iter, (DNode)replacement);
            iter.next();
        }
    }

    public NodeRenamer(NodeGraph graph) {
        this.graph_ = graph;
    }

    public void rename() throws Exception {
        for (int i = 0; i < this.graph_.numBlocks(); ++i) {
            this.renameBlock(this.graph_.blocks(i));
        }
    }
}

