/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes.types;

import lysis.lstructure.Scope;
import lysis.lstructure.Tag;
import lysis.lstructure.Variable;
import lysis.lstructure.VariableType;
import lysis.nodes.NodeType;
import lysis.nodes.NodeVisitor;
import lysis.nodes.types.DGlobal;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DNullaryNode;
import lysis.nodes.types.DString;
import lysis.sourcepawn.SourcePawnFile;

public class DConstant
extends DNullaryNode {
    private long value_;
    private long pc_;

    public DConstant(long value) {
        this.value_ = value;
    }

    public DConstant(long value, long pc) {
        this.value_ = value;
        this.pc_ = pc;
    }

    public long value() {
        if (this.usedAsArrayIndex()) {
            return this.value_ / 4L;
        }
        return this.value_;
    }

    public long pc() {
        return this.pc_;
    }

    @Override
    public NodeType type() {
        return NodeType.Constant;
    }

    @Override
    public void accept(NodeVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    @Override
    public DNode applyType(SourcePawnFile file, Tag tag, VariableType type) {
        switch (type) {
            case Array: 
            case ArrayReference: 
            case Reference: 
            case Variadic: {
                Variable global = file.lookupGlobal(this.value());
                if (global == null) {
                    global = file.lookupVariable(this.pc(), this.value(), Scope.Static);
                }
                if (global != null) {
                    return new DGlobal(global);
                }
                if (!tag.isString()) break;
                return new DString(file.stringFromData(this.value()));
            }
        }
        return this;
    }
}

