/*
 * Decompiled with CFR 0.152.
 */
package lysis.nodes.types;

import lysis.nodes.NodeBlock;
import lysis.nodes.NodeType;
import lysis.nodes.NodeVisitor;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DUnaryNode;
import lysis.sourcepawn.SPOpcode;

public class DJumpCondition
extends DUnaryNode {
    private SPOpcode spop_;
    private NodeBlock trueTarget_;
    private NodeBlock falseTarget_;
    private NodeBlock joinTarget_;

    public DJumpCondition(SPOpcode spop, DNode node, NodeBlock lht, NodeBlock rht) throws Exception {
        super(node);
        this.spop_ = spop;
        this.trueTarget_ = lht;
        this.falseTarget_ = rht;
    }

    public void rewrite(SPOpcode spop, DNode node) throws Exception {
        this.spop_ = spop;
        this.replaceOperand(0, node);
    }

    public SPOpcode spop() {
        return this.spop_;
    }

    public NodeBlock trueTarget() {
        return this.trueTarget_;
    }

    public NodeBlock falseTarget() {
        return this.falseTarget_;
    }

    @Override
    public NodeType type() {
        return NodeType.JumpCondition;
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean idempotent() {
        return false;
    }

    @Override
    public boolean controlFlow() {
        return true;
    }

    public NodeBlock joinTarget() {
        return this.joinTarget_;
    }

    public void setTrueTarget(NodeBlock block) {
        this.trueTarget_ = block;
    }

    public void setFalseTarget(NodeBlock block) {
        this.falseTarget_ = block;
    }

    public void setJoinTarget(NodeBlock block) {
        this.joinTarget_ = block;
    }

    public void setConditional(SPOpcode op) {
        this.spop_ = op;
    }
}

