/*
 * Decompiled with CFR 0.152.
 */
package lysis.sourcepawn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Inflater;
import lysis.BitConverter;
import lysis.ExtendedDataInputStream;
import lysis.PawnFile;
import lysis.Public;
import lysis.Similarity;
import lysis.lstructure.Argument;
import lysis.lstructure.Dimension;
import lysis.lstructure.Function;
import lysis.lstructure.Native;
import lysis.lstructure.Scope;
import lysis.lstructure.Tag;
import lysis.lstructure.Variable;
import lysis.lstructure.VariableType;
import lysis.types.rtti.RttiType;
import lysis.types.rtti.TypeBuilder;

public class SourcePawnFile
extends PawnFile {
    public static final long MAGIC = 1397769798L;
    private static final byte IDENT_VARIABLE = 1;
    private static final byte IDENT_REFERENCE = 2;
    private static final byte IDENT_ARRAY = 3;
    private static final byte IDENT_REFARRAY = 4;
    private static final byte IDENT_FUNCTION = 9;
    private static final byte IDENT_VARARGS = 11;
    private static final byte DIMEN_MAX = 4;
    private static final byte SP_MAX_EXEC_PARAMS = 32;
    private Header header_ = new Header();
    public static boolean debugUnpacked_;
    private HashMap<String, Section> sections_;
    private HashSet<AddressRange> stringRanges_ = new HashSet<E>();
    private byte[] binary_ = null;
    private String[] enums_ = null;
    private Pattern publicOperator = Pattern.compile("^\\.\\d+\\.(\\d+)(.)(\\d+)$");
    private Pattern symbolsOperator = Pattern.compile("^operator(.)\\(([^:]+):,([^:]+):\\)$");
    private static final String[] KNOWN_SECTIONS;
    private static final String[] KNOWN_SECTIONS_LEGACY;
    private static final String[] KNOWN_SECTIONS_RTTI;

    private static VariableType FromIdent(byte ident) {
        switch (ident) {
            case 1: {
                return VariableType.Normal;
            }
            case 2: {
                return VariableType.Reference;
            }
            case 3: {
                return VariableType.Array;
            }
            case 4: {
                return VariableType.ArrayReference;
            }
            case 11: {
                return VariableType.Variadic;
            }
        }
        return VariableType.Normal;
    }

    private static String ReadString(byte[] bytes, long offset) {
        long count;
        for (count = offset; count < (long)bytes.length && bytes[(int)count] != 0; ++count) {
        }
        try {
            return new String(bytes, (int)offset, (int)(count - offset), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String ReadStringEx(byte[] bytes, int offset, int maxread) {
        int count;
        int last = count + maxread;
        for (count = offset; count < bytes.length && count <= last && bytes[count] != 0; ++count) {
        }
        try {
            return new String(bytes, offset, count - offset, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public SourcePawnFile(byte[] binary) throws Exception {
        super();
        reader = new ExtendedDataInputStream(new ByteArrayInputStream(binary));
        this.header_.magic = reader.ReadUInt32();
        if (this.header_.magic != 1397769798L) {
            reader.close();
            throw new Exception("bad magic - not SourcePawn file");
        }
        this.header_.version = reader.ReadInt16();
        this.header_.compression = Compression.values()[reader.readByte()];
        this.header_.disksize = (int)reader.ReadUInt32() & -1;
        this.header_.imagesize = (int)reader.ReadUInt32() & -1;
        this.header_.sections = reader.readByte();
        this.header_.stringtab = (int)reader.ReadUInt32() & -1;
        this.header_.dataoffs = (int)reader.ReadUInt32() & -1;
        this.sections_ = new HashMap<K, V>();
        knownSections = new HashSet<String>(Arrays.asList(SourcePawnFile.KNOWN_SECTIONS));
        knownSections.addAll(Arrays.asList(SourcePawnFile.KNOWN_SECTIONS_LEGACY));
        knownSections.addAll(Arrays.asList(SourcePawnFile.KNOWN_SECTIONS_RTTI));
        firstData = 0;
        previousSection = null;
        previousUnknown = false;
        unknownSections = new LinkedList<Section>();
        for (i = 0; i < this.header_.sections; ++i) {
            nameOffset = (int)reader.ReadUInt32();
            dataoffs = (int)reader.ReadUInt32();
            if (i == 0) {
                firstData = dataoffs;
            }
            size = (int)reader.ReadUInt32();
            if (i == this.header_.sections - 1) {
                start = this.header_.stringtab + nameOffset;
                name = SourcePawnFile.ReadStringEx(binary, start, firstData - start - 2);
            } else {
                name = SourcePawnFile.ReadString(binary, this.header_.stringtab + nameOffset);
            }
            if (previousUnknown) {
                recoveredName = "";
                for (offset = this.header_.stringtab + previousSection.nameoffs; offset < binary.length && offset - this.header_.stringtab < nameOffset - 1; ++offset) {
                    recoveredName = binary[offset] == 0 ? recoveredName + "_" : recoveredName + new String(binary, offset, 1, "UTF-8");
                }
                if (!recoveredName.equals(previousSection.name)) {
                    System.err.printf("// Recovered name of previous section as \"%s\".%n", new Object[]{recoveredName});
                }
                previousSection.name = recoveredName;
            }
            if (knownSections.contains(name)) {
                previousUnknown = false;
                knownSections.remove(name);
            } else {
                previousUnknown = true;
                System.err.printf("// Unknown section \"%s\".%n", new Object[]{name});
                if (previousSection != null && nameOffset != (expectedNameOffs = previousSection.nameoffs + previousSection.name.length() + 1)) {
                    System.err.printf("// Expected name to start at %d, but says it starts at %d. Correcting..%n", new Object[]{expectedNameOffs, nameOffset});
                    nameOffset = expectedNameOffs;
                }
            }
            if (previousSection != null && dataoffs != (nextDataOffs = previousSection.dataoffs + previousSection.size)) {
                System.err.printf("// Bad section size for section %s. Trying to repair.%n", new Object[]{previousSection.name});
                previousSection.size = dataoffs - previousSection.dataoffs;
            }
            previousSection = new Section(nameOffset, dataoffs, size, name);
            if (previousUnknown) {
                unknownSections.add(previousSection);
                continue;
            }
            this.sections_.put(name, previousSection);
        }
        reader.close();
        if (this.sections_.containsKey("rtti.data")) {
            knownSections.removeAll(Arrays.asList(SourcePawnFile.KNOWN_SECTIONS_LEGACY));
        } else {
            knownSections.removeAll(Arrays.asList(SourcePawnFile.KNOWN_SECTIONS_RTTI));
        }
        for (String sectionName : knownSections) {
            if (this.header_.version == 257L && sectionName.equals(".dbg.natives") || sectionName.startsWith("rtti.")) continue;
            System.err.printf("// Missing section \"%s\".%n", new Object[]{sectionName});
        }
        if (knownSections.size() == unknownSections.size()) {
            while (knownSections.size() > 0) {
                highestSimilarity = -1.0f;
                bestMatchingName = null;
                bestMatchinSection = null;
                for (String missingSection : knownSections) {
                    for (Section unknownSection : unknownSections) {
                        similarity = Similarity.GetSimilarity(missingSection, unknownSection.name);
                        if (!(similarity > highestSimilarity)) continue;
                        highestSimilarity = similarity;
                        bestMatchingName = missingSection;
                        bestMatchinSection = unknownSection;
                    }
                }
                if ((double)highestSimilarity < 0.3) {
                    System.err.printf("// Can't find good similarity between sections (only coefficient of %f).%n", new Object[]{Float.valueOf(highestSimilarity)});
                    break;
                }
                System.err.printf("// Section \"%s\" is probably (%f) missing section \"%s\".%n", new Object[]{bestMatchinSection.name, Float.valueOf(highestSimilarity), bestMatchingName});
                knownSections.remove(bestMatchingName);
                unknownSections.remove(bestMatchinSection);
                bestMatchinSection.name = bestMatchingName;
                this.sections_.put(bestMatchingName, bestMatchinSection);
            }
        }
        SourcePawnFile.debugUnpacked_ = this.header_.version == 257L && this.sections_.containsKey(".dbg.natives") == false;
        debugStringsSection = this.sections_.get(".dbg.strings");
        if (debugStringsSection == null) {
            debugStringsSection = this.sections_.get(".names");
        }
        switch (4.$SwitchMap$lysis$sourcepawn$SourcePawnFile$Compression[this.header_.compression.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                bits = new byte[this.header_.imagesize];
                for (i = 0; i < this.header_.dataoffs; ++i) {
                    bits[i] = binary[i];
                }
                uncompressedSize = this.header_.imagesize - this.header_.dataoffs;
                compressedSize = this.header_.disksize - this.header_.dataoffs;
                gzip = new Inflater(true);
                gzip.setInput(binary, this.header_.dataoffs + 2, compressedSize - 2);
                actuallyUncompressed = gzip.inflate(bits, this.header_.dataoffs, uncompressedSize);
                if (actuallyUncompressed != uncompressedSize) {
                    System.err.printf("uncompressed size mismatch, bad file? expected %d, got %d\n", new Object[]{uncompressedSize, actuallyUncompressed});
                }
                binary = bits;
                break;
            }
        }
        this.binary_ = binary;
        if (this.sections_.containsKey(".code")) {
            sc = this.sections_.get(".code");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            codesize = br.ReadUInt32();
            cellsize = br.readByte();
            codeversion = br.readByte();
            flags = br.ReadInt16();
            main = br.ReadUInt32();
            codeoffs = br.ReadUInt32();
            codeBytes = SourcePawnFile.Slice(binary, sc.dataoffs + (int)codeoffs, (int)codesize);
            this.code_ = new PawnFile.Code(codeBytes, cellsize, flags, main, codeversion);
            br.close();
        }
        if (this.sections_.containsKey(".data")) {
            sc = this.sections_.get(".data");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            datasize = br.ReadUInt32();
            memsize = br.ReadUInt32();
            dataoffs = br.ReadUInt32();
            dataBytes = SourcePawnFile.Slice(binary, sc.dataoffs + (int)dataoffs, (int)datasize);
            this.data_ = new PawnFile.Data(dataBytes, (int)memsize);
            br.close();
        }
        if (this.sections_.containsKey(".publics")) {
            sc = this.sections_.get(".publics");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            numPublics = sc.size / 8;
            this.publics_ = new Public[numPublics];
            this.functions_ = new Function[numPublics];
            for (i = 0; i < numPublics; ++i) {
                address = br.ReadUInt32();
                nameOffset = br.ReadUInt32();
                name = SourcePawnFile.ReadString(binary, this.sections_.get((Object)".names").dataoffs + (int)nameOffset);
                this.publics_[i] = new Public(name, address);
                this.functions_[i] = new Function(address, address, this.code().bytes().length + 1, name);
            }
            br.close();
        }
        if (this.sections_.containsKey(".pubvars")) {
            sc = this.sections_.get(".pubvars");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            numPubVars = sc.size / 8;
            this.pubvars_ = new PawnFile.PubVar[numPubVars];
            this.globals_ = new Variable[numPubVars];
            for (i = 0; i < numPubVars; ++i) {
                address = br.ReadUInt32();
                nameOffset = br.ReadUInt32();
                name = SourcePawnFile.ReadString(binary, this.sections_.get((Object)".names").dataoffs + (int)nameOffset);
                this.pubvars_[i] = new PawnFile.PubVar(name, address);
                this.globals_[i] = new Variable(address, 0, null, 0L, this.code().bytes().length, VariableType.Normal, Scope.Global, name, null);
            }
            br.close();
            this.collectStructStringRanges();
        }
        if (this.sections_.containsKey(".natives")) {
            sc = this.sections_.get(".natives");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            numNatives = sc.size / 4;
            this.natives_ = new Native[numNatives];
            for (i = 0; i < numNatives; ++i) {
                nameOffset = br.ReadUInt32();
                name = SourcePawnFile.ReadString(binary, this.sections_.get((Object)".names").dataoffs + (int)nameOffset);
                this.natives_[i] = new Native(name, i);
            }
            br.close();
        }
        if (this.sections_.containsKey(".tags")) {
            sc = this.sections_.get(".tags");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            numTags = sc.size / 8;
            this.tags_ = new Tag[numTags];
            for (i = 0; i < numTags; ++i) {
                tag_id = br.ReadUInt32();
                nameOffset = br.ReadUInt32();
                name = SourcePawnFile.ReadString(binary, this.sections_.get((Object)".names").dataoffs + (int)nameOffset);
                this.tags_[i] = new Tag(name, tag_id);
            }
            br.close();
        }
        if (this.sections_.containsKey(".dbg.info")) {
            sc = this.sections_.get(".dbg.info");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            this.debugHeader_.numFiles = (int)br.ReadUInt32();
            this.debugHeader_.numLines = (int)br.ReadUInt32();
            this.debugHeader_.numSyms = (int)br.ReadUInt32();
            br.close();
        }
        if (this.sections_.containsKey(".dbg.files") && this.debugHeader_.numFiles > 0) {
            sc = this.sections_.get(".dbg.files");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            this.debugFiles_ = new PawnFile.DebugFile[this.debugHeader_.numFiles];
            for (i = 0; i < this.debugHeader_.numFiles; ++i) {
                address = br.ReadUInt32();
                nameOffset = br.ReadUInt32();
                name = SourcePawnFile.ReadString(binary, debugStringsSection.dataoffs + (int)nameOffset);
                this.debugFiles_[i] = new PawnFile.DebugFile(name, address);
            }
            br.close();
        }
        if (this.sections_.containsKey(".dbg.lines") && this.debugHeader_.numLines > 0) {
            sc = this.sections_.get(".dbg.lines");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            this.debugLines_ = new PawnFile.DebugLine[this.debugHeader_.numLines];
            for (i = 0; i < this.debugHeader_.numLines; ++i) {
                address = br.ReadUInt32();
                line = br.ReadUInt32();
                this.debugLines_[i] = new PawnFile.DebugLine((int)line, address);
            }
            br.close();
        }
        if (this.sections_.containsKey(".dbg.symbols") && this.debugHeader_.numSyms > 0) {
            sc = this.sections_.get(".dbg.symbols");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            locals = new LinkedList<Variable>();
            globals = new LinkedList<Variable>();
            if (this.globals_ != null) {
                globals.addAll(Arrays.asList(this.globals_));
            }
            functions = new LinkedList<Function>();
            if (this.functions_ != null) {
                functions.addAll(Arrays.asList(this.functions_));
            }
            for (i = 0; i < this.debugHeader_.numSyms; ++i) {
                addr = br.ReadInt32();
                tagid = br.ReadInt16();
                if (SourcePawnFile.debugUnpacked_) {
                    br.skip(2L);
                }
                codestart = br.ReadUInt32();
                codeend = br.ReadUInt32();
                ident = br.readByte();
                vclassByte = br.readByte();
                vclass = Scope.Local;
                if (vclassByte >= 0 && vclassByte < Scope.values().length) {
                    vclass = Scope.values()[vclassByte];
                }
                dimcount = br.ReadInt16();
                nameOffset = br.ReadUInt32();
                name = "";
                if ((long)debugStringsSection.size > nameOffset) {
                    name = SourcePawnFile.ReadString(binary, debugStringsSection.dataoffs + (int)nameOffset);
                }
                if (addr == 0L || codeend == 0L || tagid < 0 || ident < 0 || vclassByte < 0 || vclassByte >= Scope.values().length || dimcount < 0 || dimcount > 4 || nameOffset >= (long)debugStringsSection.size) {
                    System.err.printf("// Error reading .dbg.symbols section. Symbol %d has invalid properties.%n", new Object[]{i});
                    break;
                }
                if (ident == 9) {
                    v0 = tag = tagid >= this.tags_.length ? null : this.tags_[tagid];
                    if (addr != codestart) {
                        System.err.printf("// Error reading .dbg.symbols section. Function %d (%s) has mismatching address and codestart properties (%x != %x).%n", new Object[]{i, name, addr, codestart});
                        break;
                    }
                    func = new Function(addr, codestart, codeend, name, tag);
                    try {
                        this.findDuplicateFunction(name, func, functions);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        break;
                    }
                    functions.add(func);
                    continue;
                }
                type = SourcePawnFile.FromIdent(ident);
                dims = null;
                if (dimcount > 0) {
                    dims = new Dimension[dimcount];
                    for (dim = 0; dim < dimcount; ++dim) {
                        if (SourcePawnFile.debugUnpacked_) {
                            br.skip(2L);
                        }
                        dim_tag = (dim_tagid = br.ReadUInt16()) >= this.tags_.length ? null : this.tags_[dim_tagid];
                        size = br.ReadUInt32();
                        dims[dim] = new Dimension(dim_tagid, dim_tag, (int)size);
                    }
                }
                tag = tagid < 0 || tagid >= this.tags_.length ? null : this.tags_[tagid];
                var = new Variable(addr, tagid, tag, codestart, codeend, type, vclass, name, dims);
                if (vclass == Scope.Global) {
                    existingGlobal = null;
                    for (Variable glob : globals) {
                        if (!name.equals(glob.name())) continue;
                        existingGlobal = glob;
                        break;
                    }
                    if (existingGlobal != null) {
                        if (existingGlobal.address() != addr) {
                            System.err.printf("// Error reading .dbg.symbols section. Duplicate information for symbol \"%s\" with differing address %x from already known address %x.%n", new Object[]{name, addr, existingGlobal.address()});
                            break;
                        }
                        globals.remove(existingGlobal);
                    }
                    globals.add(var);
                    continue;
                }
                locals.add(var);
            }
            br.close();
            block24: for (Object pub : this.publics_) {
                for (Function func : functions) {
                    if (!pub.name().equals(func.name()) && (!pub.name().endsWith(func.name()) || !pub.name().matches("\\.\\d+\\..+"))) continue;
                    continue block24;
                }
                f = new Function(pub.address(), pub.address(), this.code().bytes().length + 1, pub.name());
                functions.add(f);
            }
            block26: for (Object pub : this.pubvars_) {
                for (Variable var : globals) {
                    if (!pub.name().equals(var.name())) continue;
                    continue block26;
                }
                var = new Variable(pub.address(), 0, null, pub.address(), this.code_.bytes().length, VariableType.Normal, Scope.Global, pub.name(), null);
                globals.add(var);
            }
            Collections.sort(globals, new Comparator<Variable>(){

                @Override
                public int compare(Variable var1, Variable var2) {
                    return (int)(var1.address() - var2.address());
                }
            });
            Collections.sort(functions, new Comparator<Function>(){

                @Override
                public int compare(Function fun1, Function fun2) {
                    return (int)(fun1.address() - fun2.address());
                }
            });
            this.variables_ = locals.toArray(new Variable[0]);
            this.globals_ = globals.toArray(new Variable[0]);
            this.functions_ = functions.toArray(new Function[0]);
            for (i = 0; i < this.functions_.length; ++i) {
                fun = this.functions_[i];
                argNum = 0;
                args = new LinkedList<Argument>();
                while ((arg = this.buildArgumentInfo(fun, argNum)) != null) {
                    args.add(arg);
                    ++argNum;
                }
                fun.setArguments(args);
            }
        }
        if (this.sections_.containsKey(".dbg.natives") && this.sections_.get((Object)".dbg.natives").size > 0) {
            sc = this.sections_.get(".dbg.natives");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            nentries = br.ReadUInt32();
            block30: for (i = 0; i < (int)nentries; ++i) {
                index = br.ReadUInt32();
                nameOffset = br.ReadUInt32();
                name = "";
                if ((long)debugStringsSection.size > nameOffset) {
                    name = SourcePawnFile.ReadString(binary, debugStringsSection.dataoffs + (int)nameOffset);
                }
                tagid = br.ReadInt16();
                nargs = br.ReadInt16();
                if (tagid < 0 || nargs < 0 || nargs > 32 || nameOffset >= (long)debugStringsSection.size) {
                    System.err.printf("// Error reading .dbg.natives section. Entry %d has invalid properties.\n", new Object[]{i});
                    break;
                }
                tag = tagid >= this.tags_.length ? null : this.tags_[tagid];
                args = new Argument[nargs];
                for (arg = 0; arg < nargs; ++arg) {
                    ident = br.readByte();
                    arg_tagid = br.ReadInt16();
                    dimcount = br.ReadInt16();
                    argNameOffset = br.ReadUInt32();
                    argName = "";
                    if ((long)debugStringsSection.size > argNameOffset) {
                        argName = SourcePawnFile.ReadString(binary, debugStringsSection.dataoffs + (int)argNameOffset);
                    }
                    if (arg_tagid < 0 || ident < 0 || dimcount < 0 || dimcount > 4 || argNameOffset >= (long)debugStringsSection.size) {
                        System.err.printf("// Error reading .dbg.natives section. Argument %d of entry %d has invalid properties.\n", new Object[]{arg, i});
                        break block30;
                    }
                    argTag = arg_tagid >= this.tags_.length ? null : this.tags_[arg_tagid];
                    type = SourcePawnFile.FromIdent(ident);
                    dims = null;
                    if (dimcount > 0) {
                        dims = new Dimension[dimcount];
                        for (dim = 0; dim < dimcount; ++dim) {
                            dim_tagid = br.ReadUInt16();
                            dim_tag = dim_tagid >= this.tags_.length ? null : this.tags_[dim_tagid];
                            size = br.ReadUInt32();
                            dims[dim] = new Dimension(dim_tagid, dim_tag, (int)size);
                        }
                    }
                    args[arg] = new Argument(type, argName, arg_tagid, argTag, dims);
                }
                if ((int)index >= this.natives_.length) continue;
                if (!this.natives_[(int)index].name().equals("@") && name != null && !name.equals(this.natives_[(int)index].name())) {
                    System.err.printf("// Error reading .dbg.natives section. Native %d has different names. (\"%s\" != \"%s\")\n", new Object[]{index, this.natives_[(int)index].name(), name});
                    break;
                }
                this.natives_[(int)index].setDebugInfo(tagid, tag, args);
            }
            br.close();
        }
        namesOffset = this.sections_.get((Object)".names").dataoffs;
        if (this.sections_.containsKey("rtti.enums")) {
            sc = this.sections_.get("rtti.enums");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            rt = new RttiListTable(br);
            this.enums_ = new String[(int)rt.rowcount];
            i = 0;
            while ((long)i < rt.rowcount) {
                nameoffs = br.ReadUInt32();
                br.skipBytes(12);
                this.enums_[i] = SourcePawnFile.ReadString(binary, (long)namesOffset + nameoffs);
                ++i;
            }
        }
        if (this.sections_.containsKey("rtti.natives")) {
            sc = this.sections_.get("rtti.natives");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            rt = new RttiListTable(br);
            i = 0;
            while ((long)i < rt.rowcount) {
                nameoffs = br.ReadUInt32();
                signatureOffs = br.ReadUInt32();
                name = SourcePawnFile.ReadString(binary, (long)namesOffset + nameoffs);
                type = TypeBuilder.FunctionFromOffset(this, (int)signatureOffs);
                args = new Argument[type.getArguments().size()];
                for (j = 0; j < type.getArguments().size(); ++j) {
                    arg = type.getArguments().get(j);
                    dims = new LinkedList<Dimension>();
                    arrayType = arg;
                    while (arrayType.isArrayType()) {
                        dims.add(0, new Dimension((int)arrayType.getData()));
                        arrayType = arrayType.getInnerType();
                    }
                    args[j] = new Argument(arg.toVariableType(), "_arg" + j, arg, dims.toArray(new Dimension[0]));
                }
                if (name != null && !name.equals(this.natives_[i].name())) {
                    System.err.printf("// Error reading rtti.natives section. Native %d has different names. (\"%s\" != \"%s\")\n", new Object[]{i, this.natives_[i].name(), name});
                }
                this.natives_[i].setDebugInfo(type, args);
                ++i;
            }
            br.close();
        }
        for (String sectionName : variableDebugSections = new String[]{".dbg.globals", ".dbg.locals"}) {
            if (!this.sections_.containsKey(sectionName)) continue;
            sc = this.sections_.get(sectionName);
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            rt = new RttiListTable(br);
            locals = new LinkedList<Variable>();
            if (this.variables_ != null) {
                locals.addAll(Arrays.asList(this.variables_));
            }
            globals = new LinkedList<Variable>();
            if (this.globals_ != null) {
                globals.addAll(Arrays.asList(this.globals_));
            }
            i = 0;
            while ((long)i < rt.rowcount) {
                block103: {
                    block102: {
                        address = br.ReadInt32();
                        scopeByte = br.readByte();
                        scope = Scope.Local;
                        if (scopeByte >= 0 && scopeByte < Scope.values().length) {
                            scope = Scope.values()[scopeByte];
                        }
                        nameoffs = br.ReadUInt32();
                        codestart = br.ReadUInt32();
                        codeend = br.ReadUInt32();
                        typeid = br.ReadUInt32();
                        name = SourcePawnFile.ReadString(binary, (long)namesOffset + nameoffs);
                        type = TypeBuilder.TypeFromTypeId(this, (int)typeid);
                        dims = new LinkedList<Dimension>();
                        arrayType = type;
                        while (arrayType.isArrayType()) {
                            dims.add(0, new Dimension((int)arrayType.getData()));
                            arrayType = arrayType.getInnerType();
                        }
                        var = new Variable((long)address, codestart, codeend, type.toVariableType(), scope, name, dims.toArray(new Dimension[0]), type);
                        if (scope == Scope.Global) break block102;
                        locals.add(var);
                        break block103;
                    }
                    existingGlobal = null;
                    for (Variable glob : globals) {
                        if (!name.equals(glob.name())) continue;
                        existingGlobal = glob;
                        break;
                    }
                    if (existingGlobal == null) ** GOTO lbl497
                    if (existingGlobal.address() != (long)address) {
                        System.err.printf("// Duplicate information for symbol \"%s\" with different addresses. Keeping the existing at %x.%n", new Object[]{name, existingGlobal.address()});
                    } else {
                        globals.remove(existingGlobal);
lbl497:
                        // 2 sources

                        globals.add(var);
                    }
                }
                ++i;
            }
            br.close();
            Collections.sort(globals, new Comparator<Variable>(){

                @Override
                public int compare(Variable var1, Variable var2) {
                    return (int)(var1.address() - var2.address());
                }
            });
            this.variables_ = locals.toArray(new Variable[0]);
            this.globals_ = globals.toArray(new Variable[0]);
        }
        if (this.sections_.containsKey("rtti.methods")) {
            sc = this.sections_.get("rtti.methods");
            br = new ExtendedDataInputStream(new ByteArrayInputStream(binary, sc.dataoffs, sc.size));
            rt = new RttiListTable(br);
            functions = new LinkedList<Function>();
            if (this.functions_ != null) {
                functions.addAll(Arrays.asList(this.functions_));
            }
            i = 0;
            while ((long)i < rt.rowcount) {
                block101: {
                    nameoffs = br.ReadUInt32();
                    pcodeStart = br.ReadUInt32();
                    pcodeEnd = br.ReadUInt32();
                    signatureOffs = br.ReadUInt32();
                    name = SourcePawnFile.ReadString(binary, (long)namesOffset + nameoffs);
                    type = TypeBuilder.FunctionFromOffset(this, (int)signatureOffs);
                    func = new Function(pcodeStart, pcodeStart, pcodeEnd, name, type);
                    try {
                        this.findDuplicateFunction(name, func, functions);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        break block101;
                    }
                    args = new LinkedList<Argument>();
                    for (j = 0; j < type.getArguments().size(); ++j) {
                        arg = type.getArguments().get(j);
                        dims = new LinkedList<Dimension>();
                        arrayType = arg;
                        while (arrayType.isArrayType()) {
                            dims.add(0, new Dimension((int)arrayType.getData()));
                            arrayType = arrayType.getInnerType();
                        }
                        var = this.insertArgumentVar(func, j, arg, dims);
                        args.add(new Argument(var.type(), var.name(), arg, var.dims()));
                    }
                    func.setArguments(args);
                    functions.add(func);
                }
                ++i;
            }
            this.functions_ = functions.toArray(new Function[0]);
            br.close();
        }
    }

    private void findDuplicateFunction(String name, Function newFunction, LinkedList<Function> functions) throws Exception {
        Function existingFunction = null;
        for (Function func : functions) {
            if (name.equals(func.name())) {
                existingFunction = func;
                break;
            }
            if (func.name().endsWith(name) && func.name().matches("\\.\\d+\\..+")) {
                existingFunction = func;
                break;
            }
            Matcher pubMatcher = this.publicOperator.matcher(func.name());
            Matcher symMatcher = this.symbolsOperator.matcher(name);
            if (!pubMatcher.find() || !symMatcher.find() || !pubMatcher.group(2).equals(symMatcher.group(1))) continue;
            existingFunction = func;
            break;
        }
        if (existingFunction != null) {
            if (existingFunction.address() != newFunction.address() || existingFunction.codeStart() != newFunction.codeStart()) {
                throw new Exception(String.format("// Duplicate information for symbol \"%s\" at %x with different addresses. Keeping the existing at %x.%n", name, newFunction.address(), existingFunction.address()));
            }
            functions.remove(existingFunction);
        }
    }

    private Variable insertArgumentVar(Function func, int argNum, RttiType type, LinkedList<Dimension> dims) {
        long varAddr = 12 + argNum * 4;
        Variable var = this.lookupVariable(func.address(), varAddr);
        if (var != null) {
            if (type.isByRef()) {
                var.updateByRef();
            }
            return var;
        }
        Dimension[] dimarray = null;
        if (!dims.isEmpty()) {
            dimarray = dims.toArray(new Dimension[0]);
        }
        var = new Variable(varAddr, func.codeStart(), func.codeEnd(), type.toVariableType(), Scope.Local, "_arg" + argNum, dimarray, type);
        this.variables_ = Arrays.copyOf(this.variables_, this.variables_.length + 1);
        this.variables_[this.variables_.length - 1] = var;
        return var;
    }

    public InputStream getRTTIDataBytes() {
        Section sc = this.sections_.get("rtti.data");
        return new ByteArrayInputStream(this.binary_, sc.dataoffs, sc.size);
    }

    public String getEnumName(int index) {
        return this.enums_[index];
    }

    public Scope getScope(byte b) {
        switch (b) {
            case 0: {
                return Scope.Global;
            }
            case 1: {
                return Scope.Local;
            }
            case 2: {
                return Scope.Static;
            }
        }
        return null;
    }

    private void collectStructStringRanges() {
        for (PawnFile.PubVar pub : this.pubvars_) {
            long nameOffset;
            if (pub.name().equals("myinfo")) {
                nameOffset = this.int32FromData(pub.address() + 0L);
                long urlOffset = this.int32FromData(pub.address() + 16L);
                String url = this.stringFromData(urlOffset);
                this.stringRanges_.add(new AddressRange(nameOffset, urlOffset + (long)url.length()));
                this.stringRanges_.add(new AddressRange(pub.address(), pub.address() + 20L));
                continue;
            }
            if (pub.name().startsWith("__ext_") || pub.name().startsWith("__pl_")) {
                nameOffset = this.int32FromData(pub.address() + 0L);
                long fileOffset = this.int32FromData(pub.address() + 4L);
                String file = this.stringFromData(fileOffset);
                this.stringRanges_.add(new AddressRange(nameOffset, fileOffset + (long)file.length()));
                this.stringRanges_.add(new AddressRange(pub.address(), pub.address() + 16L));
                continue;
            }
            if (!pub.name().startsWith("__version")) continue;
            long fileversOffset = this.int32FromData(pub.address() + 4L);
            long timeOffset = this.int32FromData(pub.address() + 12L);
            String time = this.stringFromData(timeOffset);
            this.stringRanges_.add(new AddressRange(fileversOffset, timeOffset + (long)time.length()));
            this.stringRanges_.add(new AddressRange(pub.address(), pub.address() + 16L));
        }
    }

    @Override
    public boolean IsMaybeString(long address) {
        byte cell;
        if (!this.isValidDataAddress(address)) {
            return false;
        }
        for (AddressRange range : this.stringRanges_) {
            if (address < range.start || address >= range.end) continue;
            return false;
        }
        if (address > 0L && this.data().bytes()[(int)address - 1] != 0) {
            return false;
        }
        int len = 0;
        while (address < (long)this.data().bytes().length && (cell = this.data().bytes()[(int)address]) != 0) {
            if (!Character.isValidCodePoint(cell)) {
                return false;
            }
            ++address;
            ++len;
        }
        return len > 0;
    }

    @Override
    public String stringFromData(long address) {
        return SourcePawnFile.ReadString(this.data().bytes(), address);
    }

    @Override
    public String stringFromData(long address, int maxread) {
        return SourcePawnFile.ReadStringEx(this.data().bytes(), (int)address, maxread);
    }

    @Override
    public int int32FromData(long address) {
        assert (address >= 0L && (long)this.data().bytes().length > address);
        if (address >= 0L && (long)this.data().bytes().length <= address) {
            return 0;
        }
        return BitConverter.ToInt32(this.data().bytes(), (int)address);
    }

    @Override
    public float floatFromData(long address) {
        return BitConverter.ToSingle(this.data().bytes(), address);
    }

    @Override
    public boolean PassArgCountAsSize() {
        return false;
    }

    @Override
    public PawnFile.Automation lookupAutomation(long automation_id) {
        return null;
    }

    @Override
    public String lookupState(short state_id, short automation_id) {
        return null;
    }

    static {
        KNOWN_SECTIONS = new String[]{".code", ".data", ".publics", ".pubvars", ".natives", ".names", ".dbg.files", ".dbg.lines", ".dbg.info"};
        KNOWN_SECTIONS_LEGACY = new String[]{".tags", ".dbg.natives", ".dbg.strings", ".dbg.symbols"};
        KNOWN_SECTIONS_RTTI = new String[]{"rtti.data", "rtti.classdefs", "rtti.enums", "rtti.enumstructs", "rtti.enumstruct_fields", "rtti.fields", "rtti.methods", "rtti.natives", "rtti.typedefs", "rtti.typesets", ".dbg.locals", ".dbg.methods", ".dbg.globals"};
    }

    class AddressRange {
        public long start;
        public long end;

        public AddressRange(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }

    private class RttiListTable {
        public long headersize;
        public long rowsize;
        public long rowcount;

        public RttiListTable(ExtendedDataInputStream br) throws IOException {
            this.headersize = br.ReadUInt32();
            this.rowsize = br.ReadUInt32();
            this.rowcount = br.ReadUInt32();
        }
    }

    private class Section {
        public int nameoffs;
        public int dataoffs;
        public int size;
        public String name;

        public Section(int nameoffs, int dataoffs, int size, String name) {
            this.nameoffs = nameoffs;
            this.dataoffs = dataoffs;
            this.size = size;
            this.name = name;
        }
    }

    public class Header {
        public long magic;
        public long version;
        public Compression compression;
        public int disksize;
        public int imagesize;
        public int sections;
        public int stringtab;
        public int dataoffs;
    }

    public static enum Compression {
        None,
        Gzip;

    }
}

