/*
 * Decompiled with CFR 0.152.
 */
package lysis.types;

import lysis.lstructure.Argument;
import lysis.lstructure.Signature;
import lysis.lstructure.Variable;
import lysis.lstructure.VariableType;
import lysis.nodes.NodeBlock;
import lysis.nodes.NodeGraph;
import lysis.nodes.NodeList;
import lysis.nodes.NodeType;
import lysis.nodes.NodeVisitor;
import lysis.nodes.types.DArrayRef;
import lysis.nodes.types.DBinary;
import lysis.nodes.types.DBoundsCheck;
import lysis.nodes.types.DCall;
import lysis.nodes.types.DConstant;
import lysis.nodes.types.DDeclareLocal;
import lysis.nodes.types.DGenArray;
import lysis.nodes.types.DGlobal;
import lysis.nodes.types.DJump;
import lysis.nodes.types.DJumpCondition;
import lysis.nodes.types.DLoad;
import lysis.nodes.types.DLocalRef;
import lysis.nodes.types.DNode;
import lysis.nodes.types.DReturn;
import lysis.nodes.types.DStore;
import lysis.nodes.types.DString;
import lysis.nodes.types.DSysReq;
import lysis.types.CellType;
import lysis.types.PawnType;
import lysis.types.TypeSet;
import lysis.types.TypeUnit;

public class ForwardTypePropagation
extends NodeVisitor {
    private NodeGraph graph_;
    private NodeBlock block_;

    public ForwardTypePropagation(NodeGraph graph) {
        this.graph_ = graph;
    }

    public void propagate() throws Exception {
        for (int i = 0; i < this.graph_.numBlocks(); ++i) {
            this.block_ = this.graph_.blocks(i);
            NodeList.iterator iter = this.block_.nodes().begin();
            while (iter.more()) {
                iter.node().accept(this);
                iter.next();
            }
        }
    }

    @Override
    public void visit(DConstant node) {
    }

    @Override
    public void visit(DDeclareLocal local) {
        Variable var = this.graph_.file().lookupVariable(local.pc(), local.offset());
        local.setVariable(var);
        if (var != null) {
            TypeUnit tu = TypeUnit.FromVariable(var);
            assert (tu != null);
            local.addType(new TypeUnit(tu));
            if (local.value() != null && local.value().type() == NodeType.Constant && var.isFloat()) {
                TypeUnit rawType = null;
                if (var.tag() != null) {
                    rawType = TypeUnit.FromTag(var.tag());
                }
                if (var.rttiType() != null) {
                    rawType = TypeUnit.FromType(var.rttiType());
                }
                local.value().addType(rawType);
            }
        }
    }

    @Override
    public void visit(DLocalRef lref) {
        TypeSet localTypes = lref.local().typeSet();
        lref.addTypes(localTypes);
    }

    @Override
    public void visit(DJump jump) {
    }

    @Override
    public void visit(DJumpCondition jcc) {
        jcc.typeSet().addType(new TypeUnit(new PawnType(CellType.Bool)));
    }

    private void visitSignature(DNode call, Signature signature) throws Exception {
        int formatIndex;
        if (signature.args() == null) {
            return;
        }
        if (call.type() == NodeType.SysReq) {
            if (signature.args().length < 2) {
                return;
            }
            if (signature.args()[signature.args().length - 1].type() != VariableType.Variadic) {
                return;
            }
            if (!signature.args()[signature.args().length - 2].isString()) {
                return;
            }
            if (call.numOperands() == signature.args().length - 2) {
                return;
            }
            formatIndex = signature.args().length - 2;
        } else {
            if (signature.args().length == 0 || call.numOperands() <= signature.args().length) {
                return;
            }
            Argument formatArg = signature.args()[signature.args().length - 1];
            if (!formatArg.isString()) {
                return;
            }
            formatIndex = signature.args().length - 1;
        }
        DNode formatNode = call.getOperand(formatIndex);
        if (formatNode.type() != NodeType.DeclareLocal || formatNode.getOperand(0).type() != NodeType.String) {
            return;
        }
        String formatString = ((DString)formatNode.getOperand(0)).value();
        formatString = formatString.replace("%%", "");
        String[] parts = formatString.split("%");
        int argumentIndex = formatIndex + 1;
        block5: for (int i = 1; i < parts.length && argumentIndex < call.numOperands(); ++argumentIndex, ++i) {
            switch (parts[i].charAt(0)) {
                case 'f': {
                    DNode floatArg = call.getOperand(argumentIndex);
                    if (floatArg.typeSet().numTypes() != 0) continue block5;
                    floatArg.addType(new TypeUnit(new PawnType(CellType.Float)));
                    continue block5;
                }
                case 'T': 
                case 's': 
                case 't': {
                    DNode stringArg = call.getOperand(argumentIndex);
                    if (parts[i].charAt(0) == 'T') {
                        ++argumentIndex;
                    }
                    if (stringArg.typeSet().numTypes() != 0 || stringArg.type() == NodeType.Heap) continue block5;
                    stringArg.addType(new TypeUnit(new PawnType(signature.args()[formatIndex].tag()), 1));
                    continue block5;
                }
                case 'c': {
                    DNode charArg = call.getOperand(argumentIndex);
                    if (charArg.typeSet().numTypes() != 0) continue block5;
                    charArg.addType(new TypeUnit(new PawnType(CellType.Character)));
                    continue block5;
                }
            }
        }
    }

    @Override
    public void visit(DSysReq sysreq) throws Exception {
        this.visitSignature(sysreq, sysreq.nativeX());
    }

    @Override
    public void visit(DBinary binary) {
    }

    @Override
    public void visit(DBoundsCheck check) {
        check.getOperand(0).setUsedAsArrayIndex();
    }

    @Override
    public void visit(DArrayRef aref) {
        DNode abase = aref.abase();
        TypeSet baseTypes = abase.typeSet();
        for (int i = 0; i < baseTypes.numTypes(); ++i) {
            aref.addType(baseTypes.types(i));
        }
    }

    @Override
    public void visit(DStore store) {
        if (store.getOperand(0).typeSet().numTypes() == 1 && store.getOperand(1).type() == NodeType.Constant) {
            TypeUnit tu = store.getOperand(0).typeSet().types(0);
            if (tu.kind() == TypeUnit.Kind.Cell) {
                store.getOperand(1).addType(new TypeUnit(new PawnType(tu.type().type())));
            } else if (tu.kind() == TypeUnit.Kind.Reference) {
                store.getOperand(1).addType(new TypeUnit(new PawnType(tu.inner().type().type())));
            }
        }
    }

    @Override
    public void visit(DLoad load) {
        TypeSet fromTypes = load.from().typeSet();
        for (int i = 0; i < fromTypes.numTypes(); ++i) {
            TypeUnit tu = fromTypes.types(i);
            TypeUnit actual = tu.load();
            if (actual == null) {
                actual = tu;
            }
            load.addType(actual);
        }
    }

    @Override
    public void visit(DReturn ret) {
    }

    @Override
    public void visit(DGlobal global) {
        if (global.var() == null) {
            return;
        }
        TypeUnit tu = TypeUnit.FromVariable(global.var());
        global.addType(tu);
    }

    @Override
    public void visit(DString node) {
    }

    @Override
    public void visit(DCall call) throws Exception {
        this.visitSignature(call, call.function());
    }

    @Override
    public void visit(DGenArray genarray) throws Exception {
        Variable var = this.graph_.file().lookupVariable(genarray.pc(), genarray.offset());
        genarray.setVariable(var);
        for (int i = 0; i < genarray.numOperands(); ++i) {
            genarray.getOperand(i).accept(this);
        }
        if (var != null) {
            TypeUnit tu = TypeUnit.FromVariable(var);
            assert (tu != null);
            genarray.addType(new TypeUnit(tu));
        }
    }
}

