/*
 * Decompiled with CFR 0.152.
 */
package lysis.types;

import lysis.lstructure.Argument;
import lysis.lstructure.Function;
import lysis.lstructure.Tag;
import lysis.lstructure.Variable;
import lysis.types.CellType;
import lysis.types.PawnType;
import lysis.types.rtti.RttiType;

public class TypeUnit {
    private Kind kind_;
    private PawnType type_;
    private int dims_;
    private TypeUnit ref_;
    private RttiType rtti_type_;

    public TypeUnit(PawnType type) {
        this.kind_ = Kind.Cell;
        this.type_ = type;
    }

    public TypeUnit(PawnType type, int dims) {
        this.kind_ = Kind.Array;
        this.type_ = type;
        this.dims_ = dims;
    }

    public TypeUnit(TypeUnit other) {
        this.kind_ = Kind.Reference;
        this.ref_ = other;
    }

    public Kind kind() {
        return this.kind_;
    }

    public int dims() {
        assert (this.kind_ == Kind.Array);
        return this.dims_;
    }

    public PawnType type() {
        assert (this.kind_ == Kind.Cell || this.kind_ == Kind.Array);
        return this.type_;
    }

    public TypeUnit inner() {
        assert (this.kind_ == Kind.Reference);
        return this.ref_;
    }

    public TypeUnit load() {
        if (this.kind_ == Kind.Cell) {
            return null;
        }
        if (this.kind_ == Kind.Reference) {
            if (this.ref_.kind() == Kind.Array) {
                return this.ref_.load();
            }
            return this.ref_;
        }
        assert (this.kind_ == Kind.Array);
        if (this.dims_ == 1) {
            if (this.isString()) {
                return new TypeUnit(new PawnType(CellType.Character));
            }
            return new TypeUnit(this.type_);
        }
        return new TypeUnit(new TypeUnit(this.type_, this.dims_ - 1));
    }

    public boolean equalTo(TypeUnit other) {
        if (this.kind_ != other.kind_) {
            return false;
        }
        if (this.kind_ == Kind.Array && this.dims_ != other.dims_) {
            return false;
        }
        if (this.kind_ == Kind.Reference) {
            if (this.ref_ == null != (other.ref_ == null)) {
                return false;
            }
            if (this.ref_ != null && !this.ref_.equalTo(other.ref_)) {
                return false;
            }
        } else if (!this.type_.equalTo(other.type_)) {
            return false;
        }
        return true;
    }

    public boolean isString() {
        if (this.type_.type() == CellType.Tag && this.type_.tag().isString()) {
            return true;
        }
        return this.type_.type() == CellType.Character && this.dims_ == 1;
    }

    public static TypeUnit FromTag(Tag tag) {
        return new TypeUnit(new PawnType(tag));
    }

    public static TypeUnit FromType(RttiType type) {
        return new TypeUnit(new PawnType(type));
    }

    public static TypeUnit FromFunction(Function func) {
        if (func.returnType() != null) {
            return TypeUnit.FromType(func.returnType());
        }
        return TypeUnit.FromTag(func.returnTag());
    }

    public static TypeUnit FromVariable(Variable var) {
        if (var.rttiType() != null) {
            RttiType type = var.rttiType();
            switch (var.type()) {
                case Normal: {
                    return TypeUnit.FromType(type);
                }
                case Array: {
                    return new TypeUnit(new PawnType(type), var.dims().length);
                }
                case Reference: {
                    TypeUnit tu = new TypeUnit(new PawnType(type));
                    return new TypeUnit(tu);
                }
                case ArrayReference: {
                    TypeUnit tu = new TypeUnit(new PawnType(type), var.dims().length);
                    return new TypeUnit(tu);
                }
            }
            return null;
        }
        switch (var.type()) {
            case Normal: {
                return TypeUnit.FromTag(var.tag());
            }
            case Array: {
                return new TypeUnit(new PawnType(var.tag()), var.dims().length);
            }
            case Reference: {
                TypeUnit tu = new TypeUnit(new PawnType(var.tag()));
                return new TypeUnit(tu);
            }
            case ArrayReference: {
                TypeUnit tu = new TypeUnit(new PawnType(var.tag()), var.dims().length);
                return new TypeUnit(tu);
            }
        }
        return null;
    }

    public static TypeUnit FromArgument(Argument arg) {
        switch (arg.type()) {
            case Normal: {
                if (arg.rttiType() == null) {
                    return TypeUnit.FromTag(arg.tag());
                }
                return new TypeUnit(new PawnType(arg.rttiType()));
            }
            case Array: 
            case ArrayReference: {
                if (arg.rttiType() == null) {
                    return new TypeUnit(new PawnType(arg.tag()), arg.dimensions().length);
                }
                return new TypeUnit(new PawnType(arg.rttiType()), arg.dimensions().length);
            }
        }
        return null;
    }

    public static enum Kind {
        Cell,
        Reference,
        Array;

    }
}

