/*
 * Decompiled with CFR 0.152.
 */
package lysis.types.rtti;

import java.util.ArrayList;
import java.util.List;
import lysis.lstructure.VariableType;

public class RttiType {
    private boolean isConst_;
    private boolean isVariadic_;
    private boolean isByRef_;
    private byte typeflag_;
    private long data_;
    private RttiType innerType_;
    private ArrayList<RttiType> arguments_;

    public RttiType(byte typeflag) {
        this.typeflag_ = typeflag;
        this.data_ = 0L;
        this.isConst_ = false;
        this.isVariadic_ = false;
        this.isByRef_ = false;
        this.arguments_ = new ArrayList();
    }

    public byte getTypeFlag() {
        return this.typeflag_;
    }

    public boolean isArrayType() {
        return this.typeflag_ == 49 || this.typeflag_ == 48;
    }

    public boolean isString() {
        return this.getArrayBaseType().getTypeFlag() == 14;
    }

    public boolean isFloat() {
        return this.getArrayBaseType().getTypeFlag() == 12;
    }

    public RttiType getArrayBaseType() {
        RttiType type = this;
        while (type.isArrayType()) {
            type = type.getInnerType();
        }
        return type;
    }

    public void setConst() {
        this.isConst_ = true;
    }

    public boolean isConst() {
        return this.isConst_;
    }

    public void setVariadic() {
        this.isVariadic_ = true;
    }

    public boolean isVariadic() {
        return this.isVariadic_;
    }

    public void setByRef() {
        this.isByRef_ = true;
    }

    public boolean isByRef() {
        return this.isByRef_;
    }

    public void setInnerType(RttiType inner) {
        this.innerType_ = inner;
    }

    public RttiType getInnerType() {
        return this.innerType_;
    }

    public void addArgument(RttiType arg) {
        this.arguments_.add(arg);
    }

    public List<RttiType> getArguments() {
        return this.arguments_;
    }

    public void setData(long data) {
        this.data_ = data;
    }

    public long getData() {
        return this.data_;
    }

    public VariableType toVariableType() {
        if (this.isVariadic_) {
            return VariableType.Variadic;
        }
        if (this.isArrayType()) {
            if (this.isByRef_) {
                return VariableType.ArrayReference;
            }
            return VariableType.Array;
        }
        if (this.isByRef_) {
            return VariableType.Reference;
        }
        return VariableType.Normal;
    }

    public String toString() {
        String attributes = "";
        if (this.isConst_) {
            attributes = attributes + "const ";
        }
        if (this.isByRef_) {
            attributes = attributes + "&";
        }
        switch (this.typeflag_) {
            case 1: {
                return attributes + "bool";
            }
            case 6: {
                return attributes + "int";
            }
            case 12: {
                return attributes + "float";
            }
            case 14: {
                return attributes + "char";
            }
            case 16: {
                return attributes + "any";
            }
            case 17: {
                return attributes + "Function";
            }
            case 112: {
                return attributes + "void";
            }
            case 48: {
                return attributes + this.innerType_ + "[" + this.data_ + "]";
            }
            case 49: {
                return attributes + this.innerType_ + "[]";
            }
            case 66: {
                return attributes + "<enum " + this.data_ + ">";
            }
            case 67: {
                return attributes + "<typedef " + this.data_ + ">";
            }
            case 68: {
                return attributes + "<typeset " + this.data_ + ">";
            }
            case 69: {
                return attributes + "<classdef " + this.data_ + ">";
            }
            case 70: {
                return attributes + "<enumstruct " + this.data_ + ">";
            }
            case 50: {
                String signature = "function " + this.innerType_ + "(";
                for (int i = 0; i < this.arguments_.size(); ++i) {
                    if (i > 0) {
                        signature = signature + ", ";
                    }
                    signature = signature + this.arguments_.get(i);
                }
                if (this.isVariadic_) {
                    signature = signature + "...";
                }
                signature = signature + ")";
                return signature;
            }
        }
        return "<invalid type " + this.typeflag_ + ">";
    }
}

