/*
 * Decompiled with CFR 0.152.
 */
package lysis.types.rtti;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import lysis.ExtendedDataInputStream;
import lysis.sourcepawn.SourcePawnFile;
import lysis.types.rtti.RttiType;

public class TypeBuilder {
    private BufferedInputStream bufferedInput;
    private ExtendedDataInputStream dataInput;
    private boolean isConst;
    private static final int TYPEID_INLINE = 0;
    private static final int TYPEID_COMPLEX = 1;

    public static RttiType TypeFromTypeId(SourcePawnFile file, int typeid) throws IOException {
        int kind = typeid & 0xF;
        int payload = typeid >> 4 & 0xFFFFFFF;
        if (kind == 0) {
            byte[] array = new byte[]{(byte)(payload & 0xFF), (byte)(payload >> 8 & 0xFF), (byte)(payload >> 16 & 0xFF), (byte)(payload >> 24 & 0xFF)};
            ByteArrayInputStream bIn = new ByteArrayInputStream(array);
            return new TypeBuilder(file, bIn, 0).decodeNew();
        }
        if (kind == 1) {
            return new TypeBuilder(file, file.getRTTIDataBytes(), payload).decodeNew();
        }
        throw new IOException("Unknown type id kind: " + kind);
    }

    public static RttiType FunctionFromOffset(SourcePawnFile file, int offset) throws IOException {
        return new TypeBuilder(file, file.getRTTIDataBytes(), offset).decodeFunction();
    }

    public static RttiType TypesetFromOffset(SourcePawnFile file, int offset) throws IOException {
        return new TypeBuilder(file, file.getRTTIDataBytes(), offset).decodeTypeset();
    }

    public TypeBuilder(SourcePawnFile file, InputStream input, int offset) throws IOException {
        this.bufferedInput = new BufferedInputStream(input);
        this.dataInput = new ExtendedDataInputStream(this.bufferedInput);
        this.dataInput.skipBytes(offset);
    }

    public RttiType decodeNew() throws IOException {
        boolean wasConst = this.isConst;
        this.isConst = false;
        RttiType result = this.decode();
        if (this.isConst) {
            result.setConst();
        }
        this.isConst = wasConst;
        return result;
    }

    public RttiType decodeFunction() throws IOException {
        int argc = this.dataInput.readByte();
        RttiType func = new RttiType(50);
        if (this.match(113)) {
            func.setVariadic();
        }
        if (this.match(112)) {
            func.setInnerType(new RttiType(112));
        } else {
            func.setInnerType(this.decodeNew());
        }
        for (int i = 0; i < argc; ++i) {
            boolean isByRef = this.match(114);
            RttiType arg = this.decodeNew();
            if (isByRef) {
                arg.setByRef();
            }
            func.addArgument(arg);
        }
        return func;
    }

    public RttiType decodeTypeset() throws IOException {
        RttiType typeset = new RttiType(68);
        long count = this.decodeUint32();
        int i = 0;
        while ((long)i < count) {
            typeset.addArgument(this.decodeNew());
            ++i;
        }
        return typeset;
    }

    private RttiType decode() throws IOException {
        this.isConst = this.match(115) || this.isConst;
        byte typeFlag = this.dataInput.readByte();
        switch (typeFlag) {
            case 1: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                return new RttiType(typeFlag);
            }
            case 48: {
                RttiType type = new RttiType(typeFlag);
                type.setData(this.decodeUint32());
                type.setInnerType(this.decode());
                return type;
            }
            case 49: {
                RttiType type = new RttiType(typeFlag);
                type.setInnerType(this.decode());
                return type;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                RttiType type = new RttiType(typeFlag);
                type.setData(this.decodeUint32());
                return type;
            }
            case 50: {
                return this.decodeFunction();
            }
        }
        throw new IOException("Invalid RTTI type flag: " + typeFlag);
    }

    private boolean match(int flag) throws IOException {
        this.bufferedInput.mark(1);
        if (this.dataInput.readByte() != flag) {
            this.bufferedInput.reset();
            return false;
        }
        return true;
    }

    private long decodeUint32() throws IOException {
        long value = 0L;
        int shift = 0;
        while (true) {
            byte b = this.dataInput.readByte();
            value |= (long)((b & 0x7F) << shift);
            if ((b & 0x80) == 0) break;
            shift += 7;
        }
        return value;
    }
}

